/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.ReaderImpl;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionReaderImpl<T>
extends ReaderImpl<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompactionReaderImpl.class);
    ConsumerBase<T> consumer;
    ReaderConfigurationData<T> readerConfiguration;

    private CompactionReaderImpl(PulsarClientImpl client, ReaderConfigurationData<T> readerConfiguration, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> consumerFuture, Schema<T> schema) {
        super(client, readerConfiguration, executorProvider, consumerFuture, schema);
        this.readerConfiguration = readerConfiguration;
        this.consumer = this.getConsumer();
    }

    public static <T> CompactionReaderImpl<T> create(PulsarClientImpl client, Schema<T> schema, String topic, CompletableFuture<Consumer<T>> consumerFuture, CryptoKeyReader cryptoKeyReader) {
        ReaderConfigurationData conf = new ReaderConfigurationData();
        conf.setTopicName(topic);
        conf.setSubscriptionName("__compaction");
        conf.setStartMessageId(MessageId.earliest);
        conf.setStartMessageFromRollbackDurationInSec(0L);
        conf.setReadCompacted(true);
        conf.setSubscriptionMode(SubscriptionMode.Durable);
        conf.setSubscriptionInitialPosition(SubscriptionInitialPosition.Earliest);
        conf.setCryptoKeyReader(cryptoKeyReader);
        return new CompactionReaderImpl<T>(client, conf, client.externalExecutorProvider(), consumerFuture, schema);
    }

    public Message<T> readNext() throws PulsarClientException {
        return this.consumer.receive();
    }

    public Message<T> readNext(int timeout, TimeUnit unit) throws PulsarClientException {
        return this.consumer.receive(timeout, unit);
    }

    public CompletableFuture<Message<T>> readNextAsync() {
        return this.consumer.receiveAsync();
    }

    public CompletableFuture<MessageId> getLastMessageIdAsync() {
        return this.consumer.getLastMessageIdAsync();
    }

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId messageId, Map<String, Long> properties) {
        return this.consumer.doAcknowledge(messageId, CommandAck.AckType.Cumulative, properties, null);
    }
}

