/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.common.util.collections.LongPairSet;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class ConcurrentBitmapSortedLongPairSet {
    private final NavigableMap<Long, RoaringBitmap> map = new TreeMap<Long, RoaringBitmap>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long item1, long item2) {
        this.lock.writeLock().lock();
        try {
            RoaringBitmap bitSet = this.map.computeIfAbsent(item1, k -> new RoaringBitmap());
            bitSet.add(item2, item2 + 1L);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long item1, long item2) {
        this.lock.writeLock().lock();
        try {
            RoaringBitmap bitSet = (RoaringBitmap)this.map.get(item1);
            if (bitSet != null) {
                bitSet.remove(item2, item2 + 1L);
                if (bitSet.isEmpty()) {
                    this.map.remove(item1, bitSet);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long item1, long item2) {
        this.lock.readLock().lock();
        try {
            RoaringBitmap bitSet = (RoaringBitmap)this.map.get(item1);
            boolean bl = bitSet != null && bitSet.contains(item2, item2 + 1L);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpTo(long item1, long item2) {
        this.lock.writeLock().lock();
        try {
            Map.Entry<Long, RoaringBitmap> firstEntry = this.map.firstEntry();
            while (firstEntry != null && firstEntry.getKey() <= item1) {
                if (firstEntry.getKey() >= item1) {
                    RoaringBitmap bitSet = firstEntry.getValue();
                    if (bitSet != null) {
                        bitSet.remove(0L, item2);
                        if (bitSet.isEmpty()) {
                            this.map.remove(firstEntry.getKey(), bitSet);
                        }
                    }
                    break;
                }
                this.map.remove(firstEntry.getKey(), firstEntry.getValue());
                firstEntry = this.map.firstEntry();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Comparable<T>> NavigableSet<T> items(int numberOfItems, LongPairSet.LongPairFunction<T> longPairConverter) {
        TreeSet<Comparable> items = new TreeSet<Comparable>();
        this.lock.readLock().lock();
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                PeekableIntIterator intIterator = ((RoaringBitmap)entry.getValue()).getIntIterator();
                while (intIterator.hasNext() && items.size() < numberOfItems) {
                    items.add((Comparable)longPairConverter.apply(((Long)entry.getKey()).longValue(), Integer.toUnsignedLong(intIterator.next())));
                }
                if (items.size() != numberOfItems) continue;
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return items;
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.map.isEmpty() || this.map.values().stream().allMatch(RoaringBitmap::isEmpty);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.map.isEmpty() ? 0 : this.map.values().stream().mapToInt(RoaringBitmap::getCardinality).sum();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

