/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Summary;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionStats {
    private final String name;
    private final String dimensionSumLabel;
    private final String dimensionCountLabel;
    private final Summary summary;
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99, 0.999, 0.9999};
    private static final List<String> QUANTILE_LABEL = Collections.unmodifiableList(Arrays.asList("quantile"));
    private static final List<List<String>> QUANTILE_LABEL_VALUES = Collections.unmodifiableList(Arrays.stream(QUANTILES).mapToObj(Collector::doubleToGoString).map(Collections::singletonList).collect(Collectors.toList()));
    private static final Logger log = LoggerFactory.getLogger(DimensionStats.class);

    public DimensionStats(String name, long updateDurationInSec) {
        this(name, updateDurationInSec, true);
    }

    DimensionStats(String name, long updateDurationInSec, boolean register) {
        this.name = name;
        this.dimensionSumLabel = name + "_sum";
        this.dimensionCountLabel = name + "_count";
        Summary.Builder summaryBuilder = (Summary.Builder)((Summary.Builder)Summary.build().name(name)).help("-");
        for (int i = 0; i < QUANTILES.length; ++i) {
            summaryBuilder.quantile(QUANTILES[i], 0.01);
        }
        this.summary = summaryBuilder.maxAgeSeconds(updateDurationInSec).create();
        if (register) {
            try {
                CollectorRegistry.defaultRegistry.register((Collector)this.summary);
            }
            catch (IllegalArgumentException ie) {
                log.warn("{} is already registred {}", (Object)name, (Object)ie.getMessage());
            }
        }
    }

    public void recordDimensionTimeValue(long latency, TimeUnit unit) {
        this.summary.observe((double)unit.toMillis(latency));
    }

    public DimensionStatsSnapshot getSnapshot() {
        return new DimensionStatsSnapshot(this.summary.collect());
    }

    public void reset() {
        this.summary.clear();
    }

    public class DimensionStatsSnapshot {
        private final List<Collector.MetricFamilySamples> samples;

        public DimensionStatsSnapshot(List<Collector.MetricFamilySamples> samples) {
            this.samples = samples;
        }

        public double getMeanDimension() {
            double sum = this.getDimensionSum();
            double count = this.getDimensionCount();
            if (!Double.isNaN(sum) && !Double.isNaN(count)) {
                return sum / count;
            }
            return 0.0;
        }

        public double getMedianDimension() {
            return this.getQuantile(QUANTILE_LABEL_VALUES.get(0));
        }

        public double getDimension75() {
            return this.getQuantile(QUANTILE_LABEL_VALUES.get(1));
        }

        public double getDimension95() {
            return this.getQuantile(QUANTILE_LABEL_VALUES.get(2));
        }

        public double getDimension99() {
            return this.getQuantile(QUANTILE_LABEL_VALUES.get(3));
        }

        public double getDimension999() {
            return this.getQuantile(QUANTILE_LABEL_VALUES.get(4));
        }

        public double getDimension9999() {
            return this.getQuantile(QUANTILE_LABEL_VALUES.get(5));
        }

        public double getDimensionSum() {
            return this.getSampleValue(DimensionStats.this.dimensionSumLabel);
        }

        public double getDimensionCount() {
            return this.getSampleValue(DimensionStats.this.dimensionCountLabel);
        }

        private double getQuantile(List<String> labelValues) {
            return this.getSampleValue(DimensionStats.this.name, QUANTILE_LABEL, labelValues);
        }

        private double getSampleValue(String name) {
            return this.getSampleValue(name, Collections.emptyList(), Collections.emptyList());
        }

        private double getSampleValue(String name, List<String> labelNames, List<String> labelValues) {
            for (Collector.MetricFamilySamples metricFamilySamples : this.samples) {
                for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                    if (!sample.name.equals(name) || !sample.labelNames.equals(labelNames) || !sample.labelValues.equals(labelValues)) continue;
                    return sample.value;
                }
            }
            return 0.0;
        }
    }
}

