/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.component.ComponentStarter;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.apache.pulsar.common.util.DirectMemoryUtils;
import org.apache.pulsar.common.util.ShutdownUtil;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.service.WorkerServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarBrokerStarter {
    private static final Logger log = LoggerFactory.getLogger(PulsarBrokerStarter.class);

    private static ServiceConfiguration loadConfig(String configFile) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            ServiceConfiguration config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)inputStream, ServiceConfiguration.class);
            PulsarConfigurationLoader.isComplete((Object)config);
            ServiceConfiguration serviceConfiguration = config;
            return serviceConfiguration;
        }
    }

    private static ServerConfiguration readBookieConfFile(String bookieConfigFile) throws IllegalArgumentException {
        ServerConfiguration bookieConf = new ServerConfiguration();
        try {
            bookieConf.loadConf(new File(bookieConfigFile).toURI().toURL());
            bookieConf.validate();
            log.info("Using bookie configuration file {}", (Object)bookieConfigFile);
        }
        catch (MalformedURLException e) {
            log.error("Could not open configuration file: {}", (Object)bookieConfigFile, (Object)e);
            throw new IllegalArgumentException("Could not open configuration file");
        }
        catch (ConfigurationException e) {
            log.error("Malformed configuration file: {}", (Object)bookieConfigFile, (Object)e);
            throw new IllegalArgumentException("Malformed configuration file");
        }
        if ((long)bookieConf.getMaxPendingReadRequestPerThread() < bookieConf.getRereplicationEntryBatchSize()) {
            throw new IllegalArgumentException("rereplicationEntryBatchSize should be smaller than maxPendingReadRequestPerThread");
        }
        return bookieConf;
    }

    private static boolean argsContains(String[] args, String arg) {
        return Arrays.asList(args).contains(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FixedDateFormat.FixedFormat.ISO8601_OFFSET_DATE_TIME_HHMM.getPattern());
        Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> {
            System.out.println(String.format("%s [%s] error Uncaught exception in thread %s: %s", dateFormat.format(new Date()), thread.getContextClassLoader(), thread.getName(), exception.getMessage()));
            exception.printStackTrace(System.out);
        });
        BrokerStarter starter = new BrokerStarter(args);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                starter.shutdown();
            }
            catch (Throwable t) {
                log.error("Error while shutting down Pulsar service", t);
            }
            finally {
                LogManager.shutdown();
            }
        }, "pulsar-service-shutdown"));
        PulsarByteBufAllocator.registerOOMListener(oomException -> {
            if (starter.brokerConfig.isSkipBrokerShutdownOnOOM()) {
                log.error("-- Received OOM exception: {}", (Object)oomException.getMessage(), oomException);
            } else {
                log.error("-- Shutting down - Received OOM exception: {}", (Object)oomException.getMessage(), oomException);
                starter.pulsarService.shutdownNow();
            }
        });
        try {
            starter.start();
        }
        catch (Throwable t) {
            log.error("Failed to start pulsar service.", t);
            ShutdownUtil.triggerImmediateForcefulShutdown();
        }
        finally {
            starter.join();
        }
    }

    private static class BrokerStarter {
        private final ServiceConfiguration brokerConfig;
        private final PulsarService pulsarService;
        private final LifecycleComponent bookieServer;
        private volatile CompletableFuture<Void> bookieStartFuture;
        private final AutoRecoveryMain autoRecoveryMain;
        private final StatsProvider bookieStatsProvider;
        private final ServerConfiguration bookieConfig;
        private final WorkerService functionsWorkerService;
        private final WorkerConfig workerConfig;

        BrokerStarter(String[] args) throws Exception {
            String filepath;
            StarterArguments starterArguments = new StarterArguments();
            JCommander jcommander = new JCommander((Object)starterArguments);
            jcommander.setProgramName("PulsarBrokerStarter");
            jcommander.parse(args);
            if (starterArguments.help) {
                jcommander.usage();
                System.exit(0);
            }
            if (starterArguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("broker", (Object)starterArguments);
                cmd.run(null);
                System.exit(0);
            }
            if (StringUtils.isBlank((CharSequence)starterArguments.brokerConfigFile)) {
                jcommander.usage();
                throw new IllegalArgumentException("Need to specify a configuration file for broker");
            }
            String filepath2 = Path.of(starterArguments.brokerConfigFile, new String[0]).toAbsolutePath().normalize().toString();
            this.brokerConfig = PulsarBrokerStarter.loadConfig(filepath2);
            int maxFrameSize = this.brokerConfig.getMaxMessageSize() + 10240;
            if ((long)maxFrameSize >= DirectMemoryUtils.jvmMaxDirectMemory()) {
                throw new IllegalArgumentException("Max message size need smaller than jvm directMemory");
            }
            if (!NamespaceBundleSplitAlgorithm.AVAILABLE_ALGORITHMS.containsAll(this.brokerConfig.getSupportedNamespaceBundleSplitAlgorithms())) {
                throw new IllegalArgumentException("The given supported namespace bundle split algorithm has unavailable algorithm. Available algorithms are " + String.valueOf(NamespaceBundleSplitAlgorithm.AVAILABLE_ALGORITHMS));
            }
            if (!this.brokerConfig.getSupportedNamespaceBundleSplitAlgorithms().contains(this.brokerConfig.getDefaultNamespaceBundleSplitAlgorithm())) {
                throw new IllegalArgumentException("Supported namespace bundle split algorithms must contains the default namespace bundle split algorithm");
            }
            if (starterArguments.runFunctionsWorker || this.brokerConfig.isFunctionsWorkerEnabled()) {
                filepath = Path.of(starterArguments.fnWorkerConfigFile, new String[0]).toAbsolutePath().normalize().toString();
                this.workerConfig = PulsarService.initializeWorkerConfigFromBrokerConfig(this.brokerConfig, filepath);
                this.functionsWorkerService = WorkerServiceLoader.load((WorkerConfig)this.workerConfig);
            } else {
                this.workerConfig = null;
                this.functionsWorkerService = null;
            }
            this.pulsarService = new PulsarService(this.brokerConfig, this.workerConfig, Optional.ofNullable(this.functionsWorkerService), exitCode -> {
                log.info("Halting broker process with code {}", exitCode);
                ShutdownUtil.triggerImmediateForcefulShutdown((int)exitCode);
            });
            if (!PulsarBrokerStarter.argsContains(args, "-rb") && !PulsarBrokerStarter.argsContains(args, "--run-bookie")) {
                Preconditions.checkState((!starterArguments.runBookie ? 1 : 0) != 0, (Object)"runBookie should be false if has no argument specified");
                starterArguments.runBookie = this.brokerConfig.isEnableRunBookieTogether();
            }
            if (!PulsarBrokerStarter.argsContains(args, "-ra") && !PulsarBrokerStarter.argsContains(args, "--run-bookie-autorecovery")) {
                Preconditions.checkState((!starterArguments.runBookieAutoRecovery ? 1 : 0) != 0, (Object)"runBookieAutoRecovery should be false if has no argument specified");
                starterArguments.runBookieAutoRecovery = this.brokerConfig.isEnableRunBookieAutoRecoveryTogether();
            }
            if ((starterArguments.runBookie || starterArguments.runBookieAutoRecovery) && StringUtils.isBlank((CharSequence)starterArguments.bookieConfigFile)) {
                jcommander.usage();
                throw new IllegalArgumentException("No configuration file for Bookie");
            }
            if (starterArguments.runBookie || starterArguments.runBookieAutoRecovery) {
                Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)starterArguments.bookieConfigFile), (Object)"No configuration file for Bookie");
                filepath = Path.of(starterArguments.bookieConfigFile, new String[0]).toAbsolutePath().normalize().toString();
                this.bookieConfig = PulsarBrokerStarter.readBookieConfFile(filepath);
                Class statsProviderClass = this.bookieConfig.getStatsProviderClass();
                this.bookieStatsProvider = (StatsProvider)ReflectionUtils.newInstance((Class)statsProviderClass);
            } else {
                this.bookieConfig = null;
                this.bookieStatsProvider = null;
            }
            if (starterArguments.runBookie) {
                Objects.requireNonNull(this.bookieConfig, "No ServerConfiguration for Bookie");
                Objects.requireNonNull(this.bookieStatsProvider, "No Stats Provider for Bookie");
                this.bookieServer = Main.buildBookieServer((BookieConfiguration)new BookieConfiguration(this.bookieConfig));
            } else {
                this.bookieServer = null;
            }
            if (starterArguments.runBookieAutoRecovery) {
                Objects.requireNonNull(this.bookieConfig, "No ServerConfiguration for Bookie Autorecovery");
                this.autoRecoveryMain = new AutoRecoveryMain(this.bookieConfig);
            } else {
                this.autoRecoveryMain = null;
            }
        }

        public void start() throws Exception {
            if (this.bookieStatsProvider != null) {
                this.bookieStatsProvider.start((Configuration)this.bookieConfig);
                log.info("started bookieStatsProvider.");
            }
            if (this.bookieServer != null) {
                this.bookieStartFuture = ComponentStarter.startComponent((LifecycleComponent)this.bookieServer);
                log.info("started bookieServer.");
            }
            if (this.autoRecoveryMain != null) {
                this.autoRecoveryMain.start();
                log.info("started bookie autoRecoveryMain.");
            }
            this.pulsarService.start();
            log.info("PulsarService started.");
        }

        public void join() throws InterruptedException {
            this.pulsarService.waitUntilClosed();
            try {
                this.pulsarService.close();
            }
            catch (PulsarServerException e) {
                throw new RuntimeException();
            }
            if (this.bookieStartFuture != null) {
                this.bookieStartFuture.join();
                this.bookieStartFuture = null;
            }
            if (this.autoRecoveryMain != null) {
                this.autoRecoveryMain.join();
            }
        }

        public void shutdown() throws Exception {
            if (null != this.functionsWorkerService) {
                this.functionsWorkerService.stop();
                log.info("Shut down functions worker service successfully.");
            }
            this.pulsarService.close();
            log.info("Shut down broker service successfully.");
            if (this.bookieStatsProvider != null) {
                this.bookieStatsProvider.stop();
                log.info("Shut down bookieStatsProvider successfully.");
            }
            if (this.bookieServer != null) {
                this.bookieServer.close();
                log.info("Shut down bookieServer successfully.");
            }
            if (this.autoRecoveryMain != null) {
                this.autoRecoveryMain.shutdown();
                log.info("Shut down autoRecoveryMain successfully.");
            }
        }
    }

    @Parameters(commandDescription="Options")
    @VisibleForTesting
    private static class StarterArguments {
        @Parameter(names={"-c", "--broker-conf"}, description="Configuration file for Broker")
        private String brokerConfigFile = "conf/broker.conf";
        @Parameter(names={"-rb", "--run-bookie"}, description="Run Bookie together with Broker")
        private boolean runBookie = false;
        @Parameter(names={"-ra", "--run-bookie-autorecovery"}, description="Run Bookie Autorecovery together with broker")
        private boolean runBookieAutoRecovery = false;
        @Parameter(names={"-bc", "--bookie-conf"}, description="Configuration file for Bookie")
        private String bookieConfigFile = "conf/bookkeeper.conf";
        @Parameter(names={"-rfw", "--run-functions-worker"}, description="Run functions worker with Broker")
        private boolean runFunctionsWorker = false;
        @Parameter(names={"-fwc", "--functions-worker-conf"}, description="Configuration file for Functions Worker")
        private String fnWorkerConfigFile = "conf/functions_worker.yml";
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;
        @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
        private boolean generateDocs = false;

        private StarterArguments() {
        }
    }
}

