/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ActiveManagedCursorContainer;
import org.apache.commons.lang3.tuple.Pair;

public class ActiveManagedCursorContainerNavigableSetImpl
implements ActiveManagedCursorContainer {
    private final AtomicInteger addOrderCounter = new AtomicInteger(0);
    private final NavigableSet<Item> sortedByPosition = new TreeSet<Item>();
    private final ConcurrentMap<String, Item> cursors = new ConcurrentHashMap<String, Item>();
    private final StampedLock rwLock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ManagedCursor cursor, Position position) {
        long stamp = this.rwLock.writeLock();
        try {
            Item item = new Item(cursor, position, this.addOrderCounter.getAndIncrement());
            this.cursors.put(cursor.getName(), item);
            if (position != null) {
                this.sortedByPosition.add(item);
            }
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedCursor get(String name) {
        long stamp = this.rwLock.readLock();
        try {
            Item item = (Item)this.cursors.get(name);
            ManagedCursor managedCursor = item != null ? item.cursor : null;
            return managedCursor;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCursor(String name) {
        long stamp = this.rwLock.writeLock();
        try {
            Item item = (Item)this.cursors.remove(name);
            if (item != null) {
                if (item.position != null) {
                    this.sortedByPosition.remove(item);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Position, Position> cursorUpdated(ManagedCursor cursor, Position newPosition) {
        Objects.requireNonNull(cursor);
        long stamp = this.rwLock.writeLock();
        try {
            Item item = (Item)this.cursors.get(cursor.getName());
            if (item == null) {
                Pair<Position, Position> pair = null;
                return pair;
            }
            Position previousSlowestConsumer = this.internalSlowestReaderPosition();
            if (item.position != null) {
                this.sortedByPosition.remove(item);
            }
            item.position = newPosition;
            if (newPosition != null) {
                this.sortedByPosition.add(item);
            }
            Position newSlowestConsumer = this.internalSlowestReaderPosition();
            Pair pair = Pair.of((Object)previousSlowestConsumer, (Object)newSlowestConsumer);
            return pair;
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    @Override
    public void updateCursor(ManagedCursor cursor, Position newPosition) {
        this.cursorUpdated(cursor, newPosition);
    }

    private Position internalSlowestReaderPosition() {
        return !this.sortedByPosition.isEmpty() ? ((Item)this.sortedByPosition.first()).position : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Position getSlowestCursorPosition() {
        long stamp = this.rwLock.readLock();
        try {
            Position position = this.internalSlowestReaderPosition();
            return position;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isEmpty = this.cursors.isEmpty();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isEmpty = this.cursors.isEmpty();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long stamp = this.rwLock.readLock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            boolean first = true;
            for (Item item : this.cursors.values()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(item.cursor);
            }
            sb.append(']');
            String string = sb.toString();
            return string;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    @Override
    public Iterator<ManagedCursor> iterator() {
        final Iterator it = this.cursors.entrySet().iterator();
        return new Iterator<ManagedCursor>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public ManagedCursor next() {
                return ((Item)((Map.Entry)it.next()).getValue()).cursor;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("Cannot remove ManagedCursor from container");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfCursorsAtSamePositionOrBefore(ManagedCursor cursor) {
        long stamp = this.rwLock.readLock();
        try {
            Item item = (Item)this.cursors.get(cursor.getName());
            if (item == null || item.position == null) {
                int n = 0;
                return n;
            }
            int count = 0;
            for (Item o : this.sortedByPosition) {
                if (o.position.compareTo(item.position) > 0) break;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.rwLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long stamp = this.rwLock.tryOptimisticRead();
        int size = this.cursors.size();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                size = this.cursors.size();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return size;
    }

    @VisibleForTesting
    void checkOrderingAndNumberOfCursorsState() {
        int currentCount = 0;
        Position lastPosition = null;
        ArrayList<String> lastPositionCursorNames = new ArrayList<String>();
        Item previousItem = null;
        for (Item o : this.sortedByPosition) {
            ++currentCount;
            if (lastPosition != null && o.position.compareTo(lastPosition) > 0) {
                int expectedCount = currentCount - 1;
                int numberOfCursorsAtSamePositionOrBefore = this.getNumberOfCursorsAtSamePositionOrBefore(previousItem.cursor);
                if (numberOfCursorsAtSamePositionOrBefore != expectedCount) {
                    throw new IllegalStateException("Number of cursors at same position is not correct for position " + String.valueOf(previousItem.position) + ": expected " + expectedCount + ", but got " + numberOfCursorsAtSamePositionOrBefore + " for cursors " + String.valueOf(lastPositionCursorNames));
                }
                lastPositionCursorNames.clear();
            }
            lastPosition = o.position;
            lastPositionCursorNames.add(o.cursor.getName());
            previousItem = o;
        }
        if (lastPosition != null) {
            int expectedCount = currentCount;
            int numberOfCursorsAtSamePositionOrBefore = this.getNumberOfCursorsAtSamePositionOrBefore(previousItem.cursor);
            if (numberOfCursorsAtSamePositionOrBefore != expectedCount) {
                throw new IllegalStateException("Number of cursors at same position is not correct for position " + String.valueOf(previousItem.position) + ": expected " + expectedCount + ", but got " + numberOfCursorsAtSamePositionOrBefore + " for cursors " + String.valueOf(lastPositionCursorNames));
            }
        }
    }

    private static class Item
    implements Comparable<Item> {
        final ManagedCursor cursor;
        final int addOrder;
        Position position;

        Item(ManagedCursor cursor, Position position, int addOrder) {
            this.cursor = cursor;
            this.addOrder = addOrder;
            this.position = position;
        }

        @Override
        public int compareTo(Item o) {
            int positionComparison = this.position.compareTo(o.position);
            if (positionComparison != 0) {
                return positionComparison;
            }
            return Integer.compare(this.addOrder, o.addOrder);
        }
    }
}

