/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.Invokable;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.TypeToken;
import org.apache.pulsar.jcloud.shade.com.google.inject.Binding;
import org.apache.pulsar.jcloud.shade.com.google.inject.ConfigurationException;
import org.apache.pulsar.jcloud.shade.com.google.inject.Injector;
import org.apache.pulsar.jcloud.shade.com.google.inject.Key;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.ProvisionException;
import org.apache.pulsar.jcloud.shade.com.google.inject.util.Types;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Qualifier;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.lifecycle.Closer;
import org.jclouds.reflect.FunctionalReflection;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.InvocationSuccess;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.config.SetCaller;
import org.jclouds.util.Optionals2;
import org.jclouds.util.Throwables2;

@Beta
public class DelegatesToInvocationFunction<S, F extends Function<Invocation, Object>>
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Invokable<?, ?> CLOSE;
    protected final Injector injector;
    protected final TypeToken<S> ownerType;
    protected final SetCaller setCaller;
    protected final Function<InvocationSuccess, Optional<Object>> optionalConverter;
    protected final F methodInvoker;
    static final Predicate<Annotation> isQualifierPresent;

    @Override
    public final Object invoke(Object proxy, Method invoked, @Nullable Object[] argv) throws Throwable {
        if (argv == null) {
            argv = NO_ARGS;
        }
        if (argv.length == 0 && invoked.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (argv.length == 1 && invoked.getName().equals("equals") && invoked.getParameterTypes()[0] == Object.class) {
            Object arg = argv[0];
            return proxy.getClass().isInstance(arg) && this.equals(Proxy.getInvocationHandler(arg));
        }
        if (argv.length == 0 && invoked.getName().equals("toString")) {
            return this.toString();
        }
        List<Object> args = Arrays.asList(argv);
        args = Iterables.all(args, Predicates.notNull()) ? ImmutableList.copyOf(args) : Collections.unmodifiableList(args);
        Invokable invokable = Reflection2.method(this.ownerType, invoked);
        Invocation invocation = Invocation.create(invokable, args);
        try {
            return this.handle(invocation);
        }
        catch (Throwable e) {
            Throwables2.propagateIfPossible(e, invocation.getInvokable().getExceptionTypes());
            throw e;
        }
    }

    protected Object handle(Invocation invocation) {
        Invokable<?, ?> invokable = invocation.getInvokable();
        if (DelegatesToInvocationFunction.isCloseMethod(invokable)) {
            try {
                this.injector.getInstance(Closer.class).close();
                return null;
            }
            catch (Throwable e) {
                throw Throwables.propagate(e);
            }
        }
        if (invokable.isAnnotationPresent(Provides.class)) {
            return this.lookupValueFromGuice(invokable);
        }
        if (invokable.isAnnotationPresent(Delegate.class)) {
            return this.propagateContextToDelegate(invocation);
        }
        return this.methodInvoker.apply((Invocation)invocation);
    }

    private static boolean isCloseMethod(Invokable<?, ?> invokable) {
        return CLOSE.getDeclaringClass().equals(invokable.getDeclaringClass()) && CLOSE.getName().equals(invokable.getName()) && CLOSE.getParameters().equals(invokable.getParameters()) && CLOSE.getReturnType().equals(invokable.getReturnType());
    }

    @Inject
    DelegatesToInvocationFunction(Injector injector, SetCaller setCaller, Class<S> ownerType, Function<InvocationSuccess, Optional<Object>> optionalConverter, F methodInvoker) {
        this.injector = Preconditions.checkNotNull(injector, "injector");
        this.ownerType = Reflection2.typeToken(Preconditions.checkNotNull(ownerType, "ownerType"));
        this.setCaller = Preconditions.checkNotNull(setCaller, "setCaller");
        this.optionalConverter = Preconditions.checkNotNull(optionalConverter, "optionalConverter");
        this.methodInvoker = (Function)Preconditions.checkNotNull(methodInvoker, "methodInvoker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object propagateContextToDelegate(Invocation caller) {
        Function delegate;
        Class<?> returnType = Optionals2.unwrapIfOptional(caller.getInvokable().getReturnType());
        this.setCaller.enter(caller);
        try {
            Key<?> delegateType = this.methodInvokerFor(returnType);
            delegate = (Function)this.injector.getInstance(delegateType);
        }
        finally {
            this.setCaller.exit();
        }
        Object result = FunctionalReflection.newProxy(returnType, (Function<Invocation, Object>)delegate);
        if (Optionals2.isReturnTypeOptional(caller.getInvokable())) {
            result = this.optionalConverter.apply(InvocationSuccess.create(caller, result));
        }
        return result;
    }

    protected Key<?> methodInvokerFor(Class<?> returnType) {
        switch (this.methodInvoker.getClass().getTypeParameters().length) {
            case 0: {
                return Key.get(this.methodInvoker.getClass());
            }
            case 1: {
                return Key.get(Types.newParameterizedType(this.methodInvoker.getClass(), returnType));
            }
        }
        throw new IllegalArgumentException(returnType + " has too many type parameters");
    }

    private Object lookupValueFromGuice(Invokable<?, ?> invoked) {
        try {
            Type genericReturnType = invoked.getReturnType().getType();
            try {
                Annotation qualifier = Iterables.find(ImmutableList.copyOf(invoked.getAnnotations()), isQualifierPresent);
                return this.getInstanceOfTypeWithQualifier(genericReturnType, qualifier);
            }
            catch (ProvisionException e) {
                throw Throwables.propagate(e.getCause());
            }
            catch (RuntimeException e) {
                return this.instanceOfTypeOrPropagate(genericReturnType, e);
            }
        }
        catch (ProvisionException e) {
            AuthorizationException aex = Throwables2.getFirstThrowableOfType((Throwable)e, AuthorizationException.class);
            if (aex != null) {
                throw aex;
            }
            throw e;
        }
    }

    Object instanceOfTypeOrPropagate(Type genericReturnType, RuntimeException e) {
        try {
            Binding<?> binding = this.injector.getExistingBinding(Key.get(genericReturnType));
            if (binding != null) {
                return binding.getProvider().get();
            }
            binding = this.injector.getExistingBinding(Key.get(Types.newParameterizedType(Supplier.class, new Type[]{genericReturnType})));
            if (binding != null) {
                return ((Supplier)Supplier.class.cast(binding.getProvider().get())).get();
            }
            return this.injector.getInstance(Key.get(genericReturnType));
        }
        catch (ConfigurationException ce) {
            throw e;
        }
    }

    Object getInstanceOfTypeWithQualifier(Type genericReturnType, Annotation qualifier) {
        Binding<?> binding = this.injector.getExistingBinding(Key.get(genericReturnType, qualifier));
        if (binding != null) {
            return binding.getProvider().get();
        }
        binding = this.injector.getExistingBinding(Key.get((Type)Types.newParameterizedType(Supplier.class, new Type[]{genericReturnType}), qualifier));
        if (binding != null) {
            return ((Supplier)Supplier.class.cast(binding.getProvider().get())).get();
        }
        return this.injector.getInstance(Key.get(genericReturnType, qualifier));
    }

    public String toString() {
        return MoreObjects.toStringHelper("").omitNullValues().add("ownerType", this.ownerType.getRawType().getSimpleName()).add("methodInvoker", this.methodInvoker).toString();
    }

    static {
        try {
            CLOSE = Invokable.from(Closeable.class.getMethod("close", new Class[0]));
        }
        catch (SecurityException e) {
            throw Throwables.propagate(e);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate(e);
        }
        isQualifierPresent = new Predicate<Annotation>(){

            @Override
            public boolean apply(Annotation input) {
                return input.annotationType().isAnnotationPresent(Qualifier.class);
            }
        };
    }
}

