/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import java.util.Iterator;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.AbstractIterator;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.FluentIterable;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterators;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.UnmodifiableIterator;

@Beta
public class AdvanceUntilEmptyIterable<E>
extends FluentIterable<FluentIterable<E>> {
    private final AdvanceUntilEmptyIterator<E> iterator;

    public static <E> AdvanceUntilEmptyIterable<E> create(Supplier<FluentIterable<E>> nextIterable) {
        return new AdvanceUntilEmptyIterable<E>(nextIterable);
    }

    protected AdvanceUntilEmptyIterable(Supplier<FluentIterable<E>> nextIterable) {
        this.iterator = new AdvanceUntilEmptyIterator(Preconditions.checkNotNull(nextIterable, "next iterable"));
    }

    @Override
    public Iterator<FluentIterable<E>> iterator() {
        return this.iterator;
    }

    public FluentIterable<E> concat() {
        final Iterator<FluentIterable<E>> iterator = this.iterator();
        final UnmodifiableIterator unmodifiable = new UnmodifiableIterator<Iterator<E>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Iterator<E> next() {
                return ((FluentIterable)iterator.next()).iterator();
            }
        };
        return new FluentIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Iterators.concat(unmodifiable);
            }
        };
    }

    private static class AdvanceUntilEmptyIterator<E>
    extends AbstractIterator<FluentIterable<E>> {
        private final Supplier<FluentIterable<E>> nextIterable;
        private transient FluentIterable<E> current;
        private transient boolean unread = true;

        private AdvanceUntilEmptyIterator(Supplier<FluentIterable<E>> nextIterable) {
            this.nextIterable = Preconditions.checkNotNull(nextIterable, "next iterable");
        }

        @Override
        protected FluentIterable<E> computeNext() {
            if (this.unread) {
                try {
                    this.current = this.nextIterable.get();
                    FluentIterable<E> fluentIterable = this.current;
                    return fluentIterable;
                }
                finally {
                    this.unread = false;
                }
            }
            if (!this.current.isEmpty()) {
                this.current = this.nextIterable.get();
                return this.current;
            }
            return (FluentIterable)this.endOfData();
        }

        public int hashCode() {
            return Objects.hashCode(this.current, this.unread);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AdvanceUntilEmptyIterator other = (AdvanceUntilEmptyIterator)AdvanceUntilEmptyIterator.class.cast(obj);
            return Objects.equal(this.current, other.current) && Objects.equal(this.unread, other.unread);
        }

        public String toString() {
            return MoreObjects.toStringHelper("").omitNullValues().add("current", this.current).add("unread", this.unread).toString();
        }
    }
}

