/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.LinkedHashMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.io.Payload;

public class BlobImpl
extends PayloadEnclosingImpl
implements Blob,
Comparable<Blob> {
    private final MutableBlobMetadata metadata;
    private Multimap<String, String> allHeaders = LinkedHashMultimap.create();

    @Inject
    public BlobImpl(MutableBlobMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public MutableBlobMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Multimap<String, String> getAllHeaders() {
        return this.allHeaders;
    }

    @Override
    public void setAllHeaders(Multimap<String, String> allHeaders) {
        this.allHeaders = Preconditions.checkNotNull(allHeaders, "allHeaders");
    }

    @Override
    public int compareTo(Blob o) {
        if (this.getMetadata().getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getMetadata().getName().compareTo(o.getMetadata().getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlobImpl other = (BlobImpl)obj;
        return !(this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata));
    }

    public String toString() {
        return "[metadata=" + this.metadata + "]";
    }

    @Override
    public void setPayload(Payload data) {
        super.setPayload(data);
        this.metadata.setContentMetadata(data.getContentMetadata());
    }
}

