/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.config;

import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.com.google.inject.name.Named;
import org.jclouds.http.HttpRequest;
import org.jclouds.oauth.v2.config.OAuthConfigFactory;
import org.jclouds.oauth.v2.config.OAuthScopes;

public class AzureStorageOAuthConfigFactory
implements OAuthConfigFactory {
    private final OAuthScopes scopes;
    @Named(value="jclouds.oauth.audience")
    @Inject(optional=true)
    private String audience;
    @Named(value="jclouds.oauth.resource")
    @Inject(optional=true)
    private String resource;
    @Named(value="jclouds.azureblob.account")
    @Inject
    private String account;

    @Inject
    AzureStorageOAuthConfigFactory(OAuthScopes scopes) {
        this.scopes = scopes;
    }

    @Override
    public OAuthConfigFactory.OAuthConfig forRequest(HttpRequest input) {
        String authAudience;
        String authResource = this.resource;
        if (authResource == null) {
            authResource = "https://" + this.account + ".blob.core.windows.net";
        }
        if ((authAudience = this.audience) == null) {
            authAudience = "https://" + this.account + ".blob.core.windows.net";
        }
        return OAuthConfigFactory.OAuthConfig.create(this.scopes.forRequest(input), authAudience, authResource);
    }
}

