/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Charsets;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteSource;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.crypto.Pems;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Throwables2;

@Singleton
final class PrivateKeySupplier
implements Supplier<PrivateKey> {
    private final Supplier<Credentials> creds;
    private final LoadingCache<Credentials, PrivateKey> keyCache;

    @Inject
    PrivateKeySupplier(@Provider Supplier<Credentials> creds, PrivateKeyForCredentials loader) {
        this.creds = creds;
        this.keyCache = CacheBuilder.newBuilder().maximumSize(2L).build(Preconditions.checkNotNull(loader, "loader"));
    }

    @Override
    public PrivateKey get() {
        try {
            return this.keyCache.getUnchecked(Preconditions.checkNotNull(this.creds.get(), "credential supplier returned null"));
        }
        catch (UncheckedExecutionException e) {
            AuthorizationException authorizationException = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
            if (authorizationException != null) {
                throw authorizationException;
            }
            throw e;
        }
    }

    @VisibleForTesting
    static final class PrivateKeyForCredentials
    extends CacheLoader<Credentials, PrivateKey> {
        PrivateKeyForCredentials() {
        }

        @Override
        public PrivateKey load(Credentials in) {
            try {
                String privateKeyInPemFormat = Preconditions.checkNotNull(in.credential, "credential in PEM format");
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(Pems.privateKeySpec(ByteSource.wrap(privateKeyInPemFormat.getBytes(Charsets.UTF_8))));
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            catch (InvalidKeySpecException e) {
                throw new AuthorizationException("security exception loading credentials. " + e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new AuthorizationException("cannot parse pk. " + e.getMessage(), e);
            }
        }
    }
}

