/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.Hashing;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashingInputStream;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteSource;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteStreams;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.date.DateService;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.util.Closeables2;

public class TransientStorageStrategy
implements LocalStorageStrategy {
    private final ConcurrentMap<String, ConcurrentSkipListMap<String, Blob>> containerToBlobs = new ConcurrentHashMap<String, ConcurrentSkipListMap<String, Blob>>();
    private final ConcurrentMap<String, ConcurrentMap<String, BlobAccess>> containerToBlobAccess = new ConcurrentHashMap<String, ConcurrentMap<String, BlobAccess>>();
    private final ConcurrentMap<String, StorageMetadata> containerMetadata = new ConcurrentHashMap<String, StorageMetadata>();
    private final ConcurrentMap<String, ContainerAccess> containerAccessMap = new ConcurrentHashMap<String, ContainerAccess>();
    private final Supplier<Location> defaultLocation;
    private final DateService dateService;
    private final Blob.Factory blobFactory;
    private final ContentMetadataCodec contentMetadataCodec;

    @Inject
    TransientStorageStrategy(Supplier<Location> defaultLocation, DateService dateService, Blob.Factory blobFactory, ContentMetadataCodec contentMetadataCodec) {
        this.defaultLocation = defaultLocation;
        this.dateService = dateService;
        this.blobFactory = blobFactory;
        this.contentMetadataCodec = contentMetadataCodec;
    }

    @Override
    public boolean containerExists(String containerName) {
        return this.containerToBlobs.containsKey(containerName);
    }

    @Override
    public Collection<String> getAllContainerNames() {
        return this.containerToBlobs.keySet();
    }

    @Override
    public boolean createContainerInLocation(String containerName, Location location, CreateContainerOptions options) {
        ConcurrentMap origValue = this.containerToBlobs.putIfAbsent(containerName, new ConcurrentSkipListMap());
        if (origValue != null) {
            return false;
        }
        this.containerToBlobAccess.putIfAbsent(containerName, new ConcurrentHashMap());
        MutableStorageMetadataImpl metadata = new MutableStorageMetadataImpl();
        metadata.setName(containerName);
        metadata.setType(StorageType.CONTAINER);
        metadata.setLocation(location);
        metadata.setCreationDate(new Date());
        this.containerMetadata.put(containerName, metadata);
        this.containerAccessMap.put(containerName, options.isPublicRead() ? ContainerAccess.PUBLIC_READ : ContainerAccess.PRIVATE);
        return true;
    }

    @Override
    public ContainerAccess getContainerAccess(String container) {
        ContainerAccess access = (ContainerAccess)((Object)this.containerAccessMap.get(container));
        return access == null ? ContainerAccess.PRIVATE : access;
    }

    @Override
    public void setContainerAccess(String container, ContainerAccess access) {
        this.containerAccessMap.put(container, access);
    }

    @Override
    public void deleteContainer(String containerName) {
        this.containerToBlobs.remove(containerName);
        this.containerToBlobAccess.remove(containerName);
    }

    @Override
    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String containerName, ListContainerOptions options) {
        ((ConcurrentSkipListMap)this.containerToBlobs.get(containerName)).clear();
    }

    @Override
    public StorageMetadata getContainerMetadata(String container) {
        return (StorageMetadata)this.containerMetadata.get(container);
    }

    @Override
    public boolean blobExists(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        return map != null && map.containsKey(blobName);
    }

    @Override
    public Iterable<String> getBlobKeysInsideContainer(String containerName, String prefix, String delimiter) {
        ConcurrentSkipListMap blobs = (ConcurrentSkipListMap)this.containerToBlobs.get(containerName);
        if (prefix == null) {
            return blobs.keySet();
        }
        String lastPrefix = prefix + '\uffff';
        return blobs.subMap(prefix, true, lastPrefix, false).keySet();
    }

    @Override
    public Blob getBlob(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        if (map == null) {
            return null;
        }
        Blob blob = (Blob)map.get(blobName);
        if (blob == null) {
            return null;
        }
        Payload payload = blob.getPayload();
        MutableContentMetadata md = payload.getContentMetadata();
        Blob newBlob = this.blobFactory.create(BlobStoreUtils.copy(blob.getMetadata()));
        Payload newPayload = Payloads.newPayload(payload.getRawContent());
        newBlob.setPayload(payload);
        HttpUtils.copy(md, newPayload.getContentMetadata());
        return newBlob;
    }

    @Override
    public String putBlob(String containerName, Blob blob) throws IOException {
        return this.putBlob(containerName, blob, BlobAccess.PRIVATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putBlob(String containerName, Blob blob, BlobAccess access) throws IOException {
        HashCode actualHashCode;
        byte[] payload;
        HashingInputStream input = new HashingInputStream(Hashing.md5(), blob.getPayload().openStream());
        try {
            payload = ByteStreams.toByteArray(input);
            long actualSize = payload.length;
            Long expectedSize = blob.getMetadata().getContentMetadata().getContentLength();
            if (expectedSize != null && actualSize != expectedSize) {
                throw new IOException("Content-Length mismatch, actual: " + actualSize + " expected: " + expectedSize);
            }
            actualHashCode = input.hash();
            HashCode expectedHashCode = blob.getPayload().getContentMetadata().getContentMD5AsHashCode();
            if (expectedHashCode != null && !actualHashCode.equals(expectedHashCode)) {
                throw new IOException("MD5 hash code mismatch, actual: " + actualHashCode + " expected: " + expectedHashCode);
            }
        }
        finally {
            Closeables2.closeQuietly(input);
        }
        String eTag = null;
        if (blob.getMetadata() != null) {
            eTag = blob.getMetadata().getETag();
        }
        if (eTag == null) {
            eTag = BaseEncoding.base16().lowerCase().encode(actualHashCode.asBytes());
        }
        Blob newBlob = this.createUpdatedCopyOfBlobInContainer(containerName, blob, payload, actualHashCode, eTag);
        Map map = (Map)this.containerToBlobs.get(containerName);
        String blobName = newBlob.getMetadata().getName();
        map.put(blobName, newBlob);
        ((ConcurrentMap)this.containerToBlobAccess.get(containerName)).put(blobName, access);
        return BaseEncoding.base16().lowerCase().encode(actualHashCode.asBytes());
    }

    @Override
    public void removeBlob(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobs.get(containerName);
        if (map != null) {
            map.remove(blobName);
        }
    }

    @Override
    public BlobAccess getBlobAccess(String containerName, String blobName) {
        Map map = (Map)this.containerToBlobAccess.get(containerName);
        if (map == null) {
            throw new ContainerNotFoundException(containerName, "in getBlobAccess");
        }
        BlobAccess access = (BlobAccess)((Object)map.get(blobName));
        if (access == null) {
            throw new KeyNotFoundException(containerName, blobName, "in getBlobAccess");
        }
        return access;
    }

    @Override
    public void setBlobAccess(String containerName, String blobName, BlobAccess access) {
        Map map = (Map)this.containerToBlobAccess.get(containerName);
        if (map == null) {
            throw new ContainerNotFoundException(containerName, "in setBlobAccess");
        }
        map.put(blobName, access);
    }

    @Override
    public Location getLocation(String containerName) {
        return ((StorageMetadata)this.containerMetadata.get(containerName)).getLocation();
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    private Blob createUpdatedCopyOfBlobInContainer(String containerName, Blob in, byte[] input, HashCode contentMd5, String eTag) {
        Preconditions.checkNotNull(containerName, "containerName");
        Preconditions.checkNotNull(in, "blob");
        Preconditions.checkNotNull(input, "input");
        Preconditions.checkNotNull(contentMd5, "contentMd5");
        Preconditions.checkNotNull(eTag, "eTag");
        Payload payload = TransientStorageStrategy.createPayload(input);
        MutableContentMetadata oldMd = in.getPayload().getContentMetadata();
        HttpUtils.copy(oldMd, payload.getContentMetadata());
        payload.getContentMetadata().setContentMD5(contentMd5);
        payload.getContentMetadata().setContentLength(Long.valueOf(input.length));
        Blob blob = this.blobFactory.create(BlobStoreUtils.copy(in.getMetadata()));
        blob.setPayload(payload);
        blob.getMetadata().setContainer(containerName);
        blob.getMetadata().setLastModified(new Date());
        blob.getMetadata().setSize(Long.valueOf(input.length));
        blob.getMetadata().setETag(eTag);
        blob.getAllHeaders().replaceValues("Last-Modified", ImmutableList.of(this.dateService.rfc822DateFormat(blob.getMetadata().getLastModified())));
        blob.getAllHeaders().replaceValues("ETag", ImmutableList.of(eTag));
        this.copyPayloadHeadersToBlob(payload, blob);
        blob.getAllHeaders().putAll(Multimaps.forMap(blob.getMetadata().getUserMetadata()));
        return blob;
    }

    private static Payload createPayload(byte[] input) {
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == 0) continue;
            return Payloads.newByteArrayPayload(input);
        }
        return Payloads.newByteSourcePayload(new RepeatingByteSource(0).slice(0L, input.length));
    }

    private void copyPayloadHeadersToBlob(Payload payload, Blob blob) {
        blob.getAllHeaders().putAll(this.contentMetadataCodec.toHeaders(payload.getContentMetadata()));
    }

    private static final class RepeatingInputStream
    extends InputStream {
        private final byte ch;

        RepeatingInputStream(byte ch) {
            this.ch = ch;
        }

        @Override
        public int read() throws IOException {
            return this.ch;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            for (int i = 0; i < len; ++i) {
                b[off + i] = this.ch;
            }
            return len;
        }
    }

    private static final class RepeatingByteSource
    extends ByteSource {
        private final byte ch;

        RepeatingByteSource(byte ch) {
            this.ch = ch;
        }

        @Override
        public InputStream openStream() {
            return new RepeatingInputStream(this.ch);
        }
    }
}

