/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;

public interface BlobStore {
    public BlobStoreContext getContext();

    public BlobBuilder blobBuilder(String var1);

    public Set<? extends Location> listAssignableLocations();

    public PageSet<? extends StorageMetadata> list();

    public boolean containerExists(String var1);

    public boolean createContainerInLocation(@Nullable Location var1, String var2);

    public boolean createContainerInLocation(@Nullable Location var1, String var2, CreateContainerOptions var3);

    @Beta
    public ContainerAccess getContainerAccess(String var1);

    @Beta
    public void setContainerAccess(String var1, ContainerAccess var2);

    public PageSet<? extends StorageMetadata> list(String var1);

    public PageSet<? extends StorageMetadata> list(String var1, ListContainerOptions var2);

    public void clearContainer(String var1);

    public void clearContainer(String var1, ListContainerOptions var2);

    public void deleteContainer(String var1);

    public boolean deleteContainerIfEmpty(String var1);

    @Deprecated
    public boolean directoryExists(String var1, String var2);

    @Deprecated
    public void createDirectory(String var1, String var2);

    @Deprecated
    public void deleteDirectory(String var1, String var2);

    public boolean blobExists(String var1, String var2);

    public String putBlob(String var1, Blob var2);

    public String putBlob(String var1, Blob var2, PutOptions var3);

    @Beta
    public String copyBlob(String var1, String var2, String var3, String var4, CopyOptions var5);

    @Nullable
    public BlobMetadata blobMetadata(String var1, String var2);

    @Nullable
    public Blob getBlob(String var1, String var2);

    @Nullable
    public Blob getBlob(String var1, String var2, GetOptions var3);

    public void removeBlob(String var1, String var2);

    public void removeBlobs(String var1, Iterable<String> var2);

    @Beta
    public BlobAccess getBlobAccess(String var1, String var2);

    @Beta
    public void setBlobAccess(String var1, String var2, BlobAccess var3);

    public long countBlobs(String var1);

    public long countBlobs(String var1, ListContainerOptions var2);

    @Beta
    public MultipartUpload initiateMultipartUpload(String var1, BlobMetadata var2, PutOptions var3);

    @Beta
    public void abortMultipartUpload(MultipartUpload var1);

    @Beta
    public String completeMultipartUpload(MultipartUpload var1, List<MultipartPart> var2);

    @Beta
    public MultipartPart uploadMultipartPart(MultipartUpload var1, int var2, Payload var3);

    @Beta
    public List<MultipartPart> listMultipartUpload(MultipartUpload var1);

    @Beta
    public List<MultipartUpload> listMultipartUploads(String var1);

    @Beta
    public long getMinimumMultipartPartSize();

    @Beta
    public long getMaximumMultipartPartSize();

    @Beta
    public int getMaximumNumberOfParts();

    @Beta
    public void downloadBlob(String var1, String var2, File var3);

    @Beta
    public void downloadBlob(String var1, String var2, File var3, ExecutorService var4);

    @Beta
    public InputStream streamBlob(String var1, String var2);

    @Beta
    public InputStream streamBlob(String var1, String var2, ExecutorService var3);
}

