/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Charsets;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.com.google.common.io.CharStreams;
import org.apache.pulsar.jcloud.shade.com.google.common.net.InetAddresses;
import org.apache.pulsar.jcloud.shade.com.google.common.primitives.Chars;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Patterns;

public class Strings2 {
    private static final LoadingCache<Character, String> CHAR_TO_ENCODED = CacheBuilder.newBuilder().build(new CacheLoader<Character, String>(){

        @Override
        public String load(Character plain) throws ExecutionException {
            try {
                return URLEncoder.encode(plain + "", "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ExecutionException("Bad encoding on input: " + plain, e);
            }
        }
    });
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
    private static final Pattern CIDR_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public static String urlEncode(String in, char ... skipEncode) {
        return Strings2.urlEncode(in, Chars.asList(skipEncode));
    }

    public static String urlEncode(String in, Iterable<Character> skipEncode) {
        try {
            String returnVal = URLEncoder.encode(in, "UTF-8");
            returnVal = returnVal.replace("+", "%20");
            returnVal = returnVal.replace("*", "%2A");
            for (char c : skipEncode) {
                returnVal = returnVal.replace(CHAR_TO_ENCODED.get(Character.valueOf(c)), c + "");
            }
            return returnVal;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + in, e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("error creating pattern: " + in, e);
        }
    }

    public static boolean isCidrFormat(String in) {
        return CIDR_PATTERN.matcher(in).matches() || Strings2.isIPv6CIDR(in);
    }

    public static boolean isIPv6CIDR(String in) {
        int mask;
        if (!in.contains(":")) {
            return false;
        }
        String[] parts = in.split("/");
        if (parts.length != 2) {
            if (parts.length == 1) {
                return InetAddresses.isInetAddress(in);
            }
            return false;
        }
        if (parts[1].length() > 1 && parts[1].startsWith("0")) {
            return false;
        }
        try {
            mask = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (mask < 0 || mask > 128) {
            return false;
        }
        return InetAddresses.isInetAddress(parts[0]);
    }

    public static String urlDecode(@Nullable String in) {
        if (in == null) {
            return null;
        }
        String input = in.toString();
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + in, e);
        }
    }

    public static String toStringAndClose(InputStream input) throws IOException {
        Preconditions.checkNotNull(input, "input");
        try {
            String string = CharStreams.toString(new InputStreamReader(input, Charsets.UTF_8));
            return string;
        }
        finally {
            Closeables2.closeQuietly(input);
        }
    }

    public static InputStream toInputStream(String in) {
        return new ByteArrayInputStream(in.getBytes(Charsets.UTF_8));
    }

    public static String replaceTokens(String input, Map<String, String> replacements) {
        Matcher matcher = TOKEN_PATTERN.matcher(input);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(input, i, matcher.start());
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(input, i, input.length());
        return builder.toString();
    }

    public static String replaceTokens(String input, Multimap<String, ?> tokenValues) {
        for (Map.Entry<String, ?> tokenValue : tokenValues.entries()) {
            Pattern pattern = Patterns.TOKEN_TO_PATTERN.getUnchecked(tokenValue.getKey());
            input = pattern.matcher(input).replaceAll(tokenValue.getValue().toString().replace("\\", "\\\\").replace("$", "\\$"));
        }
        return input;
    }
}

