/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.reflect.Invocation;

@Beta
public final class InvocationSuccess {
    private final Invocation invocation;
    private final Optional<Object> result;

    public static InvocationSuccess create(Invocation invocation, @Nullable Object result) {
        return new InvocationSuccess(invocation, Optional.fromNullable(result));
    }

    private InvocationSuccess(Invocation invocation, Optional<Object> result) {
        this.invocation = Preconditions.checkNotNull(invocation, "invocation");
        this.result = Preconditions.checkNotNull(result, "result");
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public Optional<Object> getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationSuccess that = (InvocationSuccess)InvocationSuccess.class.cast(o);
        return Objects.equal(this.invocation, that.invocation) && Objects.equal(this.result.orNull(), that.result.orNull());
    }

    public int hashCode() {
        return Objects.hashCode(this.invocation, this.result.orNull());
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").omitNullValues().add("invocation", this.invocation).add("result", this.result.orNull());
    }
}

