/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.domain;

import java.util.Date;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_User;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_User_Domain;
import org.jclouds.openstack.keystone.v3.domain.Link;

public abstract class User {
    public abstract String id();

    public abstract String name();

    @Nullable
    public abstract Date passwordExpiresAt();

    @Nullable
    public abstract Domain domain();

    @Nullable
    public abstract String domainId();

    @Nullable
    public abstract String defaultProjectId();

    @Nullable
    public abstract Boolean enabled();

    @Nullable
    public abstract Link link();

    @SerializedNames(value={"id", "name", "password_expires_at", "domain", "domain_id", "default_project_id", "enabled", "links"})
    public static User create(String id, String name, Date passwordExpiresAt, Domain domain, String domainId, String defaultProjectId, Boolean enabled, Link link) {
        return User.builder().id(id).name(name).passwordExpiresAt(passwordExpiresAt).domain(domain).domainId(domainId).defaultProjectId(defaultProjectId).enabled(enabled).link(link).build();
    }

    User() {
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_User.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder passwordExpiresAt(Date var1);

        public abstract Builder domain(Domain var1);

        public abstract Builder domainId(String var1);

        public abstract Builder defaultProjectId(String var1);

        public abstract Builder enabled(Boolean var1);

        public abstract Builder link(Link var1);

        public abstract User build();
    }

    public static abstract class Domain {
        public abstract String id();

        public abstract String name();

        @SerializedNames(value={"id", "name"})
        public static Domain create(String id, String name) {
            return new AutoValue_User_Domain(id, name);
        }
    }
}

