/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.inject.TypeLiteral;
import org.apache.pulsar.jcloud.shade.jakarta.annotation.Resource;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;

@Singleton
public class ParseJson<T>
implements Function<HttpResponse, T> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Json json;
    protected final TypeLiteral<T> type;

    @Inject
    public ParseJson(Json json, TypeLiteral<T> type) {
        this.json = json;
        this.type = type;
    }

    @Override
    public T apply(HttpResponse from) {
        try {
            InputStream gson = from.getPayload().openStream();
            T t = this.apply(gson);
            return t;
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder();
            message.append("Error parsing input: ");
            message.append(e.getMessage());
            this.logger.error(e, message.toString(), new Object[0]);
            throw new HttpResponseException(message.toString() + "\n" + from, null, from, (Throwable)e);
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }

    @Override
    public T apply(InputStream stream) throws IOException {
        return (T)this.apply(stream, this.type.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V apply(InputStream stream, Type type) throws IOException {
        try {
            Object t = this.json.fromJson(stream, StandardCharsets.UTF_8, type);
            return (V)t;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

