/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.ResourceMetadataToRelativePathResourceMetadata;
import org.jclouds.blobstore.reference.BlobStoreConstants;
import org.jclouds.blobstore.strategy.GetDirectoryStrategy;

@Singleton
public class MarkersGetDirectoryStrategy
implements GetDirectoryStrategy {
    protected final ResourceMetadataToRelativePathResourceMetadata resource2Directory;
    private final BlobStore connection;

    @Inject
    public MarkersGetDirectoryStrategy(BlobStore connection, ResourceMetadataToRelativePathResourceMetadata resource2Directory) {
        this.connection = connection;
        this.resource2Directory = resource2Directory;
    }

    @Override
    public StorageMetadata execute(String containerName, String directory) {
        BlobMetadata md = this.connection.blobMetadata(containerName, directory);
        if (md != null && md.getContentMetadata().getContentType().equals("application/directory")) {
            return this.resource2Directory.apply(md);
        }
        for (String suffix : BlobStoreConstants.DIRECTORY_SUFFIXES) {
            md = this.connection.blobMetadata(containerName, directory + suffix);
            if (md == null) continue;
            return this.resource2Directory.apply(md);
        }
        return null;
    }
}

