/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.features;

import java.util.Collection;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.HeaderParam;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.jakarta.ws.rs.Produces;
import org.jclouds.b2.binders.UploadPartBinder;
import org.jclouds.b2.domain.B2Object;
import org.jclouds.b2.domain.GetUploadPartResponse;
import org.jclouds.b2.domain.ListPartsResponse;
import org.jclouds.b2.domain.ListUnfinishedLargeFilesResponse;
import org.jclouds.b2.domain.MultipartUploadResponse;
import org.jclouds.b2.domain.UploadPartResponse;
import org.jclouds.b2.filters.RequestAuthorization;
import org.jclouds.blobstore.attr.BlobScope;
import org.jclouds.blobstore.attr.BlobScopes;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.binders.BindToJsonPayload;

@BlobScope(value=BlobScopes.CONTAINER)
@Consumes(value={"application/json"})
public interface MultipartApi {
    @Named(value="b2_start_large_file")
    @POST
    @Path(value="/b2api/v2/b2_start_large_file")
    @RequestFilters(value={RequestAuthorization.class})
    @MapBinder(value=BindToJsonPayload.class)
    @Produces(value={"application/json"})
    public MultipartUploadResponse startLargeFile(@PayloadParam(value="bucketId") String var1, @PayloadParam(value="fileName") String var2, @PayloadParam(value="contentType") String var3, @PayloadParam(value="fileInfo") Map<String, String> var4);

    @Named(value="b2_cancel_large_file")
    @POST
    @Path(value="/b2api/v2/b2_cancel_large_file")
    @RequestFilters(value={RequestAuthorization.class})
    @MapBinder(value=BindToJsonPayload.class)
    @Produces(value={"application/json"})
    public B2Object cancelLargeFile(@PayloadParam(value="fileId") String var1);

    @Named(value="b2_finish_large_file")
    @POST
    @Path(value="/b2api/v2/b2_finish_large_file")
    @RequestFilters(value={RequestAuthorization.class})
    @MapBinder(value=BindToJsonPayload.class)
    @Produces(value={"application/json"})
    public B2Object finishLargeFile(@PayloadParam(value="fileId") String var1, @PayloadParam(value="partSha1Array") Collection<String> var2);

    @Named(value="b2_get_upload_part_url")
    @POST
    @Path(value="/b2api/v2/b2_get_upload_part_url")
    @RequestFilters(value={RequestAuthorization.class})
    @MapBinder(value=BindToJsonPayload.class)
    @Produces(value={"application/json"})
    public GetUploadPartResponse getUploadPartUrl(@PayloadParam(value="fileId") String var1);

    @Named(value="b2_upload_part")
    @POST
    @MapBinder(value=UploadPartBinder.class)
    public UploadPartResponse uploadPart(@PayloadParam(value="response") GetUploadPartResponse var1, @HeaderParam(value="X-Bz-Part-Number") int var2, @Nullable @PayloadParam(value="contentSha1") String var3, @PayloadParam(value="payload") Payload var4);

    @Named(value="b2_list_parts")
    @POST
    @Path(value="/b2api/v2/b2_list_parts")
    @RequestFilters(value={RequestAuthorization.class})
    @MapBinder(value=BindToJsonPayload.class)
    @Produces(value={"application/json"})
    public ListPartsResponse listParts(@PayloadParam(value="fileId") String var1, @PayloadParam(value="startPartNumber") @Nullable Integer var2, @PayloadParam(value="maxPartCount") @Nullable Integer var3);

    @Named(value="b2_list_unfinished_large_files")
    @POST
    @Path(value="/b2api/v2/b2_list_unfinished_large_files")
    @RequestFilters(value={RequestAuthorization.class})
    @MapBinder(value=BindToJsonPayload.class)
    @Produces(value={"application/json"})
    public ListUnfinishedLargeFilesResponse listUnfinishedLargeFiles(@PayloadParam(value="bucketId") String var1, @PayloadParam(value="startFileId") @Nullable String var2, @PayloadParam(value="maxFileCount") @Nullable Integer var3);
}

