/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.binders;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableTable;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.SetMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Table;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindTableToIndexedFormParams
implements Binder {
    private final String rowPattern;
    private final String columnPattern;
    private final String valuePattern;

    protected BindTableToIndexedFormParams(String rowPattern, String columnPattern, String valuePattern) {
        this.rowPattern = rowPattern;
        this.columnPattern = columnPattern;
        this.valuePattern = valuePattern;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        if (Preconditions.checkNotNull(input, "input") instanceof Map) {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            int index = 1;
            for (Map.Entry entry : ((Map)((Object)input)).entrySet()) {
                builder.put(index++, entry.getKey(), entry.getValue());
            }
            input = builder.build();
        }
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Table, "this binder is only valid for Table");
        Table table = (Table)Table.class.cast(input);
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        int amazonOneBasedIndex = 1;
        for (Table.Cell cell : table.cellSet()) {
            builder.put(String.format(this.rowPattern, amazonOneBasedIndex), cell.getRowKey().toString());
            builder.put(String.format(this.columnPattern, amazonOneBasedIndex), cell.getColumnKey().toString());
            builder.put(String.format(this.valuePattern, amazonOneBasedIndex), cell.getValue().toString());
            ++amazonOneBasedIndex;
        }
        SetMultimap<String, String> setMultimap = Multimaps.forMap(builder.build());
        return (R)(setMultimap.isEmpty() ? request : ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(setMultimap)).build());
    }
}

