/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMultimap;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Named;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.http.okhttp.DelegatingSocketFactory;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.proxy.internal.GuiceProxyConfig;

public final class OkHttpCommandExecutorService
extends BaseHttpCommandExecutorService<Request> {
    private final Function<URI, Proxy> proxyForURI;
    private final OkHttpClient globalClient;
    private final String userAgent;
    private final GuiceProxyConfig proxyConfig;

    @Inject
    OkHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, Function<URI, Proxy> proxyForURI, OkHttpClient okHttpClient, @Named(value="jclouds.idempotent-methods") String idempotentMethods, @Named(value="jclouds.user-agent") String userAgent, GuiceProxyConfig proxyConfig) {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire, idempotentMethods);
        this.proxyForURI = proxyForURI;
        this.globalClient = okHttpClient;
        this.userAgent = userAgent;
        this.proxyConfig = proxyConfig;
    }

    @Override
    protected Request convert(HttpRequest request) throws IOException, InterruptedException {
        Long length;
        Request.Builder builder = new Request.Builder();
        builder.url(request.getEndpoint().toString());
        this.populateHeaders(request, builder);
        RequestBody body = null;
        Payload payload = request.getPayload();
        if (payload != null && (length = Preconditions.checkNotNull(payload.getContentMetadata().getContentLength(), "payload.getContentLength")) > 0L) {
            body = this.generateRequestBody(request, payload);
        }
        if (body == null && HttpMethod.requiresRequestBody((String)request.getMethod())) {
            body = this.generateEmptyRequestBody(payload);
        }
        builder.method(request.getMethod(), body);
        return builder.build();
    }

    protected void populateHeaders(HttpRequest request, Request.Builder builder) {
        if (request.getFirstHeaderOrNull("Accept") == null) {
            builder.addHeader("Accept", "*/*");
        }
        if (request.getFirstHeaderOrNull("User-Agent") == null) {
            builder.addHeader("User-Agent", this.userAgent);
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entries()) {
            builder.addHeader(entry.getKey(), entry.getValue());
        }
        if (request.getPayload() != null) {
            MutableContentMetadata md = request.getPayload().getContentMetadata();
            for (Map.Entry<String, String> entry : this.contentMetadataCodec.toHeaders(md).entries()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private RequestBody generateEmptyRequestBody(final Payload payload) {
        return new RequestBody(){

            @Nullable
            public MediaType contentType() {
                return payload != null ? MediaType.parse((String)payload.getContentMetadata().getContentType()) : null;
            }

            public void writeTo(BufferedSink sink) throws IOException {
            }

            public long contentLength() throws IOException {
                return 0L;
            }
        };
    }

    protected RequestBody generateRequestBody(final HttpRequest request, final Payload payload) {
        Preconditions.checkNotNull(payload.getContentMetadata().getContentType(), "payload.getContentType");
        return new RequestBody(){

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)payload.openStream());){
                    sink.writeAll(source);
                }
            }

            public long contentLength() throws IOException {
                return payload.getContentMetadata().getContentLength();
            }

            public MediaType contentType() {
                return MediaType.parse((String)payload.getContentMetadata().getContentType());
            }
        };
    }

    @Override
    protected HttpResponse invoke(Request nativeRequest) throws IOException, InterruptedException {
        OkHttpClient.Builder okHttpClientBuilder = this.globalClient.newBuilder().proxy(this.proxyForURI.apply(nativeRequest.url().uri()));
        if (this.proxyConfig.getCredentials().isPresent()) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    if (response != null && response.code() == 407 && !response.message().toLowerCase().contains("preemptive authenticate")) {
                        return null;
                    }
                    String credential = Credentials.basic((String)((OkHttpCommandExecutorService)OkHttpCommandExecutorService.this).proxyConfig.getCredentials().get().identity, (String)((OkHttpCommandExecutorService)OkHttpCommandExecutorService.this).proxyConfig.getCredentials().get().credential);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            okHttpClientBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        if (this.proxyConfig.isSslProxyEnabled()) {
            okHttpClientBuilder.socketFactory((SocketFactory)new DelegatingSocketFactory(SSLSocketFactory.getDefault()));
        }
        OkHttpClient requestScopedClient = okHttpClientBuilder.build();
        Response response = requestScopedClient.newCall(nativeRequest).execute();
        HttpResponse.Builder<?> builder = HttpResponse.builder();
        builder.statusCode(response.code());
        builder.message(response.message());
        ImmutableMultimap.Builder headerBuilder = ImmutableMultimap.builder();
        Headers responseHeaders = response.headers();
        for (String header : responseHeaders.names()) {
            headerBuilder.putAll(header, responseHeaders.values(header));
        }
        ImmutableMultimap<String, String> headers = headerBuilder.build();
        if (response.code() == 204 && response.body() != null) {
            response.body().close();
        } else {
            InputStreamPayload payload = Payloads.newInputStreamPayload(response.body().byteStream());
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), headers);
            builder.payload(payload);
        }
        builder.headers(HttpUtils.filterOutContentHeaders(headers));
        return builder.build();
    }

    @Override
    protected void cleanup(Request nativeResponse) {
    }

    static /* synthetic */ Logger access$000(OkHttpCommandExecutorService x0) {
        return x0.logger;
    }
}

