/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.gson.annotations.SerializedName;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.glacier.domain.MultipartUploadMetadata;
import org.jclouds.glacier.options.PaginationOptions;
import org.jclouds.javax.annotation.Nullable;

public class PaginatedMultipartUploadCollection
extends IterableWithMarker<MultipartUploadMetadata> {
    @SerializedName(value="UploadsList")
    private final Iterable<MultipartUploadMetadata> uploads;
    @SerializedName(value="Marker")
    private final String marker;

    @ConstructorProperties(value={"UploadsList", "Marker"})
    public PaginatedMultipartUploadCollection(Iterable<MultipartUploadMetadata> uploads, @Nullable String marker) {
        this.uploads = Preconditions.checkNotNull(uploads, "uploads");
        this.marker = marker;
    }

    @Override
    public Iterator<MultipartUploadMetadata> iterator() {
        return this.uploads.iterator();
    }

    @Override
    public Optional<Object> nextMarker() {
        return Optional.fromNullable(this.marker);
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)PaginationOptions.class.cast(this.nextMarker().get());
    }
}

