/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.binders;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserMetadataToHeaders
implements Binder,
Function<UserMetadata, Map<String, String>> {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof UserMetadata, "this binder is only valid for UserMetadatas!");
        Preconditions.checkNotNull(request, "request");
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders(Multimaps.forMap(this.apply((UserMetadata)UserMetadata.class.cast(input))))).build();
    }

    @Override
    public Map<String, String> apply(UserMetadata md) {
        String header;
        ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();
        if (!md.getMetadata().isEmpty()) {
            header = Joiner.on(',').withKeyValueSeparator("=").join(md.getMetadata());
            headers.put("x-emc-meta", header);
        }
        if (!md.getListableMetadata().isEmpty()) {
            header = Joiner.on(',').withKeyValueSeparator("=").join(md.getListableMetadata());
            headers.put("x-emc-listable-meta", header);
        }
        if (!md.getTags().isEmpty()) {
            header = Joiner.on(',').join(md.getTags());
            headers.put("x-emc-tags", header);
        }
        if (!md.getListableTags().isEmpty()) {
            header = Joiner.on(',').join(md.getListableTags());
            headers.put("x-emc-listable-tags", header);
        }
        return headers.build();
    }
}

