/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ForwardingObject;
import org.apache.pulsar.jcloud.shade.com.google.gson.Gson;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.json.Json;

@Singleton
public class GsonWrapper
extends ForwardingObject
implements Json {
    private final Gson gson;

    @Inject
    public GsonWrapper(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <T> T fromJson(String json, Type type) {
        return this.gson.fromJson(json, type);
    }

    @Override
    public <T> T fromJson(String json, Class<T> classOfT) {
        return this.gson.fromJson(json, classOfT);
    }

    @Override
    public <T> T fromJson(InputStream json, Charset charset, Type type) {
        return this.gson.fromJson((Reader)new InputStreamReader(json, charset), type);
    }

    @Override
    public <T> T fromJson(InputStream json, Charset charset, Class<T> classOfT) {
        return this.gson.fromJson((Reader)new InputStreamReader(json, charset), classOfT);
    }

    @Override
    public String toJson(Object src) {
        return this.gson.toJson(src);
    }

    @Override
    public String toJson(Object src, Type type) {
        return this.gson.toJson(src, type);
    }

    @Override
    public Gson delegate() {
        return this.gson;
    }
}

