/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import java.io.IOException;
import java.io.InputStream;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public abstract class BasePayload<V>
implements Payload {
    protected final V content;
    protected volatile transient boolean written;
    protected MutableContentMetadata contentMetadata;
    private boolean isSensitive;

    protected BasePayload(V content) {
        this(content, new BaseMutableContentMetadata());
    }

    protected BasePayload(V content, MutableContentMetadata contentMetadata) {
        this.content = Preconditions.checkNotNull(content, "content");
        this.contentMetadata = Preconditions.checkNotNull(contentMetadata, "contentMetadata");
    }

    @Override
    public InputStream getInput() {
        try {
            return this.openStream();
        }
        catch (IOException ioe) {
            throw Throwables.propagate(ioe);
        }
    }

    public V getRawContent() {
        return this.content;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Payload)) {
            return false;
        }
        Payload other = (Payload)obj;
        return !(this.content == null ? other.getRawContent() != null : !this.content.equals(other.getRawContent()));
    }

    public String toString() {
        return "[content=" + (this.content != null) + ", contentMetadata=" + this.contentMetadata + ", written=" + this.written + ", isSensitive=" + this.isSensitive + "]";
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void release() {
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public void setContentMetadata(MutableContentMetadata in) {
        this.contentMetadata = in;
    }

    @Override
    public void setSensitive(boolean isSensitive) {
        this.isSensitive = isSensitive;
    }

    @Override
    public boolean isSensitive() {
        return this.isSensitive;
    }
}

