/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;

public class ThreadDumpUtil {
    private static final String INDENT = "    ";

    public static String buildThreadDiagnosticString() {
        StringWriter sw = new StringWriter();
        PrintWriter output = new PrintWriter(sw);
        output.println(ThreadDumpUtil.buildThreadDump());
        String deadlocksInfo = ThreadDumpUtil.buildDeadlockInfo();
        if (deadlocksInfo != null) {
            output.println("====> DEADLOCKS DETECTED <====");
            output.println();
            output.println(deadlocksInfo);
        }
        return sw.toString();
    }

    static String buildThreadDump() {
        try {
            return ThreadDumpUtil.callDiagnosticCommand("threadPrint", "-l");
        }
        catch (Exception exception) {
            StringBuilder dump = new StringBuilder();
            dump.append(String.format("Timestamp: %s", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(LocalDateTime.now())));
            dump.append("\n\n");
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> e : stackTraces.entrySet()) {
                Thread thread = e.getKey();
                dump.append('\n');
                dump.append(String.format("\"%s\" %s prio=%d tid=%d %s\njava.lang.Thread.State: %s", thread.getName(), thread.isDaemon() ? "daemon" : "", thread.getPriority(), thread.getId(), Thread.State.WAITING.equals((Object)thread.getState()) ? "in Object.wait()" : thread.getState().name(), Thread.State.WAITING.equals((Object)thread.getState()) ? "WAITING (on object monitor)" : thread.getState()));
                for (StackTraceElement stackTraceElement : e.getValue()) {
                    dump.append("\n        at ");
                    dump.append(stackTraceElement);
                }
                dump.append("\n");
            }
            return dump.toString();
        }
    }

    static String callDiagnosticCommand(String operationName, String ... args) throws JMException {
        return (String)ManagementFactory.getPlatformMBeanServer().invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), operationName, new Object[]{args}, new String[]{String[].class.getName()});
    }

    static String buildDeadlockInfo() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadBean.findDeadlockedThreads();
        if (threadIds != null && threadIds.length > 0) {
            ThreadInfo[] infos;
            StringWriter stringWriter = new StringWriter();
            PrintWriter out = new PrintWriter(stringWriter);
            for (ThreadInfo ti : infos = threadBean.getThreadInfo(threadIds, true, true)) {
                ThreadDumpUtil.printThreadInfo(ti, out);
                ThreadDumpUtil.printLockInfo(ti.getLockedSynchronizers(), out);
                out.println();
            }
            out.close();
            return stringWriter.toString();
        }
        return null;
    }

    private static void printThreadInfo(ThreadInfo ti, PrintWriter out) {
        ThreadDumpUtil.printThread(ti, out);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            out.println("    at " + ste.toString());
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                out.println("      - locked " + mi);
            }
        }
        out.println();
    }

    private static void printThread(ThreadInfo ti, PrintWriter out) {
        out.println();
        out.print("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            out.print(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            out.print(" (suspended)");
        }
        if (ti.isInNative()) {
            out.print(" (running in native)");
        }
        out.println();
        if (ti.getLockOwnerName() != null) {
            out.println("     owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }

    private static void printLockInfo(LockInfo[] locks, PrintWriter out) {
        out.println("    Locked synchronizers: count = " + locks.length);
        for (LockInfo li : locks) {
            out.println("      - " + li);
        }
        out.println();
    }
}

