/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mvc.MvcContext;
import javax.mvc.locale.LocaleResolver;
import javax.mvc.locale.LocaleResolverContext;
import javax.mvc.security.Csrf;
import javax.mvc.security.Encoders;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.annotations.PortletRequestScoped;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriBuilder;
import org.apache.pluto.container.bean.mvc.CsrfImpl;
import org.apache.pluto.container.bean.mvc.LocaleResolverChain;
import org.apache.pluto.container.bean.mvc.LocaleResolverContextImpl;
import org.apache.pluto.container.bean.mvc.SpringCsrfToken;
import org.apache.pluto.container.bean.mvc.UriInfoImpl;

@Named(value="mvc")
@PortletRequestScoped
public class MvcContextImpl
implements MvcContext {
    @Inject
    private Configuration configuration;
    private Csrf csrf;
    @Inject
    private Encoders encoders;
    private Locale locale;
    @Inject
    private LocaleResolverChain localeResolverChain;
    @Inject
    private PortletContext portletContext;
    @Inject
    private PortletRequest portletRequest;

    public String getBasePath() {
        return this.portletContext.getContextPath();
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Csrf getCsrf() {
        return this.csrf;
    }

    public Encoders getEncoders() {
        return this.encoders;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @PostConstruct
    public void postConstruct() {
        javax.servlet.http.Cookie[] cookies;
        SpringCsrfToken springCsrfToken = new SpringCsrfToken(this.portletRequest.getAttribute("org.springframework.security.web.csrf.CsrfToken"));
        this.csrf = new CsrfImpl(springCsrfToken.getName(), springCsrfToken.getValue());
        List<LocaleResolver> localeResolvers = this.localeResolverChain.getLocaleResolvers();
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        for (javax.servlet.http.Cookie cookie : cookies = this.portletRequest.getCookies()) {
            cookieMap.put(cookie.getName(), new Cookie(cookie.getName(), cookie.getValue()));
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration propertyNames = this.portletRequest.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String header = (String)propertyNames.nextElement();
            headerMap.put(header, this.portletRequest.getProperty(header));
        }
        LocaleResolverContextImpl localeResolverContext = new LocaleResolverContextImpl(Collections.list(this.portletRequest.getLocales()), this.configuration, cookieMap, headerMap, new UriInfoImpl());
        for (LocaleResolver localeResolver : localeResolvers) {
            this.locale = localeResolver.resolveLocale((LocaleResolverContext)localeResolverContext);
            if (this.locale == null) continue;
            break;
        }
    }

    public URI uri(String identifier) {
        throw new UnsupportedOperationException();
    }

    public URI uri(String identifier, Map<String, Object> params) {
        throw new UnsupportedOperationException();
    }

    public UriBuilder uriBuilder(String s) {
        throw new UnsupportedOperationException();
    }
}

