/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.pluto.container.ContainerInfo;
import org.apache.pluto.container.RequestDispatcherService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletContextImpl
implements PortletContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortletContextImpl.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    protected ServletContext servletContext;
    protected PortletApplicationDefinition portletApp;
    protected ContainerInfo containerInfo;
    protected List<String> supportedContainerRuntimeOptions;
    protected RequestDispatcherService rdService;

    public PortletContextImpl(ServletContext servletContext, PortletApplicationDefinition portletApp, ContainerInfo containerInfo, List<String> supportedContainerRuntimeOptions, RequestDispatcherService rdService) {
        this.servletContext = servletContext;
        this.portletApp = portletApp;
        this.containerInfo = containerInfo;
        this.supportedContainerRuntimeOptions = supportedContainerRuntimeOptions;
        this.rdService = rdService;
    }

    public String getServerInfo() {
        return this.containerInfo.getServerInfo();
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        return this.rdService.getRequestDispatcher(this.servletContext, this.portletApp, path);
    }

    public PortletRequestDispatcher getNamedDispatcher(String name) {
        return this.rdService.getNamedDispatcher(this.servletContext, this.portletApp, name);
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public int getMajorVersion() {
        return this.containerInfo.getMajorSpecificationVersion();
    }

    public int getMinorVersion() {
        return this.containerInfo.getMinorSpecificationVersion();
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException("path must start with a '/'");
        }
        return this.servletContext.getResource(path);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        return this.servletContext.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name == null");
        }
        return this.servletContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public void log(String msg) {
        this.servletContext.log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.setAttribute(name, object);
    }

    public String getPortletContextName() {
        return this.servletContext.getServletContextName();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PortletApplicationDefinition getPortletApplicationDefinition() {
        return this.portletApp;
    }

    public Enumeration<String> getContainerRuntimeOptions() {
        return Collections.enumeration(this.supportedContainerRuntimeOptions);
    }

    private int[] getVersion() {
        int[] vers = new int[]{0, 0};
        Object[] toks = this.portletApp.getVersion().split("\\.");
        try {
            if (toks.length != 2) {
                if (isDebug) {
                    StringBuilder txt = new StringBuilder();
                    txt.append("Problem parsing version. Version string: ").append(this.portletApp.getVersion());
                    txt.append(", tokens: ").append(Arrays.toString(toks));
                    LOG.debug(txt.toString());
                }
            } else {
                vers[0] = Integer.parseInt(toks[0]);
                vers[1] = Integer.parseInt(toks[1]);
            }
        }
        catch (Exception e) {
            StringBuilder txt = new StringBuilder();
            txt.append("Problem parsing version. Version string: ").append(this.portletApp.getVersion());
            txt.append(", tokens: ").append(Arrays.toString(toks));
            LOG.debug(txt.toString());
        }
        return vers;
    }

    public int getEffectiveMajorVersion() {
        return this.getVersion()[0];
    }

    public int getEffectiveMinorVersion() {
        return this.getVersion()[1];
    }

    public String getContextPath() {
        return this.portletApp.getContextPath();
    }

    public ClassLoader getClassLoader() {
        return this.servletContext.getClassLoader();
    }
}

