/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.portlet.PortletMode;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.Dependency;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PortletInfo;
import org.apache.pluto.container.om.portlet.Preferences;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet.impl.ContainerRuntimeOptionImpl;
import org.apache.pluto.container.om.portlet.impl.DependencyImpl;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionReferenceImpl;
import org.apache.pluto.container.om.portlet.impl.InitParamImpl;
import org.apache.pluto.container.om.portlet.impl.PortletInfoImpl;
import org.apache.pluto.container.om.portlet.impl.PreferencesImpl;
import org.apache.pluto.container.om.portlet.impl.SecurityRoleRefImpl;
import org.apache.pluto.container.om.portlet.impl.SupportsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletDefinitionImpl
implements PortletDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PortletDefinitionImpl.class);
    private PortletApplicationDefinition pad;
    private String portletName;
    private String portletClass;
    private String resourceBundle;
    private String cacheScope;
    private int expirationCache;
    private PortletInfo info;
    private Preferences prefs = new PreferencesImpl();
    private final List<String> supportedLocales = new ArrayList<String>();
    private final List<String> pubParms = new ArrayList<String>();
    private final List<Description> descs = new ArrayList<Description>();
    private final List<DisplayName> dispNames = new ArrayList<DisplayName>();
    private final List<EventDefinitionReference> proEvtRefs = new ArrayList<EventDefinitionReference>();
    private final List<EventDefinitionReference> pubEvtRefs = new ArrayList<EventDefinitionReference>();
    private final List<ContainerRuntimeOption> crtOptions = new ArrayList<ContainerRuntimeOption>();
    private final List<InitParam> iparms = new ArrayList<InitParam>();
    private final List<SecurityRoleRef> secRefs = new ArrayList<SecurityRoleRef>();
    private final List<Supports> supps = new ArrayList<Supports>();
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private boolean asyncSupported = false;
    private boolean multipartSupported = false;
    private String location = "";
    private Long maxFileSize = -1L;
    private Long maxRequestSize = -1L;
    private Integer fileSizeThreshold = 0;

    public PortletDefinitionImpl(PortletDefinition pd) {
        this.pad = pd.getApplication();
        this.portletName = pd.getPortletName();
        this.portletClass = pd.getPortletClass();
        this.resourceBundle = pd.getResourceBundle();
        this.cacheScope = pd.getCacheScope();
        this.expirationCache = pd.getExpirationCache();
        PortletInfo pi = pd.getPortletInfo();
        this.info = pi == null ? null : new PortletInfoImpl(pi);
        Preferences prefs = pd.getPortletPreferences();
        this.prefs = prefs == null ? null : new PreferencesImpl(prefs);
        this.supportedLocales.addAll(pd.getSupportedLocales());
        this.pubParms.addAll(pd.getSupportedPublicRenderParameters());
        for (Description d : pd.getDescriptions()) {
            this.descs.add(new DescriptionImpl(d));
        }
        for (DisplayName dn : pd.getDisplayNames()) {
            this.dispNames.add(new DisplayNameImpl(dn));
        }
        for (EventDefinitionReference edr : pd.getSupportedProcessingEvents()) {
            this.proEvtRefs.add(new EventDefinitionReferenceImpl(edr));
        }
        for (EventDefinitionReference edr : pd.getSupportedPublishingEvents()) {
            this.pubEvtRefs.add(new EventDefinitionReferenceImpl(edr));
        }
        for (ContainerRuntimeOption crt : pd.getContainerRuntimeOptions()) {
            this.crtOptions.add(new ContainerRuntimeOptionImpl(crt));
        }
        for (InitParam ip : pd.getInitParams()) {
            this.iparms.add(new InitParamImpl(ip));
        }
        for (SecurityRoleRef srr : pd.getSecurityRoleRefs()) {
            this.secRefs.add(new SecurityRoleRefImpl(srr));
        }
        for (Supports s : pd.getSupports()) {
            this.supps.add(new SupportsImpl(s));
        }
        for (Dependency dep : pd.getDependencies()) {
            this.dependencies.add(dep);
        }
        this.asyncSupported = pd.isAsyncSupported();
        this.multipartSupported = pd.isMultipartSupported();
        this.location = pd.getLocation();
        this.maxFileSize = pd.getMaxFileSize();
        this.maxRequestSize = pd.getMaxRequestSize();
        this.fileSizeThreshold = pd.getFileSizeThreshold();
    }

    public PortletDefinitionImpl(String pn, PortletApplicationDefinition pad) {
        this.portletName = pn;
        this.pad = pad;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public PortletApplicationDefinition getApplication() {
        return this.pad;
    }

    public InitParam getInitParam(String paramName) {
        InitParamImpl ret = null;
        for (InitParam item : this.iparms) {
            if (!item.getParamName().equals(paramName)) continue;
            ret = new InitParamImpl(item);
        }
        return ret;
    }

    public List<InitParam> getInitParams() {
        ArrayList<InitParam> ips = new ArrayList<InitParam>();
        for (InitParam ip : this.iparms) {
            ips.add(new InitParamImpl(ip));
        }
        return ips;
    }

    public void addInitParam(InitParam ip) {
        int ii = this.iparms.indexOf(ip);
        if (ii >= 0) {
            InitParam x = this.iparms.get(ii);
            this.iparms.remove(ii);
            StringBuilder txt = new StringBuilder(128);
            txt.append("Removed duplicate init parameter. name: ").append(x.getParamName());
            txt.append(", value: ").append(x.getParamValue());
            LOG.debug(txt.toString());
        }
        this.iparms.add(ip);
    }

    public String getPortletClass() {
        return this.portletClass;
    }

    public void setPortletClass(String portletClass) {
        this.portletClass = portletClass;
    }

    public PortletInfo getPortletInfo() {
        return this.info != null ? new PortletInfoImpl(this.info) : null;
    }

    public void setPortletInfo(PortletInfo info) {
        this.info = info;
    }

    public Preferences getPortletPreferences() {
        return new PreferencesImpl(this.prefs);
    }

    public void setPortletPreferences(Preferences prefs) {
        this.prefs = prefs;
    }

    public List<EventDefinitionReference> getSupportedProcessingEvents() {
        return new ArrayList<EventDefinitionReference>(this.proEvtRefs);
    }

    public void addSupportedProcessingEvent(EventDefinitionReference edr) {
        if (this.proEvtRefs.remove(edr)) {
            LOG.debug("Removed duplicate supported processing event ref: " + edr.getQualifiedName());
        }
        this.proEvtRefs.add(edr);
    }

    public boolean removeSupportedProcessingEvent(EventDefinitionReference edr) {
        return this.proEvtRefs.remove(edr);
    }

    public List<EventDefinitionReference> getSupportedPublishingEvents() {
        return new ArrayList<EventDefinitionReference>(this.pubEvtRefs);
    }

    public void addSupportedPublishingEvent(EventDefinitionReference edr) {
        if (this.pubEvtRefs.remove(edr)) {
            LOG.debug("Removed duplicate supported publishing event ref: " + edr.getQualifiedName());
        }
        this.pubEvtRefs.add(edr);
    }

    public boolean removeSupportedPublishingEvent(EventDefinitionReference edr) {
        return this.pubEvtRefs.remove(edr);
    }

    public List<String> getSupportedPublicRenderParameters() {
        return new ArrayList<String>(this.pubParms);
    }

    public void addSupportedPublicRenderParameter(String identifier) {
        if (this.pubParms.remove(identifier)) {
            LOG.debug("Removed duplicate supported render param: " + identifier);
        }
        this.pubParms.add(identifier);
    }

    public boolean removeSupportedPublicRenderParameter(String identifier) {
        return this.pubParms.remove(identifier);
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public SecurityRoleRef getSecurityRoleRef(String roleName) {
        SecurityRoleRefImpl ret = null;
        for (SecurityRoleRef item : this.secRefs) {
            if (!item.getRoleName().equals(roleName)) continue;
            ret = new SecurityRoleRefImpl(item);
        }
        return ret;
    }

    public List<SecurityRoleRef> getSecurityRoleRefs() {
        return new ArrayList<SecurityRoleRef>(this.secRefs);
    }

    public void addSecurityRoleRef(SecurityRoleRef srr) {
        if (this.secRefs.remove(srr)) {
            LOG.debug("Removed duplicate security role ref: " + srr.getRoleName());
        }
        this.secRefs.add(srr);
    }

    public Supports getSupports(String mimeType) {
        SupportsImpl ret = null;
        for (Supports item : this.supps) {
            if (!item.getMimeType().equals(mimeType)) continue;
            ret = new SupportsImpl(item);
        }
        return ret;
    }

    public List<Supports> getSupports() {
        return new ArrayList<Supports>(this.supps);
    }

    public void addSupports(Supports supp) {
        if (this.supps.remove(supp)) {
            LOG.warn("Overwriting duplicate supports block for: " + supp.getMimeType());
        }
        this.supps.add(supp);
    }

    public Set<String> getConfiguredMimeTypes() {
        HashSet<String> types = new HashSet<String>();
        for (Supports supp : this.supps) {
            types.add(supp.getMimeType());
        }
        return types;
    }

    public boolean isPortletModeSupported(String mimeType, PortletMode pm) {
        boolean supported = false;
        if (this.supps.isEmpty()) {
            if (pm.equals((Object)PortletMode.VIEW)) {
                supported = true;
            }
        } else if (this.getSupports(mimeType) != null) {
            if (pm.equals((Object)PortletMode.VIEW)) {
                supported = true;
            } else {
                for (String strpm : this.getSupports(mimeType).getPortletModes()) {
                    if (!new PortletMode(strpm).equals((Object)pm)) continue;
                    supported = true;
                    break;
                }
            }
        } else {
            for (Supports supp : this.supps) {
                if (!supp.getMimeType().matches("(?:\\*/\\*|\\*|text/\\*)")) continue;
                if (pm.equals((Object)PortletMode.VIEW)) {
                    supported = true;
                } else {
                    for (String strpm : supp.getPortletModes()) {
                        if (!new PortletMode(strpm).equals((Object)pm)) continue;
                        supported = true;
                        break;
                    }
                }
                if (!supported) continue;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder();
            txt.append("Portlet mode: ").append(pm.toString());
            txt.append(", MIME type: ").append(mimeType);
            txt.append(", is supported: ").append(supported);
            LOG.debug(txt.toString());
        }
        return supported;
    }

    public Dependency getDependency(String name) {
        DependencyImpl ret = null;
        for (Dependency item : this.dependencies) {
            if (!item.getName().equals(name)) continue;
            ret = new DependencyImpl(item);
        }
        return ret;
    }

    public List<Dependency> getDependencies() {
        return new ArrayList<Dependency>(this.dependencies);
    }

    public void addDependency(Dependency dep) {
        if (this.dependencies.remove(dep)) {
            LOG.debug("Removed duplicate dependencies block for: " + dep.getName());
        }
        this.dependencies.add(dep);
    }

    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    public void addDescription(Description desc) {
        if (this.descs.remove(desc)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Removed duplicate description for locale: ").append(desc.getLocale().toString());
            txt.append(", description: ").append(desc.getText());
            LOG.debug(txt.toString());
        }
        this.descs.add(desc);
    }

    public DisplayName getDisplayName(Locale locale) {
        DisplayNameImpl ret = null;
        for (DisplayName item : this.dispNames) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DisplayNameImpl(item);
        }
        return ret;
    }

    public List<DisplayName> getDisplayNames() {
        return new ArrayList<DisplayName>(this.dispNames);
    }

    public void addDisplayName(DisplayName dispName) {
        if (this.dispNames.remove(dispName)) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Removed duplicate description for locale: ").append(dispName.getLocale().toString());
            txt.append(", description: ").append(dispName.getText());
            LOG.debug(txt.toString());
        }
        this.dispNames.add(dispName);
    }

    public List<String> getSupportedLocales() {
        return new ArrayList<String>(this.supportedLocales);
    }

    public void addSupportedLocale(String lang) {
        if (this.supportedLocales.remove(lang)) {
            LOG.debug("Removed duplicate supported locale: " + lang);
        }
        this.supportedLocales.add(lang);
    }

    public int getExpirationCache() {
        return this.expirationCache;
    }

    public void setExpirationCache(int expirationCache) {
        this.expirationCache = expirationCache;
    }

    public String getCacheScope() {
        return this.cacheScope;
    }

    public void setCacheScope(String cacheScope) {
        this.cacheScope = cacheScope;
    }

    public ContainerRuntimeOption getContainerRuntimeOption(String name) {
        ContainerRuntimeOptionImpl ret = null;
        for (ContainerRuntimeOption item : this.crtOptions) {
            if (!item.getName().equals(name)) continue;
            ret = new ContainerRuntimeOptionImpl(item);
        }
        return ret;
    }

    public List<ContainerRuntimeOption> getContainerRuntimeOptions() {
        ArrayList<ContainerRuntimeOption> crtos = new ArrayList<ContainerRuntimeOption>();
        for (ContainerRuntimeOption crto : this.crtOptions) {
            crtos.add(new ContainerRuntimeOptionImpl(crto));
        }
        return crtos;
    }

    public void addContainerRuntimeOption(ContainerRuntimeOption cro) {
        int ii = this.crtOptions.indexOf(cro);
        if (ii >= 0) {
            ContainerRuntimeOption x = this.crtOptions.get(ii);
            this.crtOptions.remove(ii);
            StringBuilder txt = new StringBuilder(128);
            txt.append("Removed duplicate portlet container runtime option: ").append(x.getName());
            txt.append(", vals: ").append(x.getValues().toString());
            LOG.debug(txt.toString());
        }
        this.crtOptions.add(new ContainerRuntimeOptionImpl(cro));
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public boolean isMultipartSupported() {
        return this.multipartSupported;
    }

    public void setMultipartSupported(boolean multipartSupported) {
        this.multipartSupported = multipartSupported;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public Long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(Long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public Integer getFileSizeThreshold() {
        return this.fileSizeThreshold;
    }

    public void setFileSizeThreshold(Integer fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portletName == null ? 0 : this.portletName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortletDefinitionImpl other = (PortletDefinitionImpl)obj;
        return !(this.portletName == null ? other.portletName != null : !this.portletName.equals(other.portletName));
    }
}

