/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.portlet.annotations.PortletApplication;
import javax.portlet.annotations.PortletConfiguration;
import javax.portlet.annotations.PortletConfigurations;
import javax.portlet.annotations.PortletLifecycleFilter;
import javax.portlet.annotations.PortletListener;
import javax.portlet.annotations.PortletPreferencesValidator;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.pluto.container.bean.processor.AnnotatedMethodStore;
import org.apache.pluto.container.bean.processor.ConfigSummary;
import org.apache.pluto.container.bean.processor.MethodAnnotationRecognizer;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.impl.ConfigurationProcessor;
import org.apache.pluto.container.om.portlet.impl.JSR168ConfigurationProcessor;
import org.apache.pluto.container.om.portlet.impl.JSR286ConfigurationProcessor;
import org.apache.pluto.container.om.portlet.impl.JSR362ConfigurationProcessor;
import org.apache.pluto.container.om.portlet.impl.PortletApplicationDefinitionImpl;
import org.apache.pluto.container.om.portlet20.impl.PortletAppType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHolder {
    public static final String ATTRIB_NAME = "PortletAppConfig";
    private PortletApplicationDefinition pad = null;
    private ConfigurationProcessor jcp = null;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationHolder.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final String JAXB_CONTEXT = "org.apache.pluto.container.om.portlet10.impl:org.apache.pluto.container.om.portlet20.impl:org.apache.pluto.container.om.portlet30.impl";
    private ConfigSummary configSummary = new ConfigSummary();
    private AnnotatedMethodStore methodStore = new AnnotatedMethodStore(this.configSummary);
    private boolean portletsInstantiated = false;

    public ConfigurationHolder() {
        this.pad = new PortletApplicationDefinitionImpl();
    }

    public ConfigurationHolder(PortletApplicationDefinition pad) {
        this.pad = pad;
    }

    public PortletApplicationDefinition getPad() {
        return this.pad;
    }

    public AnnotatedMethodStore getMethodStore() {
        return this.methodStore;
    }

    public void setMethodStore(AnnotatedMethodStore methodStore) {
        this.methodStore = methodStore;
    }

    public ConfigSummary getConfigSummary() {
        return this.configSummary;
    }

    public void setConfigSummary(ConfigSummary configSummary) {
        this.configSummary = configSummary;
    }

    public void processPortletDD(InputStream stream) throws IOException, IllegalArgumentException, JAXBException, XMLStreamException {
        StringBuilder txt;
        XMLInputFactory xif;
        XMLStreamReader xsr;
        ClassLoader mycl = this.getClass().getClassLoader();
        JAXBContext cntxt = JAXBContext.newInstance((String)JAXB_CONTEXT, (ClassLoader)mycl);
        Unmarshaller um = cntxt.createUnmarshaller();
        JAXBElement jel = (JAXBElement)um.unmarshal(xsr = (xif = XMLInputFactory.newFactory()).createXMLStreamReader(stream));
        if (jel == null) {
            String warning = "Nothing could be unmarshalled. Stream didn't produce object";
            LOG.warn(warning);
            throw new IOException(warning);
        }
        if (isDebug) {
            txt = new StringBuilder();
            txt.append("Unmarshalled stream. ===> Object type: ");
            txt.append(jel.getValue().getClass().getCanonicalName());
            LOG.debug(txt.toString());
        }
        if (jel.getValue() instanceof org.apache.pluto.container.om.portlet10.impl.PortletAppType) {
            this.pad = new PortletApplicationDefinitionImpl();
            this.jcp = new JSR168ConfigurationProcessor(this.pad);
        } else if (jel.getValue() instanceof PortletAppType) {
            this.pad = new PortletApplicationDefinitionImpl();
            this.jcp = new JSR286ConfigurationProcessor(this.pad);
        } else if (jel.getValue() instanceof org.apache.pluto.container.om.portlet30.impl.PortletAppType) {
            this.jcp = this.jcp == null ? new JSR362ConfigurationProcessor(this.pad) : this.jcp;
        } else {
            String warning = "Unknown application type: " + jel.getValue().getClass().getCanonicalName();
            LOG.warn(warning);
            throw new IOException(warning);
        }
        this.jcp.process(jel);
        if (isDebug) {
            txt = new StringBuilder(128);
            txt.append("Parsed DD for Portlet app: ").append(this.pad.getName());
            txt.append(", # portlets: ").append(this.pad.getPortlets().size());
            txt.append(", names: ");
            String sep = "";
            for (PortletDefinition pd : this.pad.getPortlets()) {
                txt.append(sep).append(pd.getPortletName());
                sep = ", ";
            }
            LOG.debug(txt.toString());
        }
    }

    public void processWebDD(InputStream in) throws Exception {
        if (this.jcp == null) {
            this.jcp = new JSR286ConfigurationProcessor(this.pad);
        }
        this.jcp.processWebDD(in);
    }

    public void processConfigAnnotations(Set<Class<?>> classes) {
        if (classes != null) {
            this.jcp = new JSR362ConfigurationProcessor(this.pad);
            for (Class<?> cls : classes) {
                PortletConfigurations pcs;
                PortletConfiguration pc;
                PortletApplication pa = cls.getAnnotation(PortletApplication.class);
                if (pa != null) {
                    this.jcp.processPortletAppAnnotation(pa);
                }
                if ((pc = cls.getAnnotation(PortletConfiguration.class)) != null) {
                    this.jcp.processPortletConfigAnnotation(pc, cls);
                }
                if ((pcs = cls.getAnnotation(PortletConfigurations.class)) != null) {
                    for (PortletConfiguration config : pcs.value()) {
                        this.jcp.processPortletConfigAnnotation(config, cls);
                    }
                }
                if (cls.getAnnotation(PortletLifecycleFilter.class) != null) {
                    this.jcp.processPortletFilterAnnotation(cls);
                }
                if (cls.getAnnotation(PortletListener.class) != null) {
                    this.jcp.processListenerAnnotation(cls);
                }
                if (cls.getAnnotation(PortletPreferencesValidator.class) == null) continue;
                this.jcp.processValidatorAnnotation(cls);
            }
        }
    }

    public void validate() {
        if (this.jcp == null) {
            this.jcp = new JSR362ConfigurationProcessor(this.pad);
        }
        this.jcp.validate();
    }

    public void reconcileBeanConfig() {
        if (this.jcp == null) {
            this.jcp = new JSR362ConfigurationProcessor(this.pad);
        }
        this.jcp.reconcileBeanConfig(this.methodStore);
    }

    public void instantiatePortlets(BeanManager bm) {
        if (!this.portletsInstantiated) {
            this.portletsInstantiated = true;
            this.jcp.instantiatePortlets(this.methodStore, bm);
        }
    }

    public void scanMethodAnnotations(ServletContext ctx) {
        MethodAnnotationRecognizer mar = new MethodAnnotationRecognizer(this.methodStore, this.configSummary);
        mar.scanContext(ctx);
        LOG.debug("Scan complete: \n" + this.methodStore.getMethodsAsString());
    }

    public void scanMethodAnnotations(Set<File> files) {
        MethodAnnotationRecognizer mar = new MethodAnnotationRecognizer(this.methodStore, this.configSummary);
        mar.scanFiles(files);
        LOG.debug("Scan complete: \n" + this.methodStore.getMethodsAsString());
    }
}

