/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.Enumeration;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.ResourceURLProvider;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.util.ArgumentUtility;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public abstract class PortletResponseImpl
implements PortletResponse {
    private String namespace;
    private PortletResponseContext responseContext;

    public PortletResponseImpl(PortletResponseContext responseContext) {
        this.responseContext = responseContext;
    }

    protected PortletResponseContext getResponseContext() {
        return this.responseContext;
    }

    protected PortletWindow getPortletWindow() {
        return this.responseContext.getPortletWindow();
    }

    protected PortletContainer getPortletContainer() {
        return this.responseContext.getContainer();
    }

    protected PortalContext getPortalContext() {
        return this.getPortletContainer().getContainerServices().getPortalContext();
    }

    protected HttpServletRequest getServletRequest() {
        return this.responseContext.getServletRequest();
    }

    protected HttpServletResponse getServletResponse() {
        return this.responseContext.getServletResponse();
    }

    protected boolean isPortletModeAllowed(PortletMode mode) {
        if (PortletMode.VIEW.equals((Object)mode)) {
            return true;
        }
        String modeName = mode.toString();
        PortletDefinition dd = this.getPortletWindow().getPortletDefinition();
        for (Supports sup : dd.getSupports()) {
            for (String m : sup.getPortletModes()) {
                if (!m.equalsIgnoreCase(modeName)) continue;
                CustomPortletMode cpm = dd.getApplication().getCustomPortletMode(modeName);
                if (cpm != null && !cpm.isPortalManaged()) {
                    return true;
                }
                Enumeration supportedModes = this.getPortalContext().getSupportedPortletModes();
                while (supportedModes.hasMoreElements()) {
                    if (!((PortletMode)supportedModes.nextElement()).equals((Object)mode)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void addProperty(Cookie cookie) {
        ArgumentUtility.validateNotNull("cookie", cookie);
        this.responseContext.addProperty(cookie);
    }

    public void addProperty(String key, Element element) {
        ArgumentUtility.validateNotEmpty("key", key);
        this.responseContext.addProperty(key, element);
    }

    public void addProperty(String key, String value) {
        ArgumentUtility.validateNotEmpty("key", key);
        this.responseContext.addProperty(key, value);
    }

    public Element createElement(String tagName) throws DOMException {
        ArgumentUtility.validateNotEmpty("tagName", tagName);
        return this.responseContext.createElement(tagName);
    }

    public String encodeURL(String path) {
        if (path.indexOf("://") == -1 && !path.startsWith("/")) {
            throw new IllegalArgumentException("only absolute URLs or full path URIs are allowed");
        }
        ResourceURLProvider provider = this.responseContext.getResourceURLProvider();
        if (path.indexOf("://") != -1) {
            provider.setAbsoluteURL(path);
        } else {
            provider.setFullPath(path);
        }
        return this.getServletResponse().encodeURL(provider.toString());
    }

    public String getNamespace() {
        if (this.namespace == null) {
            this.namespace = this.getPortletContainer().getContainerServices().getNamespaceMapper().encode(this.getPortletWindow().getId(), "");
            StringBuffer validNamespace = new StringBuffer();
            for (int i = 0; i < this.namespace.length(); ++i) {
                char ch = this.namespace.charAt(i);
                if (Character.isJavaIdentifierPart(ch)) {
                    validNamespace.append(ch);
                    continue;
                }
                validNamespace.append('_');
            }
            this.namespace = validNamespace.toString();
        }
        return this.namespace;
    }

    public void setProperty(String key, String value) {
        ArgumentUtility.validateNotEmpty("key", key);
        this.responseContext.setProperty(key, value);
    }
}

