/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.pluto.container.PortletAppDescriptorService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet10.impl.ObjectFactory;
import org.apache.pluto.container.om.portlet10.impl.PortletAppType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PortletAppDescriptorServiceImpl
implements PortletAppDescriptorService {
    private static final Pattern LOCALE_SPLIT = Pattern.compile("[-|_]");
    private static final String NAMESPACE_PREFIX = "xp";
    private final JAXBContext jaxbContext;

    public static Locale convertStringToLocale(String lang) {
        if (lang == null) {
            return null;
        }
        String country = "";
        String variant = "";
        String[] localeArray = LOCALE_SPLIT.split(lang);
        for (int i = 0; i < localeArray.length; ++i) {
            if (i == 0) {
                lang = localeArray[i];
                continue;
            }
            if (i == 1) {
                country = localeArray[i];
                continue;
            }
            if (i != 2) continue;
            variant = localeArray[i];
        }
        return new Locale(lang, country, variant);
    }

    public PortletAppDescriptorServiceImpl() {
        ClassLoader containerClassLoader = PortletAppDescriptorServiceImpl.class.getClassLoader();
        try {
            this.jaxbContext = JAXBContext.newInstance((String)(ObjectFactory.class.getPackage().getName() + ":" + org.apache.pluto.container.om.portlet.impl.ObjectFactory.class.getPackage().getName()), (ClassLoader)containerClassLoader);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Failed to initialize JAXBContext for reading and writing portlet descriptors", e);
        }
    }

    public PortletApplicationDefinition read(String name, String contextPath, InputStream in) throws IOException {
        JAXBElement app;
        XMLStreamReader streamReader;
        if (in == null) {
            throw new IOException("Cannot read from a null InputStream");
        }
        XMLInputFactory xmlInputFactory = this.getXmlInputFactory();
        try {
            streamReader = xmlInputFactory.createXMLStreamReader(in);
        }
        catch (XMLStreamException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
        NamespaceOverridingStreamReaderDelegate delegatingStreamReader = new NamespaceOverridingStreamReaderDelegate(streamReader);
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            app = (JAXBElement)unmarshaller.unmarshal((XMLStreamReader)delegatingStreamReader);
        }
        catch (JAXBException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        PortletApplicationDefinition pad = null;
        pad = app.getValue() instanceof PortletAppType ? ((PortletAppType)app.getValue()).upgrade() : (PortletApplicationDefinition)app.getValue();
        pad.setName(name);
        pad.setContextPath(contextPath);
        return pad;
    }

    public void mergeWebDescriptor(PortletApplicationDefinition pa, InputStream webDescriptor) throws Exception {
        String prefix;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        builder.setEntityResolver(new WebAppDtdEntityResolver());
        Document document = builder.parse(webDescriptor);
        Element root = document.getDocumentElement();
        String namespace = root.getNamespaceURI();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        if (namespace != null && namespace.length() > 0) {
            prefix = "xp:";
            xpath.setNamespaceContext(new XPathNamespaceContext(NAMESPACE_PREFIX, namespace));
        } else {
            prefix = "";
            xpath.setNamespaceContext(new XPathNamespaceContext(""));
        }
        NodeList nodes = (NodeList)xpath.evaluate("/" + prefix + "web-app/" + prefix + "locale-encoding-mapping-list/" + prefix + "locale-encoding-mapping", document, XPathConstants.NODESET);
        if (nodes != null) {
            int nsize = nodes.getLength();
            for (int i = 0; i < nsize; ++i) {
                String encoding;
                String locale;
                Element element = (Element)nodes.item(i);
                NodeList children = element.getElementsByTagName("locale");
                if (children == null || children.getLength() == 0 || (locale = children.item(0).getTextContent().trim()).length() <= 0 || (children = element.getElementsByTagName("encoding")) == null || children.getLength() == 0 || (encoding = children.item(0).getTextContent().trim()).length() <= 0) continue;
                pa.getLocaleEncodingMappings().put(PortletAppDescriptorServiceImpl.convertStringToLocale(locale), encoding);
            }
        }
    }

    public void write(PortletApplicationDefinition app, OutputStream out) throws IOException {
        try {
            Object src = "1.0".equals(app.getVersion()) ? new PortletAppType(app) : app;
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(src, out);
        }
        catch (JAXBException jaxbEx) {
            IOException ioe = new IOException(jaxbEx.getMessage());
            ioe.initCause(jaxbEx);
            throw ioe;
        }
        catch (Exception me) {
            IOException ioe = new IOException(me.getLocalizedMessage());
            ioe.initCause(me);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLInputFactory getXmlInputFactory() {
        Thread currentThread;
        ClassLoader contextClassLoader;
        ClassLoader portalClassLoader = this.getClass().getClassLoader();
        if (portalClassLoader == (contextClassLoader = (currentThread = Thread.currentThread()).getContextClassLoader())) {
            return XMLInputFactory.newInstance();
        }
        try {
            currentThread.setContextClassLoader(portalClassLoader);
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            return xMLInputFactory;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XPathNamespaceContext
    implements NamespaceContext {
        private String namespaceURI;
        private String prefix;

        public XPathNamespaceContext(String prefix) {
            this(prefix, "http://www.w3.org/XML/1998/namespace");
        }

        public XPathNamespaceContext(String prefix, String namespaceURI) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Null prefix");
            }
            if (this.prefix.equals(prefix)) {
                return this.namespaceURI;
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }

    private static class NamespaceOverridingStreamReaderDelegate
    extends StreamReaderDelegate {
        private String adjustedNamespaceURI = null;

        private NamespaceOverridingStreamReaderDelegate(XMLStreamReader reader) {
            super(reader);
        }

        public int next() throws XMLStreamException {
            int eventCode = super.next();
            if (eventCode == 1 && "portlet-app".equals(this.getLocalName())) {
                String version = this.getAttributeValue(null, "version");
                if ("1.0".equals(version)) {
                    this.adjustedNamespaceURI = "http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd";
                } else if ("2.0".equals(version)) {
                    this.adjustedNamespaceURI = "http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd";
                }
            }
            return eventCode;
        }

        public String getNamespaceURI() {
            String namespaceURI = super.getNamespaceURI();
            return namespaceURI != null ? namespaceURI : this.adjustedNamespaceURI;
        }
    }

    private static class WebAppDtdEntityResolver
    implements EntityResolver {
        private WebAppDtdEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
            }
            return null;
        }
    }
}

