/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.RequestDispatcherService;
import org.apache.pluto.container.impl.HttpServletPortletRequestWrapper;
import org.apache.pluto.container.impl.HttpServletPortletResponseWrapper;
import org.apache.pluto.container.impl.PortletRequestDispatcherImpl;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcherServiceImpl
implements RequestDispatcherService {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDispatcherServiceImpl.class);

    public RequestDispatcherServiceImpl() {
        this(0);
    }

    public RequestDispatcherServiceImpl(int dispatchDetectionOrdinal) {
        HttpServletPortletRequestWrapper.dispatchDetection = dispatchDetectionOrdinal == HttpServletPortletRequestWrapper.DispatchDetection.CHECK_STATE.ordinal() ? HttpServletPortletRequestWrapper.DispatchDetection.CHECK_STATE : (dispatchDetectionOrdinal == HttpServletPortletRequestWrapper.DispatchDetection.CHECK_REQUEST_WRAPPER_STACK.ordinal() ? HttpServletPortletRequestWrapper.DispatchDetection.CHECK_STATE : HttpServletPortletRequestWrapper.DispatchDetection.EVALUATE);
    }

    public PortletRequestDispatcher getNamedDispatcher(ServletContext servletContext, PortletApplicationDefinition app, String name) {
        RequestDispatcher dispatcher;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Named PortletRequestDispatcher requested for name: " + name + " at context: " + app.getContextPath());
        }
        if ((dispatcher = servletContext.getNamedDispatcher(name)) != null) {
            return new PortletRequestDispatcherImpl(dispatcher, true);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("No matching request dispatcher found for name: " + name);
        }
        return null;
    }

    public PortletRequestDispatcher getRequestDispatcher(ServletContext servletContext, PortletApplicationDefinition app, String path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PortletRequestDispatcher requested for path: " + path + " at context: " + app.getContextPath());
        }
        if (path == null || !path.startsWith("/")) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Failed to retrieve PortletRequestDispatcher: path name must begin with a slash '/'.");
            }
            return null;
        }
        PortletRequestDispatcherImpl portletRequestDispatcher = null;
        try {
            RequestDispatcher servletRequestDispatcher = servletContext.getRequestDispatcher(path);
            if (servletRequestDispatcher != null) {
                portletRequestDispatcher = new PortletRequestDispatcherImpl(servletRequestDispatcher, false);
            } else if (LOG.isInfoEnabled()) {
                LOG.info("No matching request dispatcher found for: " + path);
            }
        }
        catch (Exception ex) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Failed to retrieve PortletRequestDispatcher: " + ex.getMessage());
            }
            portletRequestDispatcher = null;
        }
        return portletRequestDispatcher;
    }

    public HttpServletRequestWrapper getRequestWrapper(ServletContext servletContext, HttpServletRequest servletRequest, PortletRequest portletRequest, HttpSession session, boolean included, boolean named) {
        return new HttpServletPortletRequestWrapper(servletRequest, servletContext, session, portletRequest, included, named);
    }

    public HttpServletResponseWrapper getResponseWraper(ServletContext servletContext, HttpServletResponse servletResponse, PortletRequest portletRequest, PortletResponse portletResponse, boolean included) {
        return new HttpServletPortletResponseWrapper(servletResponse, portletRequest, portletResponse, included);
    }
}

