/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.Portlet;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.PreferencesValidator;
import javax.portlet.annotations.Dependency;
import javax.portlet.annotations.LocaleString;
import javax.portlet.annotations.Multipart;
import javax.portlet.annotations.PortletApplication;
import javax.portlet.annotations.PortletConfiguration;
import javax.portlet.annotations.PortletLifecycleFilter;
import javax.portlet.annotations.PortletListener;
import javax.portlet.annotations.PortletPreferencesValidator;
import javax.portlet.annotations.RuntimeOption;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.HeaderFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.FilterMapping;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PortletInfo;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.Preferences;
import org.apache.pluto.container.om.portlet.PublicRenderParameter;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet.impl.ContainerRuntimeOptionImpl;
import org.apache.pluto.container.om.portlet.impl.CustomPortletModeImpl;
import org.apache.pluto.container.om.portlet.impl.CustomWindowStateImpl;
import org.apache.pluto.container.om.portlet.impl.DependencyImpl;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionImpl;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionReferenceImpl;
import org.apache.pluto.container.om.portlet.impl.FilterImpl;
import org.apache.pluto.container.om.portlet.impl.FilterMappingImpl;
import org.apache.pluto.container.om.portlet.impl.InitParamImpl;
import org.apache.pluto.container.om.portlet.impl.JSR286ConfigurationProcessor;
import org.apache.pluto.container.om.portlet.impl.ListenerImpl;
import org.apache.pluto.container.om.portlet.impl.LocaleTextImpl;
import org.apache.pluto.container.om.portlet.impl.PortletDefinitionImpl;
import org.apache.pluto.container.om.portlet.impl.PortletInfoImpl;
import org.apache.pluto.container.om.portlet.impl.PreferenceImpl;
import org.apache.pluto.container.om.portlet.impl.PreferencesImpl;
import org.apache.pluto.container.om.portlet.impl.PublicRenderParameterImpl;
import org.apache.pluto.container.om.portlet.impl.SecurityRoleRefImpl;
import org.apache.pluto.container.om.portlet.impl.SupportsImpl;
import org.apache.pluto.container.om.portlet.impl.UserAttributeImpl;
import org.apache.pluto.container.om.portlet30.impl.ContainerRuntimeOptionType;
import org.apache.pluto.container.om.portlet30.impl.CustomPortletModeType;
import org.apache.pluto.container.om.portlet30.impl.CustomWindowStateType;
import org.apache.pluto.container.om.portlet30.impl.DependencyType;
import org.apache.pluto.container.om.portlet30.impl.DescriptionType;
import org.apache.pluto.container.om.portlet30.impl.DisplayNameType;
import org.apache.pluto.container.om.portlet30.impl.EventDefinitionReferenceType;
import org.apache.pluto.container.om.portlet30.impl.EventDefinitionType;
import org.apache.pluto.container.om.portlet30.impl.FilterMappingType;
import org.apache.pluto.container.om.portlet30.impl.FilterType;
import org.apache.pluto.container.om.portlet30.impl.InitParamType;
import org.apache.pluto.container.om.portlet30.impl.KeywordsType;
import org.apache.pluto.container.om.portlet30.impl.ListenerType;
import org.apache.pluto.container.om.portlet30.impl.MimeTypeType;
import org.apache.pluto.container.om.portlet30.impl.MultipartType;
import org.apache.pluto.container.om.portlet30.impl.PortletAppType;
import org.apache.pluto.container.om.portlet30.impl.PortletInfoType;
import org.apache.pluto.container.om.portlet30.impl.PortletModeType;
import org.apache.pluto.container.om.portlet30.impl.PortletNameType;
import org.apache.pluto.container.om.portlet30.impl.PortletPreferencesType;
import org.apache.pluto.container.om.portlet30.impl.PortletType;
import org.apache.pluto.container.om.portlet30.impl.PreferenceType;
import org.apache.pluto.container.om.portlet30.impl.PublicRenderParameterType;
import org.apache.pluto.container.om.portlet30.impl.RoleLinkType;
import org.apache.pluto.container.om.portlet30.impl.SecurityRoleRefType;
import org.apache.pluto.container.om.portlet30.impl.ShortTitleType;
import org.apache.pluto.container.om.portlet30.impl.SupportedLocaleType;
import org.apache.pluto.container.om.portlet30.impl.SupportsType;
import org.apache.pluto.container.om.portlet30.impl.TitleType;
import org.apache.pluto.container.om.portlet30.impl.UserAttributeType;
import org.apache.pluto.container.om.portlet30.impl.ValueType;
import org.apache.pluto.container.om.portlet30.impl.WindowStateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR362ConfigurationProcessor
extends JSR286ConfigurationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JSR362ConfigurationProcessor.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private Map<PortletPreferencesValidator, String> prefValidators = new HashMap<PortletPreferencesValidator, String>();

    public JSR362ConfigurationProcessor(PortletApplicationDefinition pad) {
        super(pad);
    }

    @Override
    public void process(JAXBElement<?> rootElement) throws IllegalArgumentException {
        assert (rootElement != null);
        assert (rootElement.getValue() instanceof PortletAppType);
        PortletAppType app = (PortletAppType)rootElement.getValue();
        this.pad.setId(app.getId());
        if (app.getVersion() == null || !app.getVersion().equals("3.0")) {
            String warning = "Bad version. Expected 3.0, was: " + app.getVersion();
            LOG.warn(warning);
            throw new IllegalArgumentException(warning);
        }
        this.pad.setVersion(app.getVersion());
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Reading portlet DD. ");
            txt.append("Version: ");
            txt.append(app.getVersion());
            txt.append(", ID: ");
            txt.append(app.getId());
            LOG.trace(txt.toString());
        }
        if (app.getDefaultNamespace() != null && !app.getDefaultNamespace().equals("")) {
            this.pad.setDefaultNamespace(app.getDefaultNamespace());
        }
        if (app.getResourceBundle() != null && app.getResourceBundle().getValue() != null && !app.getResourceBundle().getValue().equals("")) {
            this.pad.setResourceBundle(app.getResourceBundle().getValue());
        }
        for (EventDefinition ed : this.handleEventDefs(app.getEventDefinition())) {
            this.pad.addEventDefinition(ed);
        }
        for (PublicRenderParameter prp : this.handlePRPs(app.getPublicRenderParameter())) {
            this.pad.addPublicRenderParameter(prp);
        }
        for (ContainerRuntimeOption cro : this.handleRTOptions(app.getContainerRuntimeOption())) {
            this.pad.addContainerRuntimeOption(cro);
        }
        this.handleCPM(app.getCustomPortletMode());
        this.handleCWS(app.getCustomWindowState());
        this.handleUA(app.getUserAttribute());
        this.handleListeners(app.getListener());
        this.handleFilters(app.getFilter());
        this.handlePortlets(app.getPortlet());
        this.handleFilterMappings(app.getFilterMapping());
    }

    private List<DisplayName> handleDisplayNames(List<DisplayNameType> dispNames) {
        ArrayList<DisplayName> list = new ArrayList<DisplayName>();
        for (DisplayNameType dispName : dispNames) {
            if (dispName.getValue() == null) {
                String warning = "Bad display name - no display name value; will be ignored. continuing ...";
                LOG.warn(warning);
                continue;
            }
            Locale loc = this.deriveLocale(dispName.getLang());
            DisplayNameImpl d = new DisplayNameImpl(loc, dispName.getValue());
            list.add(d);
        }
        return list;
    }

    private List<Description> handleDescriptions(List<DescriptionType> descs) {
        ArrayList<Description> list = new ArrayList<Description>();
        for (DescriptionType desc : descs) {
            if (desc.getValue() == null) {
                String warning = "Bad description - no description value; will be ignored. continuing ...";
                LOG.warn(warning);
                continue;
            }
            Locale loc = this.deriveLocale(desc.getLang());
            DescriptionImpl d = new DescriptionImpl(loc, desc.getValue());
            list.add(d);
        }
        return list;
    }

    private void handleUA(List<UserAttributeType> uats) {
        for (UserAttributeType uat : uats) {
            if (uat.getName() == null || uat.getName().getValue() == null) {
                String warning = "Bad user attribute will be ignored. Name was null. Continuing ...";
                LOG.warn(warning);
                continue;
            }
            UserAttributeImpl attr = new UserAttributeImpl(uat.getName().getValue());
            for (Description desc : this.handleDescriptions(uat.getDescription())) {
                attr.addDescription(desc);
            }
            this.pad.addUserAttribute(attr);
        }
    }

    private void handleFilters(List<FilterType> args) {
        for (FilterType item : args) {
            String fn = item.getFilterName();
            if (fn == null || fn.length() == 0) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Bad Filter definition.");
                txt.append(" Filter name is empty. ");
                txt.append(", Filter class: ").append(item.getFilterClass());
                LOG.warn(txt.toString());
                throw new IllegalArgumentException(txt.toString());
            }
            String fc = item.getFilterClass();
            if (this.pad.getFilter(fn) == null && (fc == null || fc.length() == 0)) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Bad Filter definition.");
                txt.append(" Filter name: ").append(item.getFilterName());
                txt.append(", Filter class is empty.");
                LOG.warn(txt.toString());
                throw new IllegalArgumentException(txt.toString());
            }
            FilterImpl newitem = new FilterImpl(item.getFilterName());
            newitem.setFilterClass(item.getFilterClass());
            for (InitParam ip : this.handleInitParam(item.getInitParam())) {
                newitem.addInitParam(ip);
            }
            for (String lc : item.getLifecycle()) {
                newitem.addLifecycle(lc);
            }
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                newitem.addDescription(desc);
            }
            for (DisplayName dispName : this.handleDisplayNames(item.getDisplayName())) {
                newitem.addDisplayName(dispName);
            }
            newitem.setOrdinal(item.getOrdinal() == null ? 0 : item.getOrdinal());
            this.pad.addFilter(newitem);
        }
    }

    private void handleFilterMappings(List<FilterMappingType> args) {
        for (FilterMappingType item : args) {
            String fname = item.getFilterName();
            if (fname == null || item.getPortletName().size() == 0) {
                String warning = "Bad FilterMapping definition. Filter name or portlet name is null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            FilterMappingImpl newitem = new FilterMappingImpl(fname);
            for (PortletNameType pnt : item.getPortletName()) {
                newitem.addPortletName(pnt.getValue());
            }
            this.pad.addFilterMapping(newitem);
        }
    }

    private void handleListeners(List<ListenerType> args) {
        for (ListenerType item : args) {
            String name = item.getListenerName();
            if (!(name != null && name.length() != 0 && this.pad.getListener(name) != null || item.getListenerClass() != null && item.getListenerClass().length() != 0)) {
                String warning = "Bad Listener definition. Class was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            if (name == null || name.length() == 0) {
                name = this.genUniqueName();
            }
            ListenerImpl newitem = new ListenerImpl(item.getListenerClass());
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                newitem.addDescription(desc);
            }
            for (DisplayName dispName : this.handleDisplayNames(item.getDisplayName())) {
                newitem.addDisplayName(dispName);
            }
            newitem.setOrdinal(item.getOrdinal() == null ? 0 : item.getOrdinal());
            newitem.setListenerName(name);
            this.pad.addListener(newitem);
        }
    }

    private void handleCPM(List<CustomPortletModeType> cpms) {
        for (CustomPortletModeType cpm : cpms) {
            if (cpm.getPortletMode() == null || cpm.getPortletMode().getValue() == null) {
                String warning = "Custom portlet mode cannot be null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String val = cpm.getPortletMode().getValue();
            if (val.equalsIgnoreCase("view") || val.equalsIgnoreCase("edit") || val.equalsIgnoreCase("help")) {
                String warning = "Bad custom portlet mode: " + val;
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            CustomPortletModeImpl pm = new CustomPortletModeImpl(cpm.getPortletMode().getValue());
            for (Description desc : this.handleDescriptions(cpm.getDescription())) {
                pm.addDescription(desc);
            }
            boolean isPortalManaged = true;
            if (cpm.getPortalManaged() != null && cpm.getPortalManaged().value() != null) {
                isPortalManaged = cpm.getPortalManaged().value().equalsIgnoreCase("true");
            }
            pm.setPortalManaged(isPortalManaged);
            this.pad.addCustomPortletMode(pm);
        }
    }

    private void handleCWS(List<CustomWindowStateType> cwss) {
        for (CustomWindowStateType cws : cwss) {
            if (cws.getWindowState() == null || cws.getWindowState().getValue() == null) {
                String warning = "Custom window state cannot be null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String val = cws.getWindowState().getValue();
            if (val.equalsIgnoreCase("normal") || val.equalsIgnoreCase("maximized") || val.equalsIgnoreCase("minimized")) {
                String warning = "Bad custom window state: " + val;
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            CustomWindowStateImpl ws = new CustomWindowStateImpl(cws.getWindowState().getValue());
            for (Description desc : this.handleDescriptions(cws.getDescription())) {
                ws.addDescription(desc);
            }
            this.pad.addCustomWindowState(ws);
        }
    }

    private List<Supports> handleSupports(List<SupportsType> sts) {
        ArrayList<Supports> newSupps = new ArrayList<Supports>();
        for (SupportsType st : sts) {
            List<WindowStateType> wslist;
            MimeTypeType mtt = st.getMimeType();
            if (mtt == null || mtt.getValue() == null) {
                String warning = "Null Mime type, ignoring Supports block.";
                LOG.warn(warning);
                continue;
            }
            List<PortletModeType> pmlist = st.getPortletMode();
            if (pmlist.size() == 0) {
                String info = "No portlet modes found in Supports block.";
                LOG.trace(info);
            }
            if ((wslist = st.getWindowState()).size() == 0) {
                String info = "No window states found in Supports block.";
                LOG.trace(info);
            }
            String mimetype = mtt.getValue().replaceAll("([^;]*).*", "$1").replaceAll(" ", "");
            SupportsImpl sup = new SupportsImpl(mimetype);
            for (PortletModeType portletModeType : pmlist) {
                sup.addPortletMode(portletModeType.getValue());
            }
            for (WindowStateType windowStateType : wslist) {
                sup.addWindowState(windowStateType.getValue());
            }
            newSupps.add(sup);
        }
        return newSupps;
    }

    private List<InitParam> handleInitParam(List<InitParamType> parms) {
        ArrayList<InitParam> newParms = new ArrayList<InitParam>();
        for (InitParamType parm : parms) {
            if (parm.getName() == null || parm.getName().getValue() == null || parm.getName().getValue().length() == 0) {
                String warning = "Bad init parameter. Parameter name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = parm.getName().getValue();
            String value = parm.getValue().getValue();
            InitParamImpl newp = new InitParamImpl(name, value);
            for (Description desc : this.handleDescriptions(parm.getDescription())) {
                newp.addDescription(desc);
            }
            newParms.add(newp);
        }
        return newParms;
    }

    private List<Preference> handlePreferences(List<PreferenceType> args) {
        ArrayList<Preference> list = new ArrayList<Preference>();
        for (PreferenceType item : args) {
            if (item.getName() == null || item.getName().getValue() == null || item.getName().getValue().length() == 0) {
                String warning = "Bad portlet preference. Preference name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName().getValue();
            List<ValueType> vals = item.getValue();
            ArrayList<String> lines = new ArrayList<String>(16);
            for (ValueType vt : vals) {
                lines.add(vt.getValue());
            }
            boolean isRO = false;
            if (item.getReadOnly() != null && item.getReadOnly().value() != null) {
                isRO = item.getReadOnly().value().equalsIgnoreCase("true");
            }
            PreferenceImpl pref = new PreferenceImpl(name, isRO, lines);
            list.add(pref);
        }
        return list;
    }

    private List<ContainerRuntimeOption> handleRTOptions(List<ContainerRuntimeOptionType> args) {
        ArrayList<ContainerRuntimeOption> list = new ArrayList<ContainerRuntimeOption>();
        for (ContainerRuntimeOptionType arg : args) {
            if (arg.getName() == null || arg.getName().getValue() == null || arg.getName().getValue().equals("")) {
                String warning = "Bad container runtime option. Name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = arg.getName().getValue();
            List<ValueType> vals = arg.getValue();
            ArrayList<String> lines = new ArrayList<String>(16);
            for (ValueType vt : vals) {
                lines.add(vt.getValue());
            }
            ContainerRuntimeOptionImpl item = new ContainerRuntimeOptionImpl(name, lines);
            list.add(item);
        }
        return list;
    }

    private List<SecurityRoleRef> handleSecRoleRef(List<SecurityRoleRefType> args) {
        ArrayList<SecurityRoleRef> list = new ArrayList<SecurityRoleRef>();
        for (SecurityRoleRefType item : args) {
            String roleLinkValue;
            if (item.getRoleName() == null || item.getRoleName().length() == 0) {
                String warning = "Bad security role reference. Name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getRoleName();
            SecurityRoleRefImpl srr = new SecurityRoleRefImpl(name);
            RoleLinkType roleLink = item.getRoleLink();
            if (roleLink != null && (roleLinkValue = roleLink.getValue()) != null && roleLinkValue.length() > 0) {
                srr.setRoleLink(roleLinkValue);
            }
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                srr.addDescription(desc);
            }
            list.add(srr);
        }
        return list;
    }

    private List<EventDefinitionReference> handleEventDefRefs(List<EventDefinitionReferenceType> args) {
        ArrayList<EventDefinitionReference> list = new ArrayList<EventDefinitionReference>();
        for (EventDefinitionReferenceType item : args) {
            if (item.getName() == null && item.getQname() == null) {
                String warning = "Bad Even definition reference. Name and QName are null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName();
            QName qname = item.getQname();
            if (qname == null) {
                qname = new QName(this.pad.getDefaultNamespace(), name);
            }
            EventDefinitionReferenceImpl newedr = new EventDefinitionReferenceImpl(qname);
            list.add(newedr);
        }
        return list;
    }

    private List<EventDefinition> handleEventDefs(List<EventDefinitionType> args) {
        ArrayList<EventDefinition> list = new ArrayList<EventDefinition>();
        for (EventDefinitionType item : args) {
            if (item.getName() == null && item.getQname() == null) {
                String warning = "Bad Event definition. Name and QName are null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName();
            QName qname = item.getQname();
            if (qname == null) {
                qname = new QName(this.pad.getDefaultNamespace(), name);
            }
            EventDefinitionImpl newed = new EventDefinitionImpl(qname);
            String clsName = item.getValueType();
            if (clsName != null && clsName.length() > 0) {
                newed.setValueType(clsName);
            }
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                newed.addDescription(desc);
            }
            for (QName qn : item.getAlias()) {
                newed.addAlias(qn);
            }
            list.add(newed);
        }
        return list;
    }

    private List<PublicRenderParameter> handlePRPs(List<PublicRenderParameterType> args) {
        ArrayList<PublicRenderParameter> list = new ArrayList<PublicRenderParameter>();
        for (PublicRenderParameterType item : args) {
            if (item.getName() == null && item.getQname() == null) {
                String warning = "Bad public render parameter definition. Name and QName are null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String id = item.getIdentifier();
            if (id == null || id.length() == 0) {
                String warning = "Bad public render parameter definition. Identifier is null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName();
            QName qname = item.getQname();
            if (qname == null) {
                qname = new QName(this.pad.getDefaultNamespace(), name);
            }
            PublicRenderParameterImpl newprp = new PublicRenderParameterImpl(qname, id);
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                newprp.addDescription(desc);
            }
            list.add(newprp);
        }
        return list;
    }

    private void handlePortlets(List<PortletType> portlets) {
        for (PortletType portlet : portlets) {
            MultipartType muty;
            if (portlet.getPortletName() == null || portlet.getPortletName().getValue() == null || portlet.getPortletName().getValue().length() == 0) {
                String warning = "Portlet name may not be null";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String pn = portlet.getPortletName().getValue();
            String clsName = portlet.getPortletClass();
            PortletDefinition pd = this.pad.getPortlet(pn);
            if (pd == null) {
                if (clsName == null || clsName.length() == 0) {
                    String warning = "Portlet class may not be null. Portlet name: " + pn;
                    LOG.warn(warning);
                    throw new IllegalArgumentException(warning);
                }
                pd = new PortletDefinitionImpl(pn, this.pad);
                pd.setPortletClass(portlet.getPortletClass());
            } else if (clsName != null && clsName.length() > 0) {
                pd.setPortletClass(portlet.getPortletClass());
            }
            if (portlet.getResourceBundle() != null) {
                pd.setResourceBundle(portlet.getResourceBundle().getValue());
            }
            if (portlet.getExpirationCache() != null) {
                pd.setExpirationCache(portlet.getExpirationCache().getValue());
            }
            if (portlet.getCacheScope() != null) {
                pd.setCacheScope(portlet.getCacheScope().getValue());
            }
            for (DisplayName dispName : this.handleDisplayNames(portlet.getDisplayName())) {
                pd.addDisplayName(dispName);
            }
            for (Description desc : this.handleDescriptions(portlet.getDescription())) {
                pd.addDescription(desc);
            }
            for (Supports s : this.handleSupports(portlet.getSupports())) {
                pd.addSupports(s);
            }
            PortletInfoType pit = portlet.getPortletInfo();
            if (pit != null) {
                Locale loc;
                Object info = pd.getPortletInfo();
                if (info == null) {
                    info = new PortletInfoImpl();
                }
                for (TitleType titleType : pit.getTitle()) {
                    loc = titleType.getLang() == null ? Locale.ENGLISH : Locale.forLanguageTag(titleType.getLang());
                    info.addTitle(new LocaleTextImpl(loc, titleType.getValue()));
                }
                for (ShortTitleType shortTitleType : pit.getShortTitle()) {
                    loc = shortTitleType.getLang() == null ? Locale.ENGLISH : Locale.forLanguageTag(shortTitleType.getLang());
                    info.addShortTitle(new LocaleTextImpl(loc, shortTitleType.getValue()));
                }
                for (KeywordsType keywordsType : pit.getKeywords()) {
                    loc = keywordsType.getLang() == null ? Locale.ENGLISH : Locale.forLanguageTag(keywordsType.getLang());
                    info.addKeywords(new LocaleTextImpl(loc, keywordsType.getValue()));
                }
                pd.setPortletInfo((PortletInfo)info);
            }
            for (SupportedLocaleType slt : portlet.getSupportedLocale()) {
                pd.addSupportedLocale(slt.getValue());
            }
            for (InitParam ip : this.handleInitParam(portlet.getInitParam())) {
                pd.addInitParam(ip);
            }
            PortletPreferencesType prefs = portlet.getPortletPreferences();
            if (prefs != null) {
                Iterator<Object> newprefs = pd.getPortletPreferences();
                clsName = prefs.getPreferencesValidator();
                if (clsName != null && clsName.length() > 0) {
                    if (clsName.equals("null")) {
                        newprefs.setNullValidator(true);
                    } else {
                        newprefs.setPreferencesValidator(clsName);
                    }
                }
                for (Preference p : this.handlePreferences(prefs.getPreference())) {
                    newprefs.addPreference(p);
                }
                pd.setPortletPreferences((Preferences)((Object)newprefs));
            }
            for (SecurityRoleRef securityRoleRef : this.handleSecRoleRef(portlet.getSecurityRoleRef())) {
                pd.addSecurityRoleRef(securityRoleRef);
            }
            for (ContainerRuntimeOption containerRuntimeOption : this.handleRTOptions(portlet.getContainerRuntimeOption())) {
                pd.addContainerRuntimeOption(containerRuntimeOption);
            }
            for (String string : portlet.getSupportedPublicRenderParameter()) {
                if (string == null || string.length() == 0) {
                    String warning = "Supported public render parameter definition may not be null.";
                    LOG.warn(warning);
                    throw new IllegalArgumentException(warning);
                }
                pd.addSupportedPublicRenderParameter(string);
            }
            for (EventDefinitionReference eventDefinitionReference : this.handleEventDefRefs(portlet.getSupportedProcessingEvent())) {
                pd.addSupportedProcessingEvent(eventDefinitionReference);
            }
            for (EventDefinitionReference eventDefinitionReference : this.handleEventDefRefs(portlet.getSupportedPublishingEvent())) {
                pd.addSupportedPublishingEvent(eventDefinitionReference);
            }
            for (DependencyType dependencyType : portlet.getDependency()) {
                String warn;
                if (dependencyType.getName() == null || dependencyType.getName().length() == 0) {
                    warn = "Dependency name is empty, ignoring Dependency block.";
                    LOG.warn(warn);
                    continue;
                }
                if (dependencyType.getVersion() == null || dependencyType.getVersion().length() == 0) {
                    warn = "Dependency version is empty.";
                    LOG.info(warn);
                }
                DependencyImpl dep = new DependencyImpl(dependencyType.getName(), dependencyType.getScope(), dependencyType.getVersion());
                pd.addDependency(dep);
            }
            if (portlet.isAsyncSupported() != null) {
                pd.setAsyncSupported(portlet.isAsyncSupported());
            }
            if ((muty = portlet.getMultipartConfig()) != null) {
                pd.setMultipartSupported(true);
                pd.setLocation(muty.getLocation());
                pd.setFileSizeThreshold(muty.getFileSizeThreshold());
                pd.setMaxFileSize(muty.getMaxFileSize());
                pd.setMaxRequestSize(muty.getMaxRequestSize());
            }
            this.pad.addPortlet(pd);
        }
    }

    @Override
    public void validate() {
        for (FilterMapping fm : this.pad.getFilterMappings()) {
            if (fm.getPortletNames().size() != 1 || !fm.getPortletNames().get(0).equals("*")) continue;
            fm.removePortletName("*");
            for (PortletDefinition pd : this.pad.getPortlets()) {
                fm.addPortletName(pd.getPortletName());
            }
            this.pad.addFilterMapping(fm);
        }
        for (PortletPreferencesValidator vali : this.prefValidators.keySet()) {
            String[] pns = vali.portletNames();
            String clsName = this.prefValidators.get(vali);
            if (pns.length > 0 && pns[0].equals("*")) {
                for (PortletDefinition pd : this.pad.getPortlets()) {
                    Preferences prefs = pd.getPortletPreferences();
                    String oldVali = prefs.getPreferencesValidator();
                    if (oldVali != null && oldVali.length() != 0 || prefs.isNullValidator()) continue;
                    prefs.setPreferencesValidator(clsName);
                    pd.setPortletPreferences(prefs);
                    this.pad.addPortlet(pd);
                }
                continue;
            }
            for (String pn : pns) {
                PortletDefinition pd = this.pad.getPortlet(pn);
                if (pd == null) {
                    StringBuilder txt = new StringBuilder(128);
                    txt.append("Portlet name defined in preferences validator annotation could not be found in configuration.");
                    txt.append(" Portlet name: ").append(pn);
                    txt.append(" Preferences validator class: ").append(clsName);
                    LOG.warn(txt.toString());
                    continue;
                }
                Preferences prefs = pd.getPortletPreferences();
                String oldVali = prefs.getPreferencesValidator();
                if (oldVali != null && oldVali.length() != 0 || prefs.isNullValidator()) continue;
                prefs.setPreferencesValidator(clsName);
                pd.setPortletPreferences(prefs);
                this.pad.addPortlet(pd);
            }
        }
        super.validate();
    }

    @Override
    public void processPortletAppAnnotation(PortletApplication app) {
        if (!app.version().equals("3.0")) {
            String warning = "Bad version in annotation. Expected 3.0, was: " + app.version();
            LOG.warn(warning);
            throw new IllegalArgumentException(warning);
        }
        this.pad.setVersion(app.version());
        if (app.defaultNamespaceURI().length() > 0) {
            this.pad.setDefaultNamespace(app.defaultNamespaceURI());
        }
        if (app.resourceBundle().length() > 0) {
            this.pad.setResourceBundle(app.resourceBundle());
        }
        for (RuntimeOption runtimeOption : app.runtimeOptions()) {
            ContainerRuntimeOptionImpl cro = new ContainerRuntimeOptionImpl(runtimeOption.name(), Arrays.asList(runtimeOption.values()));
            this.pad.addContainerRuntimeOption(cro);
        }
        for (RuntimeOption runtimeOption : app.userAttributes()) {
            UserAttributeImpl attrib = new UserAttributeImpl(runtimeOption.name());
            for (LocaleString ls : runtimeOption.description()) {
                DescriptionImpl d = new DescriptionImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                attrib.addDescription(d);
            }
            this.pad.addUserAttribute(attrib);
        }
        for (RuntimeOption runtimeOption : app.publicParams()) {
            LocaleTextImpl d;
            QName qn = new QName(runtimeOption.qname().namespaceURI(), runtimeOption.qname().localPart());
            PublicRenderParameterImpl prp = new PublicRenderParameterImpl(qn, runtimeOption.identifier());
            for (LocaleString ls : runtimeOption.description()) {
                d = new DescriptionImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                prp.addDescription((Description)((Object)d));
            }
            for (LocaleString ls : runtimeOption.displayName()) {
                d = new DisplayNameImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                prp.addDisplayName((DisplayName)((Object)d));
            }
            this.pad.addPublicRenderParameter(prp);
        }
        for (RuntimeOption runtimeOption : app.events()) {
            LocaleTextImpl d;
            String nsuri = runtimeOption.qname().namespaceURI();
            if (nsuri.length() == 0) {
                nsuri = this.pad.getDefaultNamespace();
            }
            QName qn = new QName(nsuri, runtimeOption.qname().localPart());
            EventDefinitionImpl evt = new EventDefinitionImpl(qn);
            for (LocaleString ls : runtimeOption.description()) {
                d = new DescriptionImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                evt.addDescription((Description)((Object)d));
            }
            for (LocaleString ls : runtimeOption.displayName()) {
                d = new DisplayNameImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                evt.addDisplayName((DisplayName)((Object)d));
            }
            if (!runtimeOption.payloadType().equals(Void.TYPE)) {
                evt.setValueType(runtimeOption.payloadType().getCanonicalName());
            }
            this.pad.addEventDefinition(evt);
        }
        for (RuntimeOption runtimeOption : app.customPortletModes()) {
            CustomPortletModeImpl mode = new CustomPortletModeImpl(runtimeOption.name());
            for (LocaleString ls : runtimeOption.description()) {
                DescriptionImpl d = new DescriptionImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                mode.addDescription(d);
            }
            mode.setPortalManaged(runtimeOption.portalManaged());
            this.pad.addCustomPortletMode(mode);
        }
        for (RuntimeOption runtimeOption : app.customWindowStates()) {
            CustomWindowStateImpl ws = new CustomWindowStateImpl(runtimeOption.name());
            for (LocaleString ls : runtimeOption.description()) {
                DescriptionImpl d = new DescriptionImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                ws.addDescription(d);
            }
            this.pad.addCustomWindowState(ws);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processPortletFilterAnnotation(Class<?> cls) {
        PortletLifecycleFilter prf = cls.getAnnotation(PortletLifecycleFilter.class);
        if (prf != null) {
            void var10_20;
            LocaleTextImpl d;
            ArrayList<String> lc = new ArrayList<String>();
            if (ActionFilter.class.isAssignableFrom(cls)) {
                lc.add("ACTION_PHASE");
            }
            if (RenderFilter.class.isAssignableFrom(cls)) {
                lc.add("RENDER_PHASE");
            }
            if (ResourceFilter.class.isAssignableFrom(cls)) {
                lc.add("RESOURCE_PHASE");
            }
            if (EventFilter.class.isAssignableFrom(cls)) {
                lc.add("EVENT_PHASE");
            }
            if (HeaderFilter.class.isAssignableFrom(cls)) {
                lc.add("HEADER_PHASE");
            }
            if (lc.size() == 0) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("@PortletLifecycleFilter annotated class must implement ActionFilter, RenderFilter, EventFilter, ResourceFilter, or HeaderFilter. ");
                txt.append(", class: ").append(cls.getCanonicalName());
                LOG.warn(txt.toString());
                throw new IllegalArgumentException(txt.toString());
            }
            String clsName = cls.getCanonicalName();
            String fn = prf.filterName();
            if (fn.length() == 0) {
                fn = this.genUniqueName();
            }
            if (isTrace) {
                LOG.trace("Adding filter named: " + fn);
            }
            if (this.pad.getFilter(fn) != null) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Duplicate filter annotation. FilterName: ").append(fn);
                txt.append(", class 1: ").append(cls.getCanonicalName());
                txt.append(", class 2: ").append(this.pad.getFilter(fn).getFilterClass());
                LOG.warn(txt.toString());
                throw new IllegalArgumentException(txt.toString());
            }
            FilterImpl filter = new FilterImpl(fn);
            filter.setFilterClass(clsName);
            for (String l : lc) {
                filter.addLifecycle(l);
            }
            filter.setOrdinal(prf.ordinal());
            for (LocaleString localeString : prf.description()) {
                d = new DescriptionImpl(Locale.forLanguageTag(localeString.locale()), localeString.value());
                filter.addDescription((Description)((Object)d));
            }
            for (LocaleString localeString : prf.displayName()) {
                d = new DisplayNameImpl(Locale.forLanguageTag(localeString.locale()), localeString.value());
                filter.addDisplayName((DisplayName)((Object)d));
            }
            for (LocaleString localeString : prf.initParams()) {
                InitParamImpl plutoInitParam = new InitParamImpl(localeString.name(), localeString.value());
                for (LocaleString ls : localeString.description()) {
                    DescriptionImpl d2 = new DescriptionImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                    plutoInitParam.addDescription(d2);
                }
                filter.addInitParam(plutoInitParam);
            }
            this.pad.addFilter(filter);
            FilterMappingImpl mapping = new FilterMappingImpl(fn);
            String[] stringArray = prf.portletNames();
            int n = stringArray.length;
            boolean bl = false;
            while (var10_20 < n) {
                String portletName = stringArray[var10_20];
                mapping.addPortletName(portletName);
                ++var10_20;
            }
            this.pad.addFilterMapping(mapping);
        }
    }

    @Override
    public void processListenerAnnotation(Class<?> cls) {
        PortletListener listener = cls.getAnnotation(PortletListener.class);
        if (listener != null) {
            LocaleTextImpl d;
            if (!PortletURLGenerationListener.class.isAssignableFrom(cls)) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("@PortletListener annotated class must implement PortletURLGenerationListener interface. ");
                txt.append(", class: ").append(cls.getCanonicalName());
                LOG.warn(txt.toString());
                throw new IllegalArgumentException(txt.toString());
            }
            String clsName = cls.getCanonicalName();
            String name = listener.listenerName();
            if (name.length() == 0) {
                name = this.genUniqueName();
            }
            if (this.pad.getListener(name) != null) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Duplicate listener annotation. Listener name: ").append(name);
                txt.append(", class 1: ").append(clsName);
                txt.append(", class 2: ").append(this.pad.getListener(name).getListenerClass());
                LOG.warn(txt.toString());
                throw new IllegalArgumentException(txt.toString());
            }
            ListenerImpl newItem = new ListenerImpl(clsName);
            newItem.setListenerName(name);
            newItem.setOrdinal(listener.ordinal());
            for (LocaleString ls : listener.description()) {
                d = new DescriptionImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                newItem.addDescription((Description)((Object)d));
            }
            for (LocaleString ls : listener.displayName()) {
                d = new DisplayNameImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                newItem.addDisplayName((DisplayName)((Object)d));
            }
            this.pad.addListener(newItem);
        }
    }

    @Override
    public void processValidatorAnnotation(Class<?> cls) {
        PortletPreferencesValidator vali = cls.getAnnotation(PortletPreferencesValidator.class);
        if (vali != null) {
            if (!PreferencesValidator.class.isAssignableFrom(cls)) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("@PortletPreferencesValidator annotated class must implement PreferencesValidator interface. ");
                txt.append(", class: ").append(cls.getCanonicalName());
                LOG.warn(txt.toString());
                throw new IllegalArgumentException(txt.toString());
            }
            String clsName = cls.getCanonicalName();
            this.prefValidators.put(vali, clsName);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processPortletConfigAnnotation(PortletConfiguration pc, Class<?> cls) {
        if (pc != null) {
            void var10_58;
            void var10_56;
            void var10_54;
            void var10_52;
            int n;
            void var7_13;
            void var7_11;
            LocaleTextImpl d;
            void var7_9;
            String portletName = pc.portletName();
            if (this.pad.getPortlet(portletName) != null) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Duplicate portlet configuration annotation. Portlet name: ").append(portletName);
                txt.append(", class: ").append(cls.getCanonicalName());
                LOG.warn(txt.toString());
                throw new IllegalArgumentException(txt.toString());
            }
            PortletDefinitionImpl pd = new PortletDefinitionImpl(portletName, this.pad);
            if (Portlet.class.isAssignableFrom(cls)) {
                pd.setPortletClass(cls.getCanonicalName());
            }
            LocaleString[] localeStringArray = pc.description();
            int n2 = localeStringArray.length;
            boolean bl = false;
            while (var7_9 < n2) {
                LocaleString localeString = localeStringArray[var7_9];
                d = new DescriptionImpl(Locale.forLanguageTag(localeString.locale()), localeString.value());
                pd.addDescription((Description)((Object)d));
                ++var7_9;
            }
            localeStringArray = pc.displayName();
            n2 = localeStringArray.length;
            boolean bl2 = false;
            while (var7_11 < n2) {
                LocaleString localeString = localeStringArray[var7_11];
                d = new DisplayNameImpl(Locale.forLanguageTag(localeString.locale()), localeString.value());
                pd.addDisplayName((DisplayName)((Object)d));
                ++var7_11;
            }
            localeStringArray = pc.initParams();
            n2 = localeStringArray.length;
            boolean bl3 = false;
            while (var7_13 < n2) {
                LocaleString localeString = localeStringArray[var7_13];
                InitParamImpl plutoInitParam = new InitParamImpl(localeString.name(), localeString.value());
                for (LocaleString ls : localeString.description()) {
                    DescriptionImpl d2 = new DescriptionImpl(Locale.forLanguageTag(ls.locale()), ls.value());
                    plutoInitParam.addDescription(d2);
                }
                pd.addInitParam(plutoInitParam);
                ++var7_13;
            }
            pd.setCacheScope(pc.cacheScopePublic() ? "public" : "private");
            pd.setExpirationCache(pc.cacheExpirationTime());
            pd.setResourceBundle(pc.resourceBundle());
            pd.setAsyncSupported(pc.asyncSupported());
            if (pc.multipart().supported()) {
                Multipart mp = pc.multipart();
                pd.setMultipartSupported(true);
                pd.setLocation(mp.location());
                pd.setFileSizeThreshold(mp.fileSizeThreshold());
                pd.setMaxFileSize(mp.maxFileSize());
                pd.setMaxRequestSize(mp.maxRequestSize());
            }
            PortletInfoImpl info = new PortletInfoImpl();
            boolean infoAdded = false;
            LocaleString[] localeStringArray2 = pc.title();
            int n3 = localeStringArray2.length;
            for (n = 0; n < n3; ++n) {
                LocaleString localeString = localeStringArray2[n];
                Locale locale = localeString.locale().length() == 0 ? Locale.ENGLISH : Locale.forLanguageTag(localeString.locale());
                info.addTitle(new LocaleTextImpl(locale, localeString.value()));
                infoAdded = true;
            }
            LocaleString[] localeStringArray3 = pc.shortTitle();
            int n4 = localeStringArray3.length;
            for (n = 0; n < n4; ++n) {
                LocaleString localeString = localeStringArray3[n];
                Locale locale = localeString.locale().length() == 0 ? Locale.ENGLISH : Locale.forLanguageTag(localeString.locale());
                info.addShortTitle(new LocaleTextImpl(locale, localeString.value()));
                infoAdded = true;
            }
            LocaleString[] localeStringArray4 = pc.keywords();
            int n5 = localeStringArray4.length;
            for (n = 0; n < n5; ++n) {
                LocaleString localeString = localeStringArray4[n];
                Locale locale = localeString.locale().length() == 0 ? Locale.ENGLISH : Locale.forLanguageTag(localeString.locale());
                info.addKeywords(new LocaleTextImpl(locale, localeString.value()));
                infoAdded = true;
            }
            if (infoAdded) {
                pd.setPortletInfo(info);
            }
            String[] stringArray = pc.publicParams();
            int n6 = stringArray.length;
            for (n = 0; n < n6; ++n) {
                String string = stringArray[n];
                pd.addSupportedPublicRenderParameter(string);
            }
            String[] stringArray2 = pc.supportedLocales();
            int n7 = stringArray2.length;
            for (n = 0; n < n7; ++n) {
                String string = stringArray2[n];
                pd.addSupportedLocale(string);
            }
            for (RuntimeOption runtimeOption : pc.runtimeOptions()) {
                ContainerRuntimeOptionImpl containerRuntimeOptionImpl = new ContainerRuntimeOptionImpl(runtimeOption.name(), Arrays.asList(runtimeOption.values()));
                pd.addContainerRuntimeOption(containerRuntimeOptionImpl);
            }
            PreferencesImpl preferencesImpl = new PreferencesImpl();
            javax.portlet.annotations.Preference[] preferenceArray = pc.prefs();
            n = preferenceArray.length;
            boolean bl4 = false;
            while (var10_52 < n) {
                javax.portlet.annotations.Preference preference = preferenceArray[var10_52];
                PreferenceImpl pref = new PreferenceImpl(preference.name(), preference.isReadOnly(), Arrays.asList(preference.values()));
                preferencesImpl.addPreference(pref);
                ++var10_52;
            }
            if (preferencesImpl.getPortletPreferences().size() > 0) {
                pd.setPortletPreferences(preferencesImpl);
            }
            javax.portlet.annotations.Supports[] supportsArray = pc.supports();
            n = supportsArray.length;
            boolean bl5 = false;
            while (var10_54 < n) {
                javax.portlet.annotations.Supports supports = supportsArray[var10_54];
                SupportsImpl supps = new SupportsImpl(supports.mimeType());
                for (String string : supports.portletModes()) {
                    supps.addPortletMode(string);
                }
                for (String string : supports.windowStates()) {
                    supps.addWindowState(string);
                }
                pd.addSupports(supps);
                ++var10_54;
            }
            javax.portlet.annotations.SecurityRoleRef[] securityRoleRefArray = pc.roleRefs();
            n = securityRoleRefArray.length;
            boolean bl6 = false;
            while (var10_56 < n) {
                javax.portlet.annotations.SecurityRoleRef securityRoleRef = securityRoleRefArray[var10_56];
                SecurityRoleRefImpl ref = new SecurityRoleRefImpl(securityRoleRef.roleName());
                ref.setRoleLink(securityRoleRef.roleLink());
                for (String string : securityRoleRef.description()) {
                    DescriptionImpl d3 = new DescriptionImpl(Locale.forLanguageTag(string.locale()), string.value());
                    ref.addDescription(d3);
                }
                pd.addSecurityRoleRef(ref);
                ++var10_56;
            }
            Dependency[] dependencyArray = pc.dependencies();
            n = dependencyArray.length;
            boolean bl7 = false;
            while (var10_58 < n) {
                Dependency dependency = dependencyArray[var10_58];
                DependencyImpl dep = new DependencyImpl(dependency.name(), dependency.scope(), dependency.version());
                pd.addDependency(dep);
                ++var10_58;
            }
            this.pad.addPortlet(pd);
        }
    }
}

