/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.mvc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.mvc.RedirectScoped;
import javax.mvc.binding.BindingError;
import javax.mvc.binding.ParamError;
import javax.mvc.binding.ValidationError;
import org.apache.pluto.container.bean.mvc.MutableBindingResult;

@RedirectScoped
public class BindingResultImpl
implements MutableBindingResult,
Serializable {
    private static final long serialVersionUID = 2217732469752342741L;
    private Set<BindingError> bindingErrors = new LinkedHashSet<BindingError>();
    private boolean consulted = false;
    private Set<ValidationError> validationErrors = new LinkedHashSet<ValidationError>();

    @Override
    public void addBindingError(BindingError bindingError) {
        this.bindingErrors.add(bindingError);
    }

    @Override
    public void addValidationError(ValidationError validationError) {
        this.validationErrors.add(validationError);
    }

    public void clear() {
        this.bindingErrors.clear();
        this.validationErrors.clear();
        this.consulted = false;
    }

    public Set<ParamError> getAllErrors() {
        this.consulted = true;
        LinkedHashSet<ParamError> allErrors = new LinkedHashSet<ParamError>();
        allErrors.addAll(this.bindingErrors);
        allErrors.addAll(this.validationErrors);
        return allErrors;
    }

    public List<String> getAllMessages() {
        this.consulted = true;
        ArrayList<String> allMessages = new ArrayList<String>();
        for (BindingError bindingError : this.bindingErrors) {
            allMessages.add(bindingError.getMessage());
        }
        for (ValidationError validationError : this.validationErrors) {
            allMessages.add(validationError.getMessage());
        }
        return allMessages;
    }

    public Set<ParamError> getErrors(String paramName) {
        this.consulted = true;
        LinkedHashSet<ParamError> errors = new LinkedHashSet<ParamError>();
        for (BindingError bindingError : this.bindingErrors) {
            if (!Objects.equals(bindingError.getParamName(), paramName)) continue;
            errors.add((ParamError)bindingError);
        }
        for (ValidationError validationError : this.validationErrors) {
            if (!Objects.equals(validationError.getParamName(), paramName)) continue;
            errors.add((ParamError)validationError);
        }
        return errors;
    }

    @Override
    public boolean isConsulted() {
        return this.consulted;
    }

    public boolean isFailed() {
        this.consulted = true;
        return !this.bindingErrors.isEmpty() || !this.validationErrors.isEmpty();
    }
}

