/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.UserDataConstraint;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;

public class UserDataConstraintImpl
implements UserDataConstraint {
    private String transportGuarantee;
    private final List<Description> descs = new ArrayList<Description>();

    public UserDataConstraintImpl(UserDataConstraint udc) {
        this.transportGuarantee = udc.getTransportGuarantee();
        for (Description desc : udc.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
    }

    public UserDataConstraintImpl(String udc) {
        this.transportGuarantee = udc;
    }

    @Override
    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    @Override
    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    @Override
    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    @Override
    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.transportGuarantee == null ? 0 : this.transportGuarantee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserDataConstraintImpl other = (UserDataConstraintImpl)obj;
        return !(this.transportGuarantee == null ? other.transportGuarantee != null : !this.transportGuarantee.equals(other.transportGuarantee));
    }
}

