/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.PublicRenderParameter;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;

public class PublicRenderParameterImpl
implements PublicRenderParameter {
    private QName qname;
    private String id;
    private final List<QName> aliases = new ArrayList<QName>();
    private final List<Description> descs = new ArrayList<Description>();
    private final List<DisplayName> dispNames = new ArrayList<DisplayName>();

    public PublicRenderParameterImpl(PublicRenderParameter pri) {
        QName priqn = pri.getQName();
        this.qname = new QName(priqn.getNamespaceURI(), priqn.getLocalPart());
        this.id = pri.getIdentifier();
        for (QName qn : pri.getAliases()) {
            this.aliases.add(new QName(qn.getNamespaceURI(), qn.getLocalPart()));
        }
        for (Description desc : pri.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
        for (DisplayName dn : pri.getDisplayNames()) {
            this.dispNames.add(new DisplayNameImpl(dn));
        }
    }

    public PublicRenderParameterImpl(QName qn, String id) {
        this.qname = qn;
        this.id = id;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public Description getDescription(Locale locale) {
        Description ret = null;
        for (Description desc : this.descs) {
            if (!desc.getLocale().equals(locale)) continue;
            ret = desc;
        }
        return ret;
    }

    @Override
    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    @Override
    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    @Override
    public DisplayName getDisplayName(Locale locale) {
        DisplayName ret = null;
        for (DisplayName dn : this.dispNames) {
            if (!dn.getLocale().equals(locale)) continue;
            ret = dn;
        }
        return ret;
    }

    @Override
    public List<DisplayName> getDisplayNames() {
        return new ArrayList<DisplayName>(this.dispNames);
    }

    @Override
    public void addDisplayName(DisplayName dn) {
        this.dispNames.add(dn);
    }

    @Override
    public List<QName> getAliases() {
        return new ArrayList<QName>(this.aliases);
    }

    @Override
    public void addAlias(QName qName) {
        this.aliases.add(qName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicRenderParameterImpl other = (PublicRenderParameterImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

