/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletSessionScopedBeanMap
implements HttpSessionBindingListener,
Serializable {
    private static final long serialVersionUID = -4770245090803443972L;
    private static final Logger LOG = LoggerFactory.getLogger(PortletSessionScopedBeanMap.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final String WINDOW_ID_APPLICATION = "application";
    private final Map<String, Map<Contextual<?>, BeanInstance<?>>> beans = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putBeanInstance(String id, Contextual<T> bean, CreationalContext<T> crco, T instance) {
        BeanInstance bi = new BeanInstance();
        bi.crco = crco;
        bi.instance = instance;
        if (id == null) {
            id = WINDOW_ID_APPLICATION;
        }
        boolean addedMap = false;
        Map<String, Map<Contextual<?>, BeanInstance<?>>> map = this.beans;
        synchronized (map) {
            Map<Contextual<?>, BeanInstance<?>> beanMap = this.beans.get(id);
            if (beanMap == null) {
                beanMap = new HashMap();
                this.beans.put(id, beanMap);
                addedMap = true;
            }
            beanMap.put(bean, bi);
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Added bean: ");
            if (bean instanceof Bean) {
                Bean b = (Bean)bean;
                txt.append(b.getBeanClass().getSimpleName());
            } else {
                txt.append("Contextual");
            }
            txt.append(", window ID: ").append(id);
            txt.append(", added new map: ").append(addedMap);
            LOG.debug(txt.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getBeanInstance(String id, Contextual<T> bean) {
        T instance = null;
        if (id == null) {
            id = WINDOW_ID_APPLICATION;
        }
        boolean gotMap = false;
        Map<String, Map<Contextual<?>, BeanInstance<?>>> map = this.beans;
        synchronized (map) {
            Map<Contextual<?>, BeanInstance<?>> beanMap = this.beans.get(id);
            if (beanMap != null) {
                gotMap = true;
                BeanInstance<?> bi = beanMap.get(bean);
                if (bi != null) {
                    instance = bi.instance;
                }
            }
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(id);
            txt.append(", retrieved map: ").append(gotMap);
            txt.append(", instance null: ").append(instance == null);
            LOG.debug(txt.toString());
        }
        return instance;
    }

    private <T> void remove(String id, Map<Contextual<?>, BeanInstance<?>> beanMap, Contextual<T> bean) {
        BeanInstance<?> bi = beanMap.get(bean);
        if (isDebug) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Removing bean: ");
            if (bean instanceof Bean) {
                Bean b = (Bean)bean;
                txt.append(b.getBeanClass().getSimpleName());
            }
            txt.append(", window ID: ").append(id);
            if (bi == null) {
                txt.append(", instance is null.");
            }
            LOG.debug(txt.toString());
        }
        if (bi != null) {
            this.beans.remove(id);
            bi.crco.release();
            bean.destroy(bi.instance, bi.crco);
        }
    }

    public void valueBound(HttpSessionBindingEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent evt) {
        if (isTrace) {
            LOG.trace("PortletSessionBeanHolder unbound from session. ID=" + evt.getName());
        }
        Map<String, Map<Contextual<?>, BeanInstance<?>>> map = this.beans;
        synchronized (map) {
            for (String id : this.beans.keySet()) {
                Map<Contextual<?>, BeanInstance<?>> beanMap = this.beans.get(id);
                for (Contextual<?> bean : beanMap.keySet()) {
                    this.remove(id, beanMap, bean);
                }
            }
            this.beans.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByWindowId(String windowId) {
        if (isTrace) {
            LOG.trace("Removing beans associated with windowId=" + windowId);
        }
        Map<String, Map<Contextual<?>, BeanInstance<?>>> map = this.beans;
        synchronized (map) {
            for (String curWindowId : this.beans.keySet()) {
                if (!curWindowId.equals(windowId)) continue;
                Map<Contextual<?>, BeanInstance<?>> beanMap = this.beans.get(curWindowId);
                for (Contextual<?> bean : beanMap.keySet()) {
                    this.remove(curWindowId, beanMap, bean);
                }
            }
        }
    }

    private class BeanInstance<T>
    implements Serializable {
        private static final long serialVersionUID = -2094530892049932082L;
        CreationalContext<T> crco;
        T instance;

        private BeanInstance() {
        }
    }
}

