/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.portlet.MutablePortletParameters;
import javax.portlet.PortletParameters;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.PortletParametersImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutablePortletParametersImpl
extends PortletParametersImpl
implements MutablePortletParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutablePortletParametersImpl.class);
    private static final boolean isTrace = LOGGER.isTraceEnabled();

    protected MutablePortletParametersImpl(PortletURLProvider urlProvider, String windowId, PortletURLProvider.ParamType type) {
        super(urlProvider, windowId, type);
    }

    protected MutablePortletParametersImpl(Map<String, String[]> params, String windowId, PortletURLProvider.ParamType type) {
        super(params, windowId, type);
    }

    public String setValue(String name, String value) {
        this.checkNull("name", name);
        String[] vals = (String[])this.params.get(name);
        String val = vals == null ? null : vals[0];
        this.params.put(name, new String[]{value});
        if (this.urlProvider != null) {
            this.urlProvider.setParameter(this.windowId, name, this.type, new String[]{value});
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", Name: ").append(name).append(", Type: ").append((Object)this.type).append(", Old Value: ").append(val).append(", New Value: ").append(value);
            LOGGER.debug(txt.toString());
        }
        return val;
    }

    public String[] setValues(String name, String ... values) {
        this.checkNull("name", name);
        Object[] vals = (String[])this.params.get(name);
        if (values == null) {
            values = new String[]{null};
        }
        this.params.put(name, values.clone());
        if (this.urlProvider != null) {
            this.urlProvider.setParameter(this.windowId, name, this.type, (String[])values.clone());
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", Name: ").append(name).append(", Type: ").append((Object)this.type).append(", Old Values: ").append(Arrays.toString(vals)).append(", New Values: ").append(Arrays.toString(values));
            LOGGER.debug(txt.toString());
        }
        return vals;
    }

    public boolean removeParameter(String name) {
        this.checkNull("name", name);
        boolean isContains = this.params.containsKey(name);
        if (isContains) {
            this.params.remove(name);
            if (this.urlProvider != null) {
                this.urlProvider.removeParameter(this.windowId, name, this.type);
            }
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", Name: ").append(name).append(", Type: ").append((Object)this.type).append(", Removed: ").append(isContains);
            LOGGER.debug(txt.toString());
        }
        return isContains;
    }

    public MutablePortletParameters set(PortletParameters inParams) {
        this.checkNull("params", inParams);
        MutablePortletParameters oldparms = this.clone();
        int ctr = 0;
        HashSet remNames = new HashSet(this.params.keySet());
        boolean removed = this.params.keySet().retainAll(inParams.getNames());
        if (removed && this.urlProvider != null) {
            remNames.removeAll(inParams.getNames());
            for (String name : remNames) {
                this.urlProvider.removeParameter(this.windowId, name, this.type);
            }
        }
        for (String name : inParams.getNames()) {
            String[] vals = (String[])inParams.getValues(name).clone();
            ++ctr;
            this.params.put(name, vals);
            if (this.urlProvider == null) continue;
            this.urlProvider.setParameter(this.windowId, name, this.type, vals);
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", Removed values from old map:  ").append(removed).append(", set ").append(ctr).append(" values.");
            LOGGER.debug(txt.toString());
        }
        return oldparms;
    }

    public MutablePortletParameters add(PortletParameters inParams) {
        this.checkNull("params", inParams);
        MutablePortletParameters oldparms = this.clone();
        int ctr = 0;
        for (String name : inParams.getNames()) {
            String[] vals = (String[])inParams.getValues(name).clone();
            ++ctr;
            this.params.put(name, vals);
            if (this.urlProvider == null) continue;
            this.urlProvider.setParameter(this.windowId, name, this.type, vals);
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", added ").append(ctr).append(" values.");
            LOGGER.debug(txt.toString());
        }
        return oldparms;
    }

    public void clear() {
        int ctr = this.params.size();
        if (this.urlProvider != null) {
            for (String name : this.params.keySet()) {
                this.urlProvider.removeParameter(this.windowId, name, this.type);
            }
        }
        this.params.clear();
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", removed ").append(ctr).append(" values.");
            LOGGER.debug(txt.toString());
        }
    }
}

