/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import javax.portlet.HeaderResponse;
import javax.portlet.PortletMode;
import org.apache.pluto.container.PortletHeaderResponseContext;
import org.apache.pluto.container.impl.MimeResponseImpl;
import org.apache.pluto.container.util.ArgumentUtility;

public class HeaderResponseImpl
extends MimeResponseImpl
implements HeaderResponse {
    public HeaderResponseImpl(PortletHeaderResponseContext responseContext) {
        super(responseContext);
    }

    protected boolean isValidContentType(String contentType) {
        String[] parts = contentType.split("/");
        if (parts.length != 2) {
            return false;
        }
        for (String supportedType : this.getResponseContentTypes()) {
            if (supportedType.matches("(?:\\*|\\*/\\*)") || supportedType.equals(contentType)) {
                return true;
            }
            String[] sp = supportedType.split("/");
            assert (sp.length == 2);
            if (!sp[0].equals("*") && !sp[0].equals(parts[0]) || !sp[1].equals("*") && !sp[1].equals(parts[1])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setContentType(String contentType) {
        ArgumentUtility.validateNotNull("contentType", contentType);
        contentType = contentType.replaceAll("([^;]*).*", "$1").replaceAll(" ", "");
        if (!this.isValidContentType(contentType)) {
            throw new IllegalArgumentException("Specified content type '" + contentType + "' is not supported.");
        }
        super.setContentType(contentType);
    }

    public void setNextPossiblePortletModes(Collection<? extends PortletMode> portletModes) {
        ArgumentUtility.validateNotNull("portletModes", portletModes);
        if (portletModes.isEmpty()) {
            throw new IllegalArgumentException("At least one possible PortletMode should be specified.");
        }
        ArrayList<PortletMode> modes = new ArrayList<PortletMode>();
        for (PortletMode portletMode : portletModes) {
            if (!this.isPortletModeAllowed(portletMode)) continue;
            modes.add(portletMode);
        }
        if (modes.isEmpty()) {
            modes.add(this.getPortletWindow().getPortletMode());
        }
        ((PortletHeaderResponseContext)this.responseContext).setNextPossiblePortletModes(modes);
    }

    public void setTitle(String title) {
        ((PortletHeaderResponseContext)this.responseContext).setTitle(title);
    }

    public void addDependency(String name, String scope, String version) {
        ((PortletHeaderResponseContext)this.responseContext).addDependency(name, scope, version);
    }

    public void addDependency(String name, String scope, String version, String markup) {
        ((PortletHeaderResponseContext)this.responseContext).addDependency(name, scope, version, markup);
    }
}

