/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet.sso;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOProvider;
import org.apache.portals.bridges.common.ScriptPostProcess;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;

public class SSOProxyPortlet
extends GenericVelocityPortlet {
    private PortletContext context;
    private SSOProvider sso;
    private boolean isAuthenticated = false;
    public String defaultEncoding = "UTF-8";
    static final int BLOCK_SIZE = 4096;
    static final String ACTION_PARAMETER_SSOPROXY = "SSOProxy";
    static final String DESTINATION_URL = "DestinationURL";
    static final String SSO_SITE = "SSOSite";
    static final String FORCE_SSO_REFRESH = "ForceSSORefresh";
    static final String ENCODING = "Encoding";
    private String destinationURL;
    private String ssoSite;
    private String encoding;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.sso = (SSOProvider)this.context.getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find SSO Provider on portlet initialization");
        }
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        String ssoProxyAction = request.getParameter(ACTION_PARAMETER_SSOPROXY);
        this.destinationURL = ssoProxyAction != null && ssoProxyAction.length() > 0 ? ssoProxyAction : request.getParameter(DESTINATION_URL);
        this.ssoSite = request.getParameter(SSO_SITE);
        this.encoding = request.getParameter(ENCODING);
        if (this.encoding == null) {
            this.encoding = this.defaultEncoding;
        }
        super.processAction(request, actionResponse);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String forceRefresh = request.getPreferences().getValue(FORCE_SSO_REFRESH, "false");
        if (this.destinationURL == null || this.destinationURL.length() == 0) {
            request.setAttribute("ViewPage", (Object)this.getPortletConfig().getInitParameter("EditPage"));
            this.setupPreferencesEdit(request, response);
            super.doView(request, response);
            return;
        }
        response.setContentType("text/html");
        boolean doRefresh = false;
        if (forceRefresh.compareToIgnoreCase("TRUE") == 0 || !this.isAuthenticated) {
            doRefresh = true;
        }
        try {
            StringBuffer page = new StringBuffer();
            Subject subject = this.getSubject();
            if (this.ssoSite == null || this.ssoSite.length() == 0) {
                page.append(this.sso.useSSO(subject, this.destinationURL, doRefresh));
            } else {
                page.append(this.sso.useSSO(subject, this.destinationURL, this.ssoSite, doRefresh));
            }
            this.isAuthenticated = true;
            PortletURL actionURL = response.createActionURL();
            ScriptPostProcess processor = new ScriptPostProcess();
            processor.setInitalPage(page);
            processor.postProcessPage(actionURL, ACTION_PARAMETER_SSOPROXY);
            String finalPage = processor.getFinalizedPage();
            response.getWriter().println(finalPage);
        }
        catch (SSOException e) {
            response.getWriter().println("<P>Error rendering page. Error message<BR>" + e.getMessage() + "</P>");
            this.destinationURL = "";
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doEdit(request, response);
    }

    private Subject getSubject() {
        AccessControlContext context = AccessController.getContext();
        return JSSubject.getSubject((AccessControlContext)context);
    }
}

