/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.portlet.IFrameGenericPortlet;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.sso.SSOContext;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOProvider;

public class SSOIFramePortlet
extends IFrameGenericPortlet {
    public static final String SSO_TYPE = "sso.type";
    public static final String SSO_TYPE_URL = "url";
    public static final String SSO_TYPE_URL_BASE64 = "url.base64";
    public static final String SSO_TYPE_HTTP = "http";
    public static final String SSO_TYPE_CERTIFICATE = "certificate";
    public static final String SSO_TYPE_URL_USERNAME = "sso.url.Principal";
    public static final String SSO_TYPE_URL_PASSWORD = "sso.url.Credential";
    public static final String SSO_REQUEST_ATTRIBUTE_USERNAME = "sso.ra.username";
    public static final String SSO_REQUEST_ATTRIBUTE_PASSWORD = "sso.ra.password";
    public static final String SSO_FORM_PRINCIPAL = "ssoPrincipal";
    public static final String SSO_FORM_CREDENTIAL = "ssoCredential";
    private PortletContext context;
    private SSOProvider sso;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.context = this.getPortletContext();
        this.sso = (SSOProvider)this.context.getAttribute("cps:SSO");
        if (null == this.sso) {
            throw new PortletException("Failed to find SSO Provider on portlet initialization");
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            Subject subject = this.getSubject();
            String site = request.getPreferences().getValue("SRC", "");
            SSOContext context = this.sso.getCredentials(subject, site);
            this.getContext(request).put(SSO_FORM_PRINCIPAL, (Object)context.getRemotePrincipalName());
            this.getContext(request).put(SSO_FORM_CREDENTIAL, (Object)context.getRemoteCredential());
        }
        catch (SSOException e) {
            if (e.getMessage().equals("The site has no Single Sign On credentails attached.")) {
                this.getContext(request).put(SSO_FORM_PRINCIPAL, (Object)"");
                this.getContext(request).put(SSO_FORM_CREDENTIAL, (Object)"");
            }
            throw new PortletException((Throwable)e);
        }
        super.doEdit(request, response);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String site = request.getPreferences().getValue("SRC", null);
        if (site == null) {
            request.setAttribute("ViewPage", (Object)this.getPortletConfig().getInitParameter("EditPage"));
            this.setupPreferencesEdit(request, response);
            super.doView(request, response);
            return;
        }
        try {
            Subject subject = this.getSubject();
            SSOContext context = this.sso.getCredentials(subject, site);
            request.setAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME, (Object)context.getRemotePrincipalName());
            request.setAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD, (Object)context.getRemoteCredential());
        }
        catch (SSOException e) {
            if (e.getMessage().equals("The site has no Single Sign On credentails attached.")) {
                request.setAttribute("ViewPage", (Object)this.getPortletConfig().getInitParameter("EditPage"));
                this.setupPreferencesEdit(request, response);
            }
            throw new PortletException((Throwable)e);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        super.processAction(request, actionResponse);
        String ssoPrincipal = request.getParameter(SSO_FORM_PRINCIPAL);
        String ssoCredential = request.getParameter(SSO_FORM_CREDENTIAL);
        String site = request.getPreferences().getValue("SRC", "");
        try {
            Subject subject = this.getSubject();
            if (this.sso.hasSSOCredentials(subject, site)) {
                SSOContext context = this.sso.getCredentials(subject, site);
                if (!context.getRemotePrincipalName().equals(ssoPrincipal)) {
                    this.sso.removeCredentialsForSite(subject, site);
                    this.sso.addCredentialsForSite(subject, ssoPrincipal, site, ssoCredential);
                } else {
                    this.sso.updateCredentialsForSite(subject, ssoPrincipal, site, ssoCredential);
                }
            } else {
                this.sso.addCredentialsForSite(subject, ssoPrincipal, site, ssoCredential);
            }
        }
        catch (SSOException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public String getURLSource(RenderRequest request, RenderResponse response, PortletPreferences prefs) {
        String baseSource = super.getURLSource(request, response, prefs);
        String type = prefs.getValue(SSO_TYPE, SSO_TYPE_URL);
        if (type.equals(SSO_TYPE_URL) || type.equals(SSO_TYPE_URL_BASE64)) {
            String password;
            String userNameParam = prefs.getValue(SSO_TYPE_URL_USERNAME, "user");
            String passwordParam = prefs.getValue(SSO_TYPE_URL_PASSWORD, "password");
            StringBuffer source = new StringBuffer(baseSource);
            if (baseSource.indexOf("?") == -1) {
                source.append("?");
            } else {
                source.append("&");
            }
            source.append(userNameParam);
            source.append("=");
            String userName = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_USERNAME);
            if (userName == null) {
                userName = "";
            }
            if ((password = (String)request.getAttribute(SSO_REQUEST_ATTRIBUTE_PASSWORD)) == null) {
                password = "";
            }
            if (type.equals(SSO_TYPE_URL_BASE64)) {
                Base64 encoder = new Base64();
                userName = new String(encoder.encode(userName.getBytes()));
                password = new String(encoder.encode(password.getBytes()));
            }
            source.append(userName);
            source.append("&");
            source.append(passwordParam);
            source.append("=");
            source.append(password);
            return response.encodeURL(source.toString());
        }
        return baseSource;
    }

    private Subject getSubject() {
        AccessControlContext context = AccessController.getContext();
        return JSSubject.getSubject((AccessControlContext)context);
    }
}

