/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.IOException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class IFramePortlet
extends GenericPortlet {
    public static final String ENABLE_SOURCE_PREFERENCES_PARAM = "enableSourcePreferences";
    public static final String ENABLE_PREFERENCES_PARAM = "enablePreferences";
    public static final String CUSTOM_SOURCE_PARAM = "customSource";
    public static final String MAXIMIZED_CUSTOM_SOURCE_PARAM = "maximizedCustomSource";
    public static final String EDIT_SOURCE_PARAM = "editSource";
    public static final String MAXIMIZED_EDIT_SOURCE_PARAM = "maximizedEditSource";
    public static final String HELP_SOURCE_PARAM = "helpSource";
    public static final String MAXIMIZED_HELP_SOURCE_PARAM = "maximizedHelpSource";
    public static final String VIEW_SOURCE_PARAM = "viewSource";
    public static final String MAXIMIZED_VIEW_SOURCE_PARAM = "maximizedViewSource";
    public static final String ALIGN_ATTR_PARAM = "align";
    public static final String CLASS_ATTR_PARAM = "class";
    public static final String FRAME_BORDER_ATTR_PARAM = "frameBorder";
    public static final String HEIGHT_ATTR_PARAM = "height";
    public static final String ID_ATTR_PARAM = "id";
    public static final String MARGIN_HEIGHT_ATTR_PARAM = "marginHeight";
    public static final String MARGIN_WIDTH_ATTR_PARAM = "marginWidth";
    public static final String MAXIMIZED_HEIGHT_ATTR_PARAM = "maximizedHeight";
    public static final String MAXIMIZED_SCROLLING_ATTR_PARAM = "maximizedScrolling";
    public static final String MAXIMIZED_STYLE_ATTR_PARAM = "maximizedStyle";
    public static final String MAXIMIZED_WIDTH_ATTR_PARAM = "maximizedWidth";
    public static final String NAME_ATTR_PARAM = "name";
    public static final String SCROLLING_ATTR_PARAM = "scrolling";
    public static final String STYLE_ATTR_PARAM = "style";
    public static final String WIDTH_ATTR_PARAM = "width";
    public static final String ALIGN_ATTR_DEFAULT = "BOTTOM";
    public static final String FRAME_BORDER_ATTR_DEFAULT = "0";
    public static final String HEIGHT_ATTR_DEFAULT = "";
    public static final String MARGIN_HEIGHT_ATTR_DEFAULT = "0";
    public static final String MARGIN_WIDTH_ATTR_DEFAULT = "0";
    public static final String MAXIMIZED_HEIGHT_ATTR_DEFAULT = "100%";
    public static final String MAXIMIZED_SCROLLING_ATTR_DEFAULT = "AUTO";
    public static final String MAXIMIZED_WIDTH_ATTR_DEFAULT = "100%";
    public static final String SCROLLING_ATTR_DEFAULT = "NO";
    public static final String WIDTH_ATTR_DEFAULT = "100%";
    private boolean enablePreferences;
    private String defaultCustomSource;
    private String defaultMaximizedCustomSource;
    private String defaultEditSource;
    private String defaultMaximizedEditSource;
    private String defaultHelpSource;
    private String defaultMaximizedHelpSource;
    private String defaultViewSource;
    private String defaultMaximizedViewSource;
    private String defaultAlignAttr;
    private String defaultClassAttr;
    private String defaultFrameBorderAttr;
    private String defaultHeightAttr;
    private String defaultIdAttr;
    private String defaultMarginHeightAttr;
    private String defaultMarginWidthAttr;
    private String defaultMaximizedHeightAttr;
    private String defaultMaximizedScrollingAttr;
    private String defaultMaximizedStyleAttr;
    private String defaultMaximizedWidthAttr;
    private String defaultNameAttr;
    private String defaultScrollingAttr;
    private String defaultStyleAttr;
    private String defaultWidthAttr;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        String initParam = config.getInitParameter(ENABLE_PREFERENCES_PARAM);
        if (initParam == null) {
            initParam = config.getInitParameter(ENABLE_SOURCE_PREFERENCES_PARAM);
        }
        if (initParam != null) {
            this.enablePreferences = new Boolean(initParam);
        }
        this.defaultCustomSource = config.getInitParameter(CUSTOM_SOURCE_PARAM);
        this.defaultMaximizedCustomSource = config.getInitParameter(MAXIMIZED_CUSTOM_SOURCE_PARAM);
        this.defaultEditSource = config.getInitParameter(EDIT_SOURCE_PARAM);
        this.defaultMaximizedEditSource = config.getInitParameter(MAXIMIZED_EDIT_SOURCE_PARAM);
        this.defaultHelpSource = config.getInitParameter(HELP_SOURCE_PARAM);
        this.defaultMaximizedHelpSource = config.getInitParameter(MAXIMIZED_HELP_SOURCE_PARAM);
        this.defaultViewSource = config.getInitParameter(VIEW_SOURCE_PARAM);
        this.defaultMaximizedViewSource = config.getInitParameter(MAXIMIZED_VIEW_SOURCE_PARAM);
        this.defaultAlignAttr = this.getAttributeParam(config, ALIGN_ATTR_PARAM, ALIGN_ATTR_DEFAULT);
        this.defaultClassAttr = this.getAttributeParam(config, CLASS_ATTR_PARAM, null);
        this.defaultFrameBorderAttr = this.getAttributeParam(config, FRAME_BORDER_ATTR_PARAM, "0");
        this.defaultHeightAttr = this.getAttributeParam(config, HEIGHT_ATTR_PARAM, HEIGHT_ATTR_DEFAULT);
        this.defaultIdAttr = this.getAttributeParam(config, ID_ATTR_PARAM, null);
        this.defaultMarginHeightAttr = this.getAttributeParam(config, MARGIN_HEIGHT_ATTR_PARAM, "0");
        this.defaultMarginWidthAttr = this.getAttributeParam(config, MARGIN_WIDTH_ATTR_PARAM, "0");
        this.defaultMaximizedHeightAttr = this.getAttributeParam(config, MAXIMIZED_HEIGHT_ATTR_PARAM, "100%");
        this.defaultMaximizedScrollingAttr = this.getAttributeParam(config, MAXIMIZED_SCROLLING_ATTR_PARAM, MAXIMIZED_SCROLLING_ATTR_DEFAULT);
        this.defaultMaximizedStyleAttr = this.getAttributeParam(config, MAXIMIZED_STYLE_ATTR_PARAM, null);
        this.defaultMaximizedWidthAttr = this.getAttributeParam(config, MAXIMIZED_WIDTH_ATTR_PARAM, "100%");
        this.defaultNameAttr = this.getAttributeParam(config, NAME_ATTR_PARAM, null);
        this.defaultScrollingAttr = this.getAttributeParam(config, SCROLLING_ATTR_PARAM, SCROLLING_ATTR_DEFAULT);
        this.defaultStyleAttr = this.getAttributeParam(config, STYLE_ATTR_PARAM, null);
        this.defaultWidthAttr = this.getAttributeParam(config, WIDTH_ATTR_PARAM, "100%");
    }

    public void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String source = null;
        if (request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            source = this.getPreferenceOrDefault(request, MAXIMIZED_CUSTOM_SOURCE_PARAM, this.defaultMaximizedCustomSource);
        }
        if (source == null) {
            source = this.getPreferenceOrDefault(request, CUSTOM_SOURCE_PARAM, this.defaultCustomSource);
        }
        if (source == null && request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            source = this.getPreferenceOrDefault(request, MAXIMIZED_VIEW_SOURCE_PARAM, this.defaultMaximizedViewSource);
        }
        if (source == null) {
            source = this.getPreferenceOrDefault(request, VIEW_SOURCE_PARAM, this.defaultViewSource);
        }
        if (source == null) {
            throw new PortletException("IFRAME source not specified for custom portlet mode.");
        }
        this.doIFrame(request, source, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String source = null;
        if (request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            source = this.getPreferenceOrDefault(request, MAXIMIZED_EDIT_SOURCE_PARAM, this.defaultMaximizedEditSource);
        }
        if (source == null) {
            source = this.getPreferenceOrDefault(request, EDIT_SOURCE_PARAM, this.defaultEditSource);
        }
        if (source == null && request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            source = this.getPreferenceOrDefault(request, MAXIMIZED_VIEW_SOURCE_PARAM, this.defaultMaximizedViewSource);
        }
        if (source == null) {
            source = this.getPreferenceOrDefault(request, VIEW_SOURCE_PARAM, this.defaultViewSource);
        }
        if (source == null) {
            throw new PortletException("IFRAME source not specified for edit portlet mode.");
        }
        this.doIFrame(request, source, response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String source = null;
        if (request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            source = this.getPreferenceOrDefault(request, MAXIMIZED_HELP_SOURCE_PARAM, this.defaultMaximizedHelpSource);
        }
        if (source == null) {
            source = this.getPreferenceOrDefault(request, HELP_SOURCE_PARAM, this.defaultHelpSource);
        }
        if (source == null && request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            source = this.getPreferenceOrDefault(request, MAXIMIZED_VIEW_SOURCE_PARAM, this.defaultMaximizedViewSource);
        }
        if (source == null) {
            source = this.getPreferenceOrDefault(request, VIEW_SOURCE_PARAM, this.defaultViewSource);
        }
        if (source == null) {
            throw new PortletException("IFRAME source not specified for help portlet mode.");
        }
        this.doIFrame(request, source, response);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String source = null;
        if (request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            source = this.getPreferenceOrDefault(request, MAXIMIZED_VIEW_SOURCE_PARAM, this.defaultMaximizedViewSource);
        }
        if (source == null) {
            source = this.getPreferenceOrDefault(request, VIEW_SOURCE_PARAM, this.defaultViewSource);
        }
        if (source == null) {
            throw new PortletException("IFRAME source not specified for view portlet mode.");
        }
        this.doIFrame(request, source, response);
    }

    protected void doIFrame(RenderRequest request, String sourceAttr, RenderResponse response) throws IOException {
        String nameAttr;
        String marginWidthAttr;
        String marginHeightAttr;
        String idAttr;
        String frameBorderAttr;
        String classAttr;
        StringBuffer content = new StringBuffer(4096);
        content.append("<TABLE CLASS='iframePortletTableContainer' WIDTH='100%'><TBODY CLASS='iframePortletTbodyContainer'><TR><TD>");
        content.append("<IFRAME");
        content.append(" SRC=\"").append(sourceAttr).append("\"");
        String alignAttr = this.getPreferenceOrDefault(request, ALIGN_ATTR_PARAM, this.defaultAlignAttr);
        if (alignAttr != null) {
            content.append(" ALIGN=\"").append(alignAttr).append("\"");
        }
        if ((classAttr = this.getPreferenceOrDefault(request, CLASS_ATTR_PARAM, this.defaultClassAttr)) != null) {
            content.append(" CLASS=\"").append(classAttr).append("\"");
        }
        if ((frameBorderAttr = this.getPreferenceOrDefault(request, FRAME_BORDER_ATTR_PARAM, this.defaultFrameBorderAttr)) != null) {
            content.append(" FRAMEBORDER=\"").append(frameBorderAttr).append("\"");
        }
        if ((idAttr = this.getPreferenceOrDefault(request, ID_ATTR_PARAM, this.defaultIdAttr)) != null) {
            content.append(" ID=\"").append(idAttr).append("\"");
        }
        if ((marginHeightAttr = this.getPreferenceOrDefault(request, MARGIN_HEIGHT_ATTR_PARAM, this.defaultMarginHeightAttr)) != null) {
            content.append(" MARGINHEIGHT=\"").append(marginHeightAttr).append("\"");
        }
        if ((marginWidthAttr = this.getPreferenceOrDefault(request, MARGIN_WIDTH_ATTR_PARAM, this.defaultMarginWidthAttr)) != null) {
            content.append(" MARGINWIDTH=\"").append(marginWidthAttr).append("\"");
        }
        if ((nameAttr = this.getPreferenceOrDefault(request, NAME_ATTR_PARAM, this.defaultNameAttr)) != null) {
            content.append(" NAME=\"").append(nameAttr).append("\"");
        }
        if (request.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            String maximizedWidthAttr;
            String maximizedStyleAttr;
            String maximizedScrollingAttr;
            String maximizedHeightAttr = this.getPreferenceOrDefault(request, MAXIMIZED_HEIGHT_ATTR_PARAM, this.defaultMaximizedHeightAttr);
            if (maximizedHeightAttr == null) {
                maximizedHeightAttr = this.getPreferenceOrDefault(request, HEIGHT_ATTR_PARAM, this.defaultHeightAttr);
            }
            if (maximizedHeightAttr != null) {
                content.append(" HEIGHT=\"").append(maximizedHeightAttr).append("\"");
            }
            if ((maximizedScrollingAttr = this.getPreferenceOrDefault(request, MAXIMIZED_SCROLLING_ATTR_PARAM, this.defaultMaximizedScrollingAttr)) == null) {
                maximizedScrollingAttr = this.getPreferenceOrDefault(request, SCROLLING_ATTR_PARAM, this.defaultScrollingAttr);
            }
            if (maximizedScrollingAttr != null) {
                content.append(" SCROLLING=\"").append(maximizedScrollingAttr).append("\"");
            }
            if ((maximizedStyleAttr = this.getPreferenceOrDefault(request, MAXIMIZED_STYLE_ATTR_PARAM, this.defaultMaximizedStyleAttr)) == null) {
                maximizedStyleAttr = this.getPreferenceOrDefault(request, STYLE_ATTR_PARAM, this.defaultStyleAttr);
            }
            if (maximizedStyleAttr != null) {
                content.append(" STYLE=\"").append(maximizedStyleAttr).append("\"");
            }
            if ((maximizedWidthAttr = this.getPreferenceOrDefault(request, MAXIMIZED_WIDTH_ATTR_PARAM, this.defaultMaximizedWidthAttr)) == null) {
                maximizedWidthAttr = this.getPreferenceOrDefault(request, WIDTH_ATTR_PARAM, this.defaultWidthAttr);
            }
            if (maximizedWidthAttr != null) {
                content.append(" WIDTH=\"").append(maximizedWidthAttr).append("\"");
            }
        } else {
            String widthAttr;
            String styleAttr;
            String scrollingAttr;
            String heightAttr = this.getPreferenceOrDefault(request, HEIGHT_ATTR_PARAM, this.defaultHeightAttr);
            if (heightAttr != null) {
                content.append(" HEIGHT=\"").append(heightAttr).append("\"");
            }
            if ((scrollingAttr = this.getPreferenceOrDefault(request, SCROLLING_ATTR_PARAM, this.defaultScrollingAttr)) != null) {
                content.append(" SCROLLING=\"").append(scrollingAttr).append("\"");
            }
            if ((styleAttr = this.getPreferenceOrDefault(request, STYLE_ATTR_PARAM, this.defaultStyleAttr)) != null) {
                content.append(" STYLE=\"").append(styleAttr).append("\"");
            }
            if ((widthAttr = this.getPreferenceOrDefault(request, WIDTH_ATTR_PARAM, this.defaultWidthAttr)) != null) {
                content.append(" WIDTH=\"").append(widthAttr).append("\"");
            }
        }
        content.append(">");
        content.append("<P STYLE=\"textAlign:center\"><A HREF=\"").append(sourceAttr).append("\">").append(sourceAttr).append("</A></P>");
        content.append("</IFRAME>");
        content.append("</TD></TR></TBODY></TABLE>");
        response.setContentType("text/html");
        response.getWriter().print(content.toString());
    }

    private String getAttributeParam(PortletConfig config, String name, String defaultValue) {
        String value = config.getInitParameter(name);
        if (value == null) {
            value = defaultValue;
        }
        return value != null && value.length() > 0 && !value.equalsIgnoreCase("none") ? value : null;
    }

    private String getPreferenceOrDefault(RenderRequest request, String name, String defaultValue) {
        if (!this.enablePreferences) {
            return defaultValue;
        }
        PortletPreferences prefs = request.getPreferences();
        return prefs != null ? prefs.getValue(name, defaultValue) : defaultValue;
    }
}

