/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.statistics.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.statistics.impl.LogRecord;

public abstract class BatchedStatistics
implements Runnable {
    private boolean done = true;
    private boolean keepRunning = true;
    protected Thread thread;
    protected long msLastFlushTime = 0L;
    protected int batchSize = 10;
    protected long msElapsedTimeThreshold = 5000L;
    protected Collection<LogRecord> logRecords = new ConcurrentLinkedQueue<LogRecord>();
    protected DataSource ds = null;
    protected String name;
    private static final Log log = LogFactory.getLog(BatchedStatistics.class);

    public BatchedStatistics(DataSource ds, int batchSize, long msElapsedTimeThreshold, String name) {
        this.ds = ds;
        this.msElapsedTimeThreshold = msElapsedTimeThreshold;
        this.batchSize = batchSize;
        this.name = name;
        if (this.name == null) {
            this.name = this.getClass().getName();
        }
        this.msLastFlushTime = System.currentTimeMillis();
        this.thread = new Thread((Runnable)this, name);
    }

    public void startThread() {
        this.thread.start();
        while (this.done) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    private void checkAndDoFlush() {
        long msCurrentTime = System.currentTimeMillis();
        if (this.logRecords.size() >= this.batchSize || msCurrentTime - this.msLastFlushTime > this.msElapsedTimeThreshold) {
            do {
                this.flush();
            } while (this.logRecords.size() >= this.batchSize);
            this.msLastFlushTime = msCurrentTime;
        }
    }

    public void addStatistic(LogRecord logRecord) {
        this.logRecords.add(logRecord);
    }

    public boolean isDone() {
        return this.done;
    }

    public void tellThreadToStop() {
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.done = false;
        while (this.keepRunning) {
            try {
                Thread thread = this.thread;
                synchronized (thread) {
                    this.thread.wait(this.msElapsedTimeThreshold / 4L);
                }
            }
            catch (InterruptedException ie) {
                this.keepRunning = false;
            }
            this.checkAndDoFlush();
        }
        this.flush();
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.logRecords.isEmpty()) {
            return;
        }
        Connection con = null;
        Statement stm = null;
        boolean autoCommit = true;
        try {
            con = this.getConnection();
            autoCommit = con.getAutoCommit();
            con.setAutoCommit(false);
            stm = this.getPreparedStatement(con);
            Iterator<LogRecord> recordIterator = this.logRecords.iterator();
            while (recordIterator.hasNext()) {
                LogRecord record = recordIterator.next();
                this.loadOneRecordToStatement((PreparedStatement)stm, record);
                stm.addBatch();
                recordIterator.remove();
            }
            stm.executeBatch();
            con.commit();
            log.debug((Object)(stm.getUpdateCount() + " " + this.name + " stratistics flushed."));
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                con.rollback();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException se) {}
            this.releaseConnection(con, autoCommit);
        }
    }

    protected abstract PreparedStatement getPreparedStatement(Connection var1) throws SQLException;

    protected abstract void loadOneRecordToStatement(PreparedStatement var1, LogRecord var2) throws SQLException;

    void releaseConnection(Connection con, boolean autoCommit) {
        try {
            if (con != null) {
                con.setAutoCommit(autoCommit);
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public abstract boolean canDoRecordType(LogRecord var1);
}

