/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.audit.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.audit.AuditActivity;
import org.springframework.orm.ojb.support.PersistenceBrokerDaoSupport;

public class AuditActivityImpl
extends PersistenceBrokerDaoSupport
implements AuditActivity {
    protected static final Log log = LogFactory.getLog((Class)AuditActivityImpl.class);
    protected DataSource ds;
    protected String anonymousUser = "guest";
    protected boolean enabled = true;

    public AuditActivityImpl(DataSource dataSource) {
        this.ds = dataSource;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public void logAdminAttributeActivity(String adminName, String ipAddress, String targetUser, String activity, String name, String beforeValue, String afterValue, String description) {
        if (this.enabled) {
            this.logAdminActivity(adminName, ipAddress, targetUser, activity, description, "attribute", name, beforeValue, afterValue);
        }
    }

    public void logAdminCredentialActivity(String adminName, String ipAddress, String targetUser, String activity, String description) {
        if (this.enabled) {
            this.logAdminActivity(adminName, ipAddress, targetUser, activity, description, "credential", "", "", "");
        }
    }

    public void logAdminAuthorizationActivity(String adminName, String ipAddress, String targetUser, String activity, String value, String description) {
        if (this.enabled) {
            this.logAdminActivity(adminName, ipAddress, targetUser, activity, description, "authorization", "", value, "");
        }
    }

    public void logAdminUserActivity(String adminName, String ipAddress, String targetUser, String activity, String description) {
        if (this.enabled) {
            this.logAdminActivity(adminName, ipAddress, targetUser, activity, description, "user", "", "", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void logAdminActivity(String adminName, String ipAddress, String targetUser, String activity, String description, String category, String name, String beforeValue, String afterValue) {
        block13: {
            Connection con = null;
            Statement stm = null;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            con = this.ds.getConnection();
            stm = con.prepareStatement("INSERT INTO ADMIN_ACTIVITY (ACTIVITY, CATEGORY, ADMIN, USER_NAME, TIME_STAMP, IPADDRESS, ATTR_NAME, ATTR_VALUE_BEFORE, ATTR_VALUE_AFTER, DESCRIPTION) VALUES(?,?,?,?,?,?,?,?,?,?)");
            stm.setString(1, activity);
            stm.setString(2, category);
            stm.setString(3, adminName);
            stm.setString(4, targetUser);
            stm.setTimestamp(5, timestamp);
            stm.setString(6, ipAddress);
            stm.setString(7, name);
            stm.setString(8, beforeValue);
            stm.setString(9, afterValue);
            stm.setString(10, description);
            stm.execute();
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException se) {
                // empty catch block
            }
            this.releaseConnection(con);
            break block13;
            catch (SQLException e) {
                try {
                    log.error((Object)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (SQLException se) {
                        // empty catch block
                    }
                    this.releaseConnection(con);
                    throw throwable;
                }
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (SQLException se) {
                    // empty catch block
                }
                this.releaseConnection(con);
            }
        }
    }

    public void logUserActivity(String userName, String ipAddress, String activity, String description) {
        this.logUserActivities(userName, ipAddress, activity, "", "", "", description, "authentication");
    }

    public void logUserAttributeActivity(String userName, String ipAddress, String activity, String name, String beforeValue, String afterValue, String description) {
        this.logUserActivities(userName, ipAddress, activity, name, beforeValue, afterValue, description, "user-attribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void logUserActivities(String userName, String ipAddress, String activity, String name, String beforeValue, String afterValue, String description, String category) {
        block14: {
            if (this.enabled) {
                Connection con = null;
                Statement stm = null;
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                con = this.ds.getConnection();
                stm = con.prepareStatement("INSERT INTO USER_ACTIVITY (ACTIVITY, CATEGORY, USER_NAME, TIME_STAMP, IPADDRESS, ATTR_NAME, ATTR_VALUE_BEFORE, ATTR_VALUE_AFTER, DESCRIPTION) VALUES(?,?,?,?,?,?,?,?,?)");
                stm.setString(1, activity);
                stm.setString(2, category);
                stm.setString(3, userName);
                stm.setTimestamp(4, timestamp);
                stm.setString(5, ipAddress);
                stm.setString(6, name);
                stm.setString(7, beforeValue);
                stm.setString(8, afterValue);
                stm.setString(9, description);
                stm.executeUpdate();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (SQLException se) {
                    // empty catch block
                }
                this.releaseConnection(con);
                break block14;
                catch (SQLException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stm != null) {
                                stm.close();
                            }
                        }
                        catch (SQLException se) {
                            // empty catch block
                        }
                        this.releaseConnection(con);
                        throw throwable;
                    }
                    try {
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (SQLException se) {
                        // empty catch block
                    }
                    this.releaseConnection(con);
                }
            }
        }
    }

    void releaseConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

