/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.sso.spi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationReference;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationType;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityDomain;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.BaseJetspeedPrincipalManager;
import org.apache.jetspeed.security.spi.JetspeedDomainPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalStorageManager;
import org.apache.jetspeed.security.spi.SecurityDomainAccessManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialAccessManager;
import org.apache.jetspeed.security.spi.UserPasswordCredentialStorageManager;
import org.apache.jetspeed.sso.SSOUser;
import org.apache.jetspeed.sso.impl.SSOUserImpl;
import org.apache.jetspeed.sso.spi.SSOUserManagerSPI;

public class SSOUserManagerSPIImpl
extends BaseJetspeedPrincipalManager
implements SSOUserManagerSPI {
    private static final long serialVersionUID = 1L;
    private JetspeedDomainPrincipalAccessManager domainPrincipalAccess;
    private SecurityDomainAccessManager domainAccess;
    private UserPasswordCredentialStorageManager credentialStorageManager;
    private UserPasswordCredentialAccessManager credentialAccessManager;

    public SSOUserManagerSPIImpl(JetspeedPrincipalType principalType, JetspeedPrincipalAccessManager jpam, JetspeedPrincipalStorageManager jpsm, UserPasswordCredentialStorageManager credentialStorageManager, UserPasswordCredentialAccessManager credentialAccessManager, JetspeedDomainPrincipalAccessManager domainPrincipalAccess, SecurityDomainAccessManager domainAccess) {
        super(principalType, jpam, jpsm);
        this.credentialStorageManager = credentialStorageManager;
        this.credentialAccessManager = credentialAccessManager;
        this.domainPrincipalAccess = domainPrincipalAccess;
        this.domainAccess = domainAccess;
    }

    public JetspeedPrincipal newPrincipal(String name, boolean mapped) {
        return null;
    }

    public JetspeedPrincipal newTransientPrincipal(String name) {
        return null;
    }

    @Override
    public SSOUser addUser(String name, Long domainId, JetspeedPrincipal ownerPrincipal) throws SecurityException {
        SSOUser user = this.newUser(name, domainId);
        HashSet<JetspeedPrincipalAssociationReference> reqAssociations = new HashSet<JetspeedPrincipalAssociationReference>();
        reqAssociations.add(new JetspeedPrincipalAssociationReference(JetspeedPrincipalAssociationReference.Type.TO, ownerPrincipal, "ownedBy"));
        super.addPrincipal((JetspeedPrincipal)user, reqAssociations);
        super.addAssociation((JetspeedPrincipal)user, ownerPrincipal, "isRemoteIdFor");
        return user;
    }

    @Override
    public PasswordCredential getPasswordCredential(SSOUser user) throws SecurityException {
        return this.credentialAccessManager.getPasswordCredential(user.getName(), user.getDomainId());
    }

    @Override
    public SSOUser getUser(String userName, Long domainId) throws SecurityException {
        SSOUser user = (SSOUser)this.domainPrincipalAccess.getPrincipal(userName, this.getPrincipalType(), domainId);
        if (null == user) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("ssoUser", (Object)userName));
        }
        return user;
    }

    @Override
    public Collection<String> getUserNames(String nameFilter, Long domainId) throws SecurityException {
        return this.domainPrincipalAccess.getPrincipalNames(nameFilter, this.getPrincipalType(), domainId);
    }

    protected List<? extends JetspeedPrincipal> getPrincipals(String nameFilter, Long domainId) {
        return this.domainPrincipalAccess.getPrincipals(nameFilter, this.getPrincipalType(), domainId);
    }

    @Override
    public Collection<SSOUser> getUsers(String nameFilter, Long domainId) throws SecurityException {
        return this.getPrincipals(nameFilter, domainId);
    }

    @Override
    public SSOUser newUser(String name, Long domainId) {
        SSOUserImpl user = new SSOUserImpl();
        user.setDomainId(domainId);
        user.setName(name);
        return user;
    }

    @Override
    public void removeUser(String userName, Long domainId) throws SecurityException {
        SSOUser user = this.getUser(userName, domainId);
        super.removePrincipal((JetspeedPrincipal)user);
    }

    @Override
    public void storePasswordCredential(PasswordCredential credential) throws SecurityException {
        this.credentialStorageManager.storePasswordCredential(credential);
    }

    @Override
    public void updateUser(SSOUser user) throws SecurityException {
        super.updatePrincipal((JetspeedPrincipal)user);
    }

    @Override
    public boolean userExists(String userName, Long domainId) {
        return this.domainPrincipalAccess.principalExists(userName, this.getPrincipalType(), domainId);
    }

    @Override
    public Collection<SSOUser> getUsers(JetspeedPrincipal principal) throws SecurityException {
        Collection allDomains = this.domainAccess.getDomainsOwnedBy(principal.getDomainId());
        ArrayList<SSOUser> users = new ArrayList<SSOUser>();
        for (SecurityDomain domain : allDomains) {
            users.addAll(this.getUsers(principal, domain.getDomainId()));
        }
        return users;
    }

    @Override
    public Collection<SSOUser> getUsers(JetspeedPrincipal principal, Long remoteSecurityDomain) throws SecurityException {
        return this._getSSOUsersForPrincipal(principal, remoteSecurityDomain);
    }

    private Collection<? extends JetspeedPrincipal> _getSSOUsersForPrincipal(JetspeedPrincipal principal, Long remoteSecurityDomain) throws SecurityException {
        return this.domainPrincipalAccess.getAssociatedTo(principal.getName(), this.getPrincipalType(), principal.getType(), "isRemoteIdFor", remoteSecurityDomain, principal.getDomainId());
    }

    @Override
    public void addSSOUserToPrincipal(SSOUser user, JetspeedPrincipal principal) throws SecurityException {
        super.addAssociation((JetspeedPrincipal)user, principal, "isRemoteIdFor");
    }

    @Override
    public Collection<JetspeedPrincipal> getPortalPrincipals(SSOUser remoteUser, Long portalPrincipalDomain) {
        ArrayList<JetspeedPrincipal> principalsFound = new ArrayList<JetspeedPrincipal>();
        List assTypes = super.getAssociationTypes();
        for (JetspeedPrincipalAssociationType type : assTypes) {
            if (!type.getAssociationName().equals("isRemoteIdFor")) continue;
            List principalsForThisType = this.domainPrincipalAccess.getAssociatedFrom(remoteUser.getName(), this.getPrincipalType(), type.getToPrincipalType(), "isRemoteIdFor", remoteUser.getDomainId(), portalPrincipalDomain);
            principalsFound.addAll(principalsForThisType);
        }
        return principalsFound;
    }
}

