/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.sso.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOPrincipal;
import org.apache.jetspeed.sso.SSOSite;

public class SSOSiteImpl
implements SSOSite {
    private int siteId;
    private String name;
    private String siteURL;
    private boolean isAllowUserSet;
    private boolean isCertificateRequired;
    private boolean isChallengeResponseAuthentication;
    private String realm;
    private boolean isFormAuthentication;
    private String formUserField;
    private String formPwdField;
    private Collection principals = new Vector();
    private Collection remotePrincipals = new Vector();

    public boolean isAllowUserSet() {
        return this.isAllowUserSet;
    }

    public void setAllowUserSet(boolean isAllowUserSet) {
        this.isAllowUserSet = isAllowUserSet;
    }

    public boolean isCertificateRequired() {
        return this.isCertificateRequired;
    }

    public void setCertificateRequired(boolean isCertificateRequired) {
        this.isCertificateRequired = isCertificateRequired;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection principals) {
        this.principals.addAll(principals);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int siteId) {
        this.siteId = siteId;
    }

    public String getSiteURL() {
        return this.siteURL;
    }

    public void setSiteURL(String siteURL) {
        this.siteURL = siteURL;
    }

    public void addPrincipal(SSOPrincipal principal) throws SSOException {
        boolean bStatus = false;
        try {
            bStatus = this.principals.add(principal);
        }
        catch (Exception e) {
            throw new SSOException("Could not add Principal from SITE mapping table." + e.getMessage());
        }
        if (!bStatus) {
            throw new SSOException("Could not add Principal from SITE mapping table.");
        }
    }

    public void removePrincipal(long principalId) throws SSOException {
        boolean bStatus = false;
        SSOPrincipal principalObj = null;
        Iterator itSitePrincipals = this.principals.iterator();
        while (itSitePrincipals.hasNext()) {
            principalObj = (SSOPrincipal)itSitePrincipals.next();
            if (principalObj.getPrincipalId() != principalId) continue;
            try {
                bStatus = this.principals.remove(principalObj);
            }
            catch (Exception e) {
                throw new SSOException("Could not remove Principal from SITE mapping table." + e.getMessage());
            }
            if (bStatus) continue;
            throw new SSOException("Could not remove Principal from SITE mapping table.");
        }
    }

    public Collection getRemotePrincipals() {
        return this.remotePrincipals;
    }

    public void setRemotePrincipals(Collection remotePrincipals) {
        this.remotePrincipals = remotePrincipals;
    }

    public void setFormAuthentication(String formUserField, String formPwdField) {
    }

    public void setChallengeResponseAuthentication() {
    }

    public String getFormPwdField() {
        return this.formPwdField;
    }

    public void setFormPwdField(String formPwdField) {
        this.formPwdField = formPwdField;
    }

    public String getFormUserField() {
        return this.formUserField;
    }

    public void setFormUserField(String formUserField) {
        this.formUserField = formUserField;
    }

    public boolean isChallengeResponseAuthentication() {
        return this.isChallengeResponseAuthentication;
    }

    public void setChallengeResponseAuthentication(boolean isChallengeResponseAuthentication) {
        this.isChallengeResponseAuthentication = isChallengeResponseAuthentication;
    }

    public boolean isFormAuthentication() {
        return this.isFormAuthentication;
    }

    public void setFormAuthentication(boolean isFormAuthentication) {
        this.isFormAuthentication = isFormAuthentication;
    }

    public void configFormAuthentication(String formUserField, String formPwdField) {
        this.isFormAuthentication = true;
        this.setChallengeResponseAuthentication(false);
        this.formPwdField = formPwdField;
        this.formUserField = formUserField;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }
}

