/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.sso.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.security.BasePrincipal;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalGroupPrincipal;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.om.impl.InternalCredentialImpl;
import org.apache.jetspeed.security.om.impl.InternalGroupPrincipalImpl;
import org.apache.jetspeed.security.om.impl.InternalUserPrincipalImpl;
import org.apache.jetspeed.security.spi.impl.DefaultPasswordCredentialImpl;
import org.apache.jetspeed.sso.SSOContext;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOPrincipal;
import org.apache.jetspeed.sso.SSOProvider;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.impl.SSOContextImpl;
import org.apache.jetspeed.sso.impl.SSOCookieImpl;
import org.apache.jetspeed.sso.impl.SSOPrincipalImpl;
import org.apache.jetspeed.sso.impl.SSOSiteImpl;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;

public class PersistenceBrokerSSOProvider
extends InitablePersistenceBrokerDaoSupport
implements SSOProvider {
    private static final Log log = LogFactory.getLog((Class)PersistenceBrokerSSOProvider.class);
    private Hashtable mapSite = new Hashtable();
    private Hashtable clientProxy = new Hashtable();
    private String USER_PATH = "/user/";
    private String GROUP_PATH = "/group/";
    static char[] scrambler = "Jestspeed-2 is getting ready for release".toCharArray();

    public PersistenceBrokerSSOProvider(String repositoryPath) throws ClassNotFoundException {
        super(repositoryPath);
    }

    public String useSSO(Subject subject, String url, String SSOSite2, boolean bRefresh) throws SSOException {
        BasePrincipal principal = (BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class);
        String fullPath = principal.getFullPath();
        String proxyID = fullPath + "_" + SSOSite2;
        SSOSite ssoSite = this.getSSOSiteObject(SSOSite2);
        if (ssoSite != null) {
            SSOSite[] sites = new SSOSite[]{ssoSite};
            return this.getContentFromURL(proxyID, url, sites, bRefresh);
        }
        String msg = "SSO component -- useSSO can't retrive SSO credential because SSOSite [" + SSOSite2 + "] doesn't exist";
        log.error((Object)msg);
        SSOSite[] sites = new SSOSite[]{};
        return this.getContentFromURL(proxyID, url, sites, bRefresh);
    }

    public String useSSO(Subject subject, String url, boolean bRefresh) throws SSOException {
        String fullPath;
        BasePrincipal principal = (BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class);
        String proxyID = fullPath = principal.getFullPath();
        Collection sites = this.getSitesForPrincipal(fullPath);
        if (sites == null) {
            String msg = "SSO Component useSSO -- Couldn't find any SSO sites for user [" + fullPath + "]";
            log.error((Object)msg);
            throw new SSOException(msg);
        }
        int siteSize = sites.size();
        int siteIndex = 0;
        SSOSite[] ssoSites = new SSOSite[siteSize];
        Iterator itSites = sites.iterator();
        while (itSites.hasNext()) {
            SSOSite ssoSite = (SSOSite)itSites.next();
            if (ssoSite == null) continue;
            ssoSites[siteIndex] = ssoSite;
            ++siteIndex;
        }
        return this.getContentFromURL(proxyID, url, ssoSites, bRefresh);
    }

    public Collection getCookiesForUser(String fullPath) {
        SSOPrincipal ssoPrincipal = this.getSSOPrincipal(fullPath);
        Vector<String> temp = new Vector<String>();
        Iterator itRemotePrincipal = ssoPrincipal.getRemotePrincipals().iterator();
        while (itRemotePrincipal.hasNext()) {
            InternalUserPrincipal rp = (InternalUserPrincipal)itRemotePrincipal.next();
            if (rp == null) continue;
            temp.add(rp.getFullPath());
        }
        if (temp.size() > 0) {
            Criteria filter = new Criteria();
            filter.addIn("remotePrincipals.fullPath", temp);
            QueryByCriteria query = QueryFactory.newQuery((Class)SSOCookieImpl.class, (Criteria)filter);
            return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        }
        return null;
    }

    public Collection getCookiesForUser(Subject user) {
        BasePrincipal principal = (BasePrincipal)SecurityHelper.getBestPrincipal((Subject)user, (Class)UserPrincipal.class);
        String fullPath = principal.getFullPath();
        return this.getCookiesForUser(fullPath);
    }

    public void setRealmForSite(String site, String realm) throws SSOException {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite != null) {
            try {
                ssoSite.setRealm(realm);
                this.getPersistenceBrokerTemplate().store((Object)ssoSite);
            }
            catch (Exception e) {
                throw new SSOException("Failed to set the realm for site [" + site + "] Error" + e);
            }
        }
    }

    public String getRealmForSite(String site) throws SSOException {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite != null) {
            return ssoSite.getRealm();
        }
        return null;
    }

    public Collection getSitesForPrincipal(String fullPath) {
        Criteria filter = new Criteria();
        filter.addEqualTo("principals.fullPath", (Object)fullPath);
        QueryByCriteria query = QueryFactory.newQuery((Class)SSOSiteImpl.class, (Criteria)filter);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    public Iterator getSites(String filter) {
        Criteria queryCriteria = new Criteria();
        QueryByCriteria query = QueryFactory.newQuery((Class)SSOSiteImpl.class, (Criteria)queryCriteria);
        Collection c = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return c.iterator();
    }

    public void addCredentialsForSite(String fullPath, String remoteUser, String site, String pwd) throws SSOException {
        GroupPrincipalImpl principal = null;
        String name = null;
        if (fullPath.indexOf("/group/") > -1) {
            name = fullPath.substring(this.GROUP_PATH.length());
            principal = new GroupPrincipalImpl(name);
        } else {
            name = fullPath.substring(this.USER_PATH.length());
            principal = new UserPrincipalImpl(name);
        }
        HashSet<GroupPrincipalImpl> principals = new HashSet<GroupPrincipalImpl>();
        principals.add(principal);
        Subject subject = new Subject(true, principals, new HashSet(), new HashSet());
        this.addCredentialsForSite(subject, remoteUser, site, pwd);
    }

    public void removeCredentialsForSite(String fullPath, String site) throws SSOException {
        GroupPrincipalImpl principal = null;
        String name = null;
        if (fullPath.indexOf("/group/") > -1) {
            name = fullPath.substring(this.GROUP_PATH.length());
            principal = new GroupPrincipalImpl(name);
        } else {
            name = fullPath.substring(this.USER_PATH.length());
            principal = new UserPrincipalImpl(name);
        }
        HashSet<GroupPrincipalImpl> principals = new HashSet<GroupPrincipalImpl>();
        principals.add(principal);
        Subject subject = new Subject(true, principals, new HashSet(), new HashSet());
        this.removeCredentialsForSite(subject, site);
    }

    public String getSiteURL(String site) {
        return site;
    }

    public String getSiteName(String site) {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite != null) {
            return ssoSite.getName();
        }
        return null;
    }

    public boolean hasSSOCredentials(Subject subject, String site) {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            return false;
        }
        BasePrincipal principal = (BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class);
        String fullPath = principal.getFullPath();
        Collection remoteForSite = ssoSite.getRemotePrincipals();
        Collection principalsForSite = ssoSite.getPrincipals();
        if (principalsForSite == null || remoteForSite == null) {
            return false;
        }
        Collection remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath);
        if (remoteForPrincipals == null) {
            return false;
        }
        return this.findRemoteMatch(remoteForPrincipals, remoteForSite) != null;
    }

    public SSOContext getCredentials(Subject subject, String site) throws SSOException {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        BasePrincipal principal = (BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class);
        String fullPath = principal.getFullPath();
        SSOContext context = this.getCredential(ssoSite, fullPath);
        if (context == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        return context;
    }

    public void addCredentialsForSite(Subject subject, String remoteUser, String site, String pwd) throws SSOException {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            ssoSite = new SSOSiteImpl();
            ssoSite.setSiteURL(site);
            ssoSite.setName(site);
            ssoSite.setCertificateRequired(false);
            ssoSite.setAllowUserSet(true);
            ssoSite.setChallengeResponseAuthentication(true);
            ssoSite.setFormAuthentication(false);
            this.updateSite(ssoSite);
        }
        String fullPath = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class)).getFullPath();
        String principalName = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class)).getName();
        this.addCredentialsForSite(ssoSite, fullPath, principalName, remoteUser, this.scramble(pwd));
        this.updateSite(ssoSite);
    }

    public void removeCredentialsForSite(Subject subject, String site) throws SSOException {
        InternalUserPrincipal remotePrincipal = null;
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        String fullPath = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class)).getFullPath();
        try {
            Collection principalsForSite = ssoSite.getPrincipals();
            Collection remoteForSite = ssoSite.getRemotePrincipals();
            if (principalsForSite == null || remoteForSite == null) {
                throw new SSOException("The site has no Single Sign On credentails attached.");
            }
            Collection remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath);
            if (remoteForPrincipals == null) {
                throw new SSOException("The site has no Single Sign On credentails attached.");
            }
            remotePrincipal = this.findRemoteMatch(remoteForPrincipals, remoteForSite);
            if (remotePrincipal == null) {
                throw new SSOException("The site has no Single Sign On credentails attached.");
            }
            ssoSite.getRemotePrincipals().remove(remotePrincipal);
            if (remoteForPrincipals.remove(remotePrincipal)) {
                this.getPersistenceBrokerTemplate().store((Object)ssoSite);
            }
            this.getPersistenceBrokerTemplate().delete((Object)remotePrincipal);
        }
        catch (SSOException ssoex) {
            throw new SSOException((Throwable)ssoex);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mapSite.remove(site);
            throw new SSOException("Failed to store site info in database." + e.toString());
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SSOException("Failed to store site info in database." + e.toString());
        }
        finally {
            this.mapSite.remove(site);
        }
    }

    public void updateCredentialsForSite(Subject subject, String remoteUser, String site, String pwd) throws SSOException {
        InternalUserPrincipal remotePrincipal = null;
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        String fullPath = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class)).getFullPath();
        Collection principalsForSite = ssoSite.getPrincipals();
        Collection remoteForSite = ssoSite.getRemotePrincipals();
        if (principalsForSite == null || remoteForSite == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        Collection remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath);
        if (remoteForPrincipals == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        remotePrincipal = this.findRemoteMatch(remoteForPrincipals, remoteForSite);
        if (remotePrincipal == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        InternalCredential credential = (InternalCredential)remotePrincipal.getCredentials().iterator().next();
        if (credential != null) {
            credential.setValue(this.scramble(pwd));
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)credential);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SSOException("Failed to store site info in database." + e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SSOSite getSSOSiteObject(String site) {
        SSOSite ssoSite = null;
        if (this.mapSite.containsKey(site)) return (SSOSite)this.mapSite.get(site);
        Criteria filter = new Criteria();
        filter.addEqualTo("siteURL", (Object)site);
        QueryByCriteria query = QueryFactory.newQuery((Class)SSOSiteImpl.class, (Criteria)filter);
        Collection ssoSiteCollection = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        if (ssoSiteCollection == null) return null;
        if (ssoSiteCollection.isEmpty()) return null;
        Iterator itSite = ssoSiteCollection.iterator();
        if (itSite.hasNext()) {
            ssoSite = (SSOSite)itSite.next();
        }
        this.mapSite.put(site, ssoSite);
        return ssoSite;
    }

    private SSOContext getCredential(SSOSite ssoSite, String fullPath) {
        InternalCredential credential = null;
        InternalUserPrincipal remotePrincipal = null;
        Collection principalsForSite = ssoSite.getPrincipals();
        Collection remoteForSite = ssoSite.getRemotePrincipals();
        if (principalsForSite == null || remoteForSite == null) {
            return null;
        }
        Collection remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath);
        if (remoteForPrincipals == null) {
            return null;
        }
        remotePrincipal = this.findRemoteMatch(remoteForPrincipals, remoteForSite);
        if (remotePrincipal == null) {
            return null;
        }
        if (remotePrincipal.getCredentials() != null) {
            credential = (InternalCredential)remotePrincipal.getCredentials().iterator().next();
        }
        if (credential == null) {
            return null;
        }
        String name = this.stripPrincipalName(remotePrincipal.getFullPath());
        SSOContextImpl context = new SSOContextImpl(credential.getPrincipalId(), name, this.unscramble(credential.getValue()));
        return context;
    }

    private String stripPrincipalName(String fullPath) {
        int ix = fullPath.lastIndexOf(47);
        String name = ix != -1 ? fullPath.substring(ix + 1) : new String(fullPath);
        return name;
    }

    private SSOPrincipal getPrincipalForSite(SSOSite ssoSite, String fullPath) {
        SSOPrincipal principal = null;
        Collection principalsForSite = ssoSite.getPrincipals();
        if (principalsForSite != null) {
            Iterator itPrincipals = principalsForSite.iterator();
            while (itPrincipals.hasNext() && principal == null) {
                SSOPrincipal tmp = (SSOPrincipal)itPrincipals.next();
                if (tmp == null || tmp.getFullPath().compareToIgnoreCase(fullPath) != 0) continue;
                principal = tmp;
            }
        }
        return principal;
    }

    private SSOPrincipal getSSOPrincipal(String fullPath) {
        Iterator itPrincipals;
        SSOPrincipal principal = null;
        Criteria filter = new Criteria();
        filter.addEqualTo("fullPath", (Object)fullPath);
        QueryByCriteria query = QueryFactory.newQuery((Class)SSOPrincipalImpl.class, (Criteria)filter);
        Collection principals = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        if (principals != null && !principals.isEmpty() && (itPrincipals = principals.iterator()).hasNext()) {
            principal = (SSOPrincipal)itPrincipals.next();
        }
        return principal;
    }

    private InternalUserPrincipal findRemoteMatch(Collection remoteForPrincipals, Collection remoteForSite) {
        Iterator itRemoteForPrincipals = remoteForPrincipals.iterator();
        while (itRemoteForPrincipals.hasNext()) {
            InternalUserPrincipal remoteForPrincipal = (InternalUserPrincipal)itRemoteForPrincipals.next();
            Iterator itRemoteForSite = remoteForSite.iterator();
            while (itRemoteForSite.hasNext()) {
                InternalUserPrincipal tmp = (InternalUserPrincipal)itRemoteForSite.next();
                if (tmp.getPrincipalId() != remoteForPrincipal.getPrincipalId()) continue;
                return remoteForPrincipal;
            }
        }
        return null;
    }

    private Collection getRemotePrincipalsForPrincipal(Collection principalsForSite, String fullPath) {
        if (principalsForSite != null) {
            Iterator itPrincipalsForSite = principalsForSite.iterator();
            while (itPrincipalsForSite.hasNext()) {
                String principalFullPath = null;
                SSOPrincipal principal = (SSOPrincipal)itPrincipalsForSite.next();
                principalFullPath = principal.getFullPath();
                if (principalFullPath.indexOf("/group/") == -1) {
                    if (principalFullPath.compareToIgnoreCase(fullPath) != 0) continue;
                    return principal.getRemotePrincipals();
                }
                if (principalFullPath.compareToIgnoreCase(fullPath) == 0) {
                    return principal.getRemotePrincipals();
                }
                InternalGroupPrincipal groupPrincipal = this.getGroupPrincipals(principalFullPath);
                if (groupPrincipal == null) continue;
                Collection usersInGroup = groupPrincipal.getUserPrincipals();
                Iterator itUsers = usersInGroup.iterator();
                while (itUsers.hasNext()) {
                    InternalUserPrincipal user = (InternalUserPrincipal)itUsers.next();
                    if (user.getFullPath().compareToIgnoreCase(fullPath) != 0) continue;
                    return principal.getRemotePrincipals();
                }
            }
        }
        return null;
    }

    public SSOSite getSite(String siteUrl) {
        Criteria filter = new Criteria();
        filter.addEqualTo("siteURL", (Object)siteUrl);
        QueryByCriteria query = QueryFactory.newQuery((Class)SSOSiteImpl.class, (Criteria)filter);
        SSOSite site = (SSOSite)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        if (site != null) {
            this.mapSite.put(siteUrl, site);
        } else {
            this.mapSite.remove(siteUrl);
        }
        return site;
    }

    public void updateSite(SSOSite site) throws SSOException {
        try {
            this.getPersistenceBrokerTemplate().store((Object)site);
            this.mapSite.put(site.getSiteURL(), site);
        }
        catch (Exception e) {
            String msg = "Unable to remove SSO Site: " + site.getName();
            this.logger.error((Object)msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public void addSiteFormAuthenticated(String siteName, String siteUrl, String realm, String userField, String pwdField) throws SSOException {
        try {
            SSOSiteImpl ssoSite = new SSOSiteImpl();
            ssoSite.setSiteURL(siteUrl);
            ssoSite.setName(siteName);
            ssoSite.setCertificateRequired(false);
            ssoSite.setAllowUserSet(true);
            ssoSite.setRealm(realm);
            ssoSite.setFormAuthentication(true);
            ssoSite.setFormUserField(userField);
            ssoSite.setFormPwdField(pwdField);
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
            this.mapSite.put(siteUrl, ssoSite);
        }
        catch (Exception e) {
            String msg = "Unable to add SSO Site: " + siteName;
            this.logger.error((Object)msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public void addSiteChallengeResponse(String siteName, String siteUrl, String realm) throws SSOException {
        try {
            SSOSiteImpl ssoSite = new SSOSiteImpl();
            ssoSite.setSiteURL(siteUrl);
            ssoSite.setName(siteName);
            ssoSite.setCertificateRequired(false);
            ssoSite.setAllowUserSet(true);
            ssoSite.setRealm(realm);
            ssoSite.setChallengeResponseAuthentication(true);
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
            this.mapSite.put(siteUrl, ssoSite);
        }
        catch (Exception e) {
            String msg = "Unable to add SSO Site: " + siteName;
            this.logger.error((Object)msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public void addSite(String siteName, String siteUrl) throws SSOException {
        try {
            SSOSiteImpl ssoSite = new SSOSiteImpl();
            ssoSite.setSiteURL(siteUrl);
            ssoSite.setName(siteName);
            ssoSite.setCertificateRequired(false);
            ssoSite.setAllowUserSet(true);
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
            this.mapSite.put(siteUrl, ssoSite);
        }
        catch (Exception e) {
            String msg = "Unable to remove SSO Site: " + siteName;
            this.logger.error((Object)msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public void removeSite(SSOSite site) throws SSOException {
        try {
            this.getPersistenceBrokerTemplate().delete((Object)site);
            this.mapSite.remove(site.getSiteURL());
        }
        catch (Exception e) {
            String msg = "Unable to remove SSO Site: " + site.getName();
            this.logger.error((Object)msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public List getPrincipalsForSite(SSOSite site) {
        ArrayList<SSOContextImpl> list = new ArrayList<SSOContextImpl>();
        Iterator principals = site.getRemotePrincipals().iterator();
        while (principals.hasNext()) {
            InternalUserPrincipal remotePrincipal = (InternalUserPrincipal)principals.next();
            Iterator creds = remotePrincipal.getCredentials().iterator();
            while (creds.hasNext()) {
                InternalCredential cred = (InternalCredential)creds.next();
                SSOContextImpl context = new SSOContextImpl(remotePrincipal.getPrincipalId(), this.stripPrincipalName(remotePrincipal.getFullPath()), cred.getValue(), this.stripPortalPrincipalName(remotePrincipal.getFullPath()));
                list.add(context);
            }
        }
        return list;
    }

    private String stripPortalPrincipalName(String fullPath) {
        StringTokenizer tokenizer = new StringTokenizer(fullPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals("user") && !token.equals("group") || !tokenizer.hasMoreTokens()) continue;
            return tokenizer.nextToken();
        }
        return fullPath;
    }

    private InternalGroupPrincipal getGroupPrincipals(String principalFullPath) {
        Criteria filter = new Criteria();
        filter.addEqualTo("fullPath", (Object)principalFullPath);
        QueryByCriteria query = QueryFactory.newQuery((Class)InternalGroupPrincipalImpl.class, (Criteria)filter);
        InternalGroupPrincipal group = (InternalGroupPrincipal)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        return group;
    }

    private String getContentFromURL(String proxyID, String destUrl, SSOSite[] sites, boolean bRefresh) throws SSOException {
        String resultPage;
        URL urlObj = null;
        String strErrorMessage = "SSO Component Error. Failed to get content for URL " + destUrl;
        try {
            urlObj = new URL(destUrl);
        }
        catch (MalformedURLException e) {
            String msg = "Error -- Malformed URL [" + destUrl + "] for SSO authenticated destination";
            log.error((Object)msg);
            throw new SSOException(msg, (Throwable)e);
        }
        HttpClient client = (HttpClient)this.clientProxy.get(proxyID);
        GetMethod get = null;
        if (bRefresh || client == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("SSO Component -- Create new HTTP Client object for Principal/URL [" + proxyID + "]"));
            }
            client = new HttpClient();
            client.getState().setCookiePolicy(0);
            int numberOfSites = sites.length;
            for (int i = 0; i < numberOfSites; ++i) {
                SSOSite site = sites[i];
                if (site == null) continue;
                Iterator itRemotePrincipals = site.getRemotePrincipals().iterator();
                while (itRemotePrincipals.hasNext()) {
                    InternalUserPrincipal remotePrincipal = (InternalUserPrincipal)itRemotePrincipals.next();
                    if (remotePrincipal == null) continue;
                    InternalCredential credential = null;
                    if (remotePrincipal.getCredentials() != null) {
                        credential = (InternalCredential)remotePrincipal.getCredentials().iterator().next();
                    }
                    if (credential == null) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("SSOComponent -- Remote Principal [" + this.stripPrincipalName(remotePrincipal.getFullPath()) + "] has credential [" + this.unscramble(credential.getValue()) + "]"));
                    }
                    client.getState().setCredentials(site.getRealm(), urlObj.getHost(), (Credentials)new UsernamePasswordCredentials(this.stripPrincipalName(remotePrincipal.getFullPath()), this.unscramble(credential.getValue())));
                    StringBuffer siteURL = new StringBuffer(site.getSiteURL());
                    if (site.isFormAuthentication()) {
                        siteURL.append("?").append(site.getFormUserField()).append("=").append(this.stripPrincipalName(remotePrincipal.getFullPath())).append("&").append(site.getFormPwdField()).append("=").append(this.unscramble(credential.getValue()));
                    }
                    get = new GetMethod(siteURL.toString());
                    get.setDoAuthentication(true);
                    try {
                        int status = client.executeMethod((HttpMethod)get);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Accessing site [" + site.getSiteURL() + "]. HTTP Status [" + status + "]"));
                        }
                        if (destUrl.compareTo(site.getSiteURL()) == 0 && numberOfSites == 1) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)"SSO Component --SSO Site and destination URL match. Go and get the content.");
                            }
                            String resultPage2 = get.getResponseBodyAsString();
                            get.releaseConnection();
                            this.clientProxy.put(proxyID, client);
                            return resultPage2;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Exception while authentication. Error: " + e));
                    }
                    get.releaseConnection();
                }
            }
            this.clientProxy.put(proxyID, client);
        } else if (log.isInfoEnabled()) {
            log.info((Object)("SSO Component -- Use cached HTTP Client object for Principal/URL [" + proxyID + "]"));
        }
        get = new GetMethod(destUrl);
        try {
            int status = client.executeMethod((HttpMethod)get);
            log.info((Object)("Accessing site [" + destUrl + "]. HTTP Status [" + status + "]"));
        }
        catch (Exception e) {
            log.error((Object)("Exception while authentication. Error: " + e));
        }
        try {
            resultPage = get.getResponseBodyAsString();
        }
        catch (IOException ioe) {
            log.error((Object)strErrorMessage, (Throwable)ioe);
            throw new SSOException(strErrorMessage, (Throwable)ioe);
        }
        catch (Exception e) {
            log.error((Object)strErrorMessage, (Throwable)e);
            throw new SSOException(strErrorMessage, (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
        return resultPage;
    }

    private String scramble(String pwd) {
        String xored = new String(this.xor(pwd.toCharArray(), scrambler));
        byte[] bytes = Base64.encodeBase64((byte[])xored.getBytes());
        String scrambled = new String(bytes);
        return scrambled;
    }

    private String unscramble(String pwd) {
        byte[] bytes = pwd.getBytes();
        bytes = Base64.decodeBase64((byte[])bytes);
        String chars = new String(bytes);
        String unscrambled = new String(this.xor(chars.toCharArray(), scrambler));
        return unscrambled;
    }

    private char[] xor(char[] a, char[] b) {
        int len = Math.min(a.length, b.length);
        char[] result = new char[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (char)(a[i] ^ b[i]);
        }
        return result;
    }

    public void addCredentialsForSite(SSOSite ssoSite, Subject subject, String remoteUser, String pwd) throws SSOException {
        String fullPath = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class)).getFullPath();
        String principalName = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)UserPrincipal.class)).getName();
        this.addCredentialsForSite(ssoSite, fullPath, principalName, remoteUser, this.scramble(pwd));
    }

    public void addCredentialsForSite(SSOSite ssoSite, String principalFullPath, String principalName, String remoteUser, String scrambledPwd) throws SSOException {
        SSOPrincipal principal = this.getPrincipalForSite(ssoSite, principalFullPath);
        if (principal == null) {
            principal = this.getSSOPrincipal(principalFullPath);
            ssoSite.addPrincipal(principal);
        } else {
            Collection remoteForPrincipals;
            Collection remoteForSite = ssoSite.getRemotePrincipals();
            Collection principalsForSite = ssoSite.getPrincipals();
            if (remoteForSite != null && principalsForSite != null && (remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, principalFullPath)) != null && this.findRemoteMatch(remoteForPrincipals, remoteForSite) != null) {
                throw new SSOException("Remote principal for site/principal already exists. Call update instead");
            }
        }
        if (principal == null) {
            throw new SSOException("Could not add Principal from SITE mapping table.");
        }
        InternalUserPrincipalImpl remotePrincipal = new InternalUserPrincipalImpl(remoteUser);
        if (principalFullPath.indexOf("/group/") > -1) {
            remotePrincipal.setFullPath("/sso/" + ssoSite.getSiteId() + "/group/" + principalName + "/" + remoteUser);
        } else {
            remotePrincipal.setFullPath("/sso/" + ssoSite.getSiteId() + "/user/" + principalName + "/" + remoteUser);
        }
        InternalCredentialImpl credential = new InternalCredentialImpl(remotePrincipal.getPrincipalId(), scrambledPwd, 0, DefaultPasswordCredentialImpl.class.getName());
        if (remotePrincipal.getCredentials() == null) {
            remotePrincipal.setCredentials(new ArrayList(0));
        }
        remotePrincipal.getCredentials().add(credential);
        principal.addRemotePrincipal((InternalUserPrincipal)remotePrincipal);
        ssoSite.getRemotePrincipals().add(remotePrincipal);
        try {
            this.getPersistenceBrokerTemplate().store((Object)principal);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SSOException("Failed to store site info in database." + e.toString());
        }
    }

    void debugSite(SSOSite site) {
        Iterator i = site.getRemotePrincipals().iterator();
        while (i.hasNext()) {
            InternalUserPrincipal p = (InternalUserPrincipal)i.next();
            Iterator o = p.getCredentials().iterator();
        }
    }
}

