/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.serializer.objects.JSSSOSiteRemoteUser;
import org.apache.jetspeed.serializer.objects.JSSSOSiteRemoteUsers;

public class JSSSOSite {
    private String name;
    private String siteURL;
    private boolean allowUserSet;
    private boolean certificateRequired;
    private boolean challengeResponseAuthentication;
    private String realm;
    private boolean formAuthentication;
    private String formUserField;
    private String formPwdField;
    private JSSSOSiteRemoteUsers remoteUsers;
    private static final XMLFormat XML = new XMLFormat(JSSSOSite.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSSSOSite g = (JSSSOSite)o;
                xml.setAttribute("name", g.getName());
                xml.setAttribute("siteURL", g.getSiteURL());
                xml.setAttribute("allowUserSet", g.isAllowUserSet());
                xml.setAttribute("certificateRequired", g.isCertificateRequired());
                xml.setAttribute("challengeResponseAuthentication", g.isChallengeResponseAuthentication());
                xml.setAttribute("realm", g.getRealm());
                xml.setAttribute("formAuthentication", g.isFormAuthentication());
                xml.setAttribute("formUserField", g.getFormUserField());
                xml.setAttribute("formPwdField", g.getFormPwdField());
                xml.add((Object)g.getRemoteUsers());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSSSOSite g = (JSSSOSite)o;
                g.setName(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", (String)null)));
                g.setSiteURL(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("siteURL", (String)null)));
                g.setAllowUserSet(Boolean.parseBoolean(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("allowUserSet", "false"))));
                g.setCertificateRequired(Boolean.parseBoolean(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("certificateRequired", "false"))));
                g.setChallengeResponseAuthentication(Boolean.parseBoolean(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("challengeResponseAuthentication", "false"))));
                g.setRealm(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("realm", (String)null)));
                g.setFormAuthentication(Boolean.parseBoolean(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("formAuthentication", "false"))));
                g.setFormUserField(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("formUserField", (String)null)));
                g.setFormPwdField(StringEscapeUtils.unescapeHtml((String)xml.getAttribute("formPwdField", (String)null)));
                Object o1 = null;
                while (xml.hasNext()) {
                    o1 = xml.getNext();
                    if (!(o1 instanceof JSSSOSiteRemoteUsers)) continue;
                    g.setRemoteUsers((JSSSOSiteRemoteUsers)o1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSiteURL() {
        return this.siteURL;
    }

    public void setSiteURL(String siteURL) {
        this.siteURL = siteURL;
    }

    public boolean isAllowUserSet() {
        return this.allowUserSet;
    }

    public void setAllowUserSet(boolean allowUserSet) {
        this.allowUserSet = allowUserSet;
    }

    public boolean isCertificateRequired() {
        return this.certificateRequired;
    }

    public void setCertificateRequired(boolean certificateRequired) {
        this.certificateRequired = certificateRequired;
    }

    public boolean isChallengeResponseAuthentication() {
        return this.challengeResponseAuthentication;
    }

    public void setChallengeResponseAuthentication(boolean challengeResponseAuthentication) {
        this.challengeResponseAuthentication = challengeResponseAuthentication;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isFormAuthentication() {
        return this.formAuthentication;
    }

    public void setFormAuthentication(boolean formAuthentication) {
        this.formAuthentication = formAuthentication;
    }

    public String getFormUserField() {
        return this.formUserField;
    }

    public void setFormUserField(String formUserField) {
        this.formUserField = formUserField;
    }

    public String getFormPwdField() {
        return this.formPwdField;
    }

    public void setFormPwdField(String formPwdField) {
        this.formPwdField = formPwdField;
    }

    public JSSSOSiteRemoteUsers getRemoteUsers() {
        return this.remoteUsers;
    }

    public void setRemoteUsers(JSSSOSiteRemoteUsers remoteUsers) {
        this.remoteUsers = remoteUsers;
    }

    public void addRemoteUser(JSSSOSiteRemoteUser remoteUser) {
        if (this.remoteUsers == null) {
            this.remoteUsers = new JSSSOSiteRemoteUsers();
        }
        this.remoteUsers.add(remoteUser);
    }
}

