/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.profiler.rules.RuleCriterion;

public class JSRuleCriterion {
    private String name;
    private String type;
    private String value;
    private int fallBackOrder;
    private int fallBackType;
    private static final XMLFormat XML = new XMLFormat(JSRuleCriterion.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSRuleCriterion g = (JSRuleCriterion)o;
                xml.setAttribute("name", g.name);
                xml.add((Object)g.type, "type", String.class);
                xml.add((Object)g.value, "value", String.class);
                xml.add((Object)new Integer(g.fallBackOrder), "fallBackOrder", Integer.class);
                xml.add((Object)new Integer(g.fallBackType), "fallBackType", Integer.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSRuleCriterion g = (JSRuleCriterion)o;
                g.name = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", "unknown_name"));
                Object o1 = xml.get("type", String.class);
                if (o1 instanceof String) {
                    g.type = StringEscapeUtils.unescapeHtml((String)((String)o1));
                }
                if ((o1 = xml.get("value", String.class)) instanceof String) {
                    g.value = StringEscapeUtils.unescapeHtml((String)((String)o1));
                }
                if ((o1 = xml.get("fallBackOrder", String.class)) instanceof String) {
                    g.fallBackOrder = Integer.parseInt((String)o1);
                }
                if ((o1 = xml.get("fallBackType", String.class)) instanceof String) {
                    g.fallBackType = Integer.parseInt((String)o1);
                }
                while (xml.hasNext()) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public JSRuleCriterion() {
    }

    public JSRuleCriterion(RuleCriterion c) {
        this.name = c.getName();
        this.type = c.getType();
        this.value = c.getValue();
        this.fallBackOrder = c.getFallbackOrder();
        this.fallBackType = c.getFallbackType();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getFallBackOrder() {
        return this.fallBackOrder;
    }

    public void setFallBackOrder(int fallBackOrder) {
        this.fallBackOrder = fallBackOrder;
    }

    public int getFallBackType() {
        return this.fallBackType;
    }

    public void setFallBackType(int fallBackType) {
        this.fallBackType = fallBackType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

