/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.jetspeed.capabilities.MediaType;
import org.apache.jetspeed.serializer.objects.JSCapability;
import org.apache.jetspeed.serializer.objects.JSClientCapabilities;
import org.apache.jetspeed.serializer.objects.JSClientMimeTypes;
import org.apache.jetspeed.serializer.objects.JSMimeType;

public class JSMediaType {
    private String name;
    private int id;
    private String characterSet;
    private String title;
    private String description;
    private ArrayList capabilities;
    private ArrayList mimeTypes;
    private JSClientCapabilities capabilitiesString;
    private JSClientMimeTypes mimeTypesString;
    private static final XMLFormat XML = new XMLFormat(JSMediaType.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSMediaType g = (JSMediaType)o;
                xml.setAttribute("name", g.name);
                xml.add((Object)g.characterSet, "charcterSet", String.class);
                xml.add((Object)g.title, "title", String.class);
                xml.add((Object)g.description, "description", String.class);
                g.capabilitiesString = new JSClientCapabilities(g.putTokens(g.capabilities));
                g.mimeTypesString = new JSClientMimeTypes(g.putTokens(g.mimeTypes));
                xml.add((Object)g.capabilitiesString);
                xml.add((Object)g.mimeTypesString);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSMediaType g = (JSMediaType)o;
                g.name = StringEscapeUtils.unescapeHtml((String)xml.getAttribute("name", ""));
                Object o1 = xml.get("charcterSet", String.class);
                if (o1 != null && o1 instanceof String) {
                    g.characterSet = StringEscapeUtils.unescapeHtml((String)((String)o1));
                }
                g.title = StringEscapeUtils.unescapeHtml((String)((String)xml.get("title", String.class)));
                g.description = StringEscapeUtils.unescapeHtml((String)((String)xml.get("description", String.class)));
                while (xml.hasNext()) {
                    o1 = xml.getNext();
                    if (o1 instanceof JSClientCapabilities) {
                        g.capabilitiesString = (JSClientCapabilities)o1;
                        continue;
                    }
                    if (!(o1 instanceof JSClientMimeTypes)) continue;
                    g.mimeTypesString = (JSClientMimeTypes)o1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public JSMediaType() {
    }

    public JSMediaType(MediaType c) {
        this.id = c.getMediatypeId();
        this.name = c.getName();
        this.characterSet = c.getCharacterSet();
        this.title = c.getTitle();
        this.description = c.getDescription();
        this.capabilities = new ArrayList();
        this.mimeTypes = new ArrayList();
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String titel) {
        this.title = titel;
    }

    private String append(JSCapability capability) {
        return capability.getName();
    }

    private String append(JSMimeType mime) {
        return mime.getName();
    }

    private String append(Object s) {
        if (s instanceof JSCapability) {
            return this.append((JSCapability)s);
        }
        if (s instanceof JSMimeType) {
            return this.append((JSMimeType)s);
        }
        return s.toString();
    }

    private String putTokens(ArrayList _list) {
        if (_list == null || _list.size() == 0) {
            return "";
        }
        boolean _start = true;
        Iterator _it = _list.iterator();
        StringBuffer _sb = new StringBuffer();
        while (_it.hasNext()) {
            if (!_start) {
                _sb.append(',');
            } else {
                _start = false;
            }
            _sb.append(this.append(_it.next()));
        }
        return _sb.toString();
    }

    public List getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(ArrayList capabilities) {
        this.capabilities = capabilities;
    }

    public List getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(ArrayList mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public JSClientCapabilities getCapabilitiesString() {
        return this.capabilitiesString;
    }

    public JSClientMimeTypes getMimeTypesString() {
        return this.mimeTypesString;
    }
}

